% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_get_coip_pool_usage}
\alias{ec2_get_coip_pool_usage}
\title{Get Coip Pool Usage}
\usage{
ec2_get_coip_pool_usage(
  PoolId,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{PoolId}{String. The ID of the address pool.}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes the allocations from the specified
customer-owned address pool.
}
\section{PoolId}{

The ID of the address
pool.
}

\section{Filter}{


The filters. The following are the possible values:
\itemize{
\item \code{coip-address-usage.allocation-id}
}\if{html}{\out{<div class="{=html}">}}\preformatted{
}\if{html}{\out{</div>}}
\itemize{
\item \code{coip-address-usage.aws-account-id}
}\if{html}{\out{<div class="{=html}">}}\preformatted{
}\if{html}{\out{</div>}}
\itemize{
\item \code{coip-address-usage.aws-service}
}\if{html}{\out{<div class="{=html}">}}\preformatted{
}\if{html}{\out{</div>}}
\itemize{
\item \code{coip-address-usage.co-ip}
}
}

\section{MaxResults}{

The maximum number of results to return with a
single call. To retrieve the remaining results, make another call with
the returned \code{nextToken} value.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

