% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_tags}
\alias{ec2_create_tags}
\title{Create Tags}
\usage{
ec2_create_tags(
  ResourceId,
  Tag,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ResourceId}{List.   The IDs of the resources, separated by spaces.}

\item{Tag}{List. The tags.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Tags
}
\section{ResourceId}{


The IDs of the resources, separated by spaces.

Constraints: Up to 1000 resource IDs. We recommend breaking up this
request into smaller batches.
}

\section{Tag}{

The tags. The \code{value} parameter is required, but if
you don\'t want the tag to have a value, specify the parameter with no
value, and we set the value to an empty
string.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

