% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_reserved_instances_listing}
\alias{ec2_create_reserved_instances_listing}
\title{Create Reserved Instances Listing}
\usage{
ec2_create_reserved_instances_listing(
  ClientToken,
  InstanceCount,
  PriceSchedules,
  ReservedInstancesId,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ClientToken}{String. Unique, case-sensitive identifier you provide to ensure idempotency of your listings.}

\item{InstanceCount}{Integer. The number of instances that are a part of a Reserved Instance account to be listed in the Reserved...}

\item{PriceSchedules}{List. A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved...}

\item{ReservedInstancesId}{String. The ID of the active Standard Reserved Instance.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Reserved Instances Listing
}
\section{ClientToken}{

Unique, case-sensitive identifier you provide
to ensure idempotency of your listings. This helps avoid duplicate
listings. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.
}

\section{InstanceCount}{

The
number of instances that are a part of a Reserved Instance account to be
listed in the Reserved Instance Marketplace. This number should be less
than or equal to the instance count associated with the Reserved
Instance ID specified in this call.
}

\section{PriceSchedules}{

A list
specifying the price of the Standard Reserved Instance for each month
remaining in the Reserved Instance term.
}

\section{ReservedInstancesId}{

The ID of
the active Standard Reserved Instance.
}

