% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_launch_template}
\alias{ec2_create_launch_template}
\title{Create Launch Template}
\usage{
ec2_create_launch_template(
  LaunchTemplateName,
  LaunchTemplateData,
  DryRun = NULL,
  ClientToken = NULL,
  VersionDescription = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{LaunchTemplateName}{String. A name for the launch template.}

\item{LaunchTemplateData}{Object. The information for the launch template.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ClientToken}{String.   Unique, case-sensitive identifier you provide to ensure the idempotency of the request.[optional]}

\item{VersionDescription}{String. A description for the first version of the launch template.[optional]}

\item{TagSpecification}{List. The tags to apply to the launch template during creation.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Creates a launch template. A launch template
contains the parameters to launch an instance. When you launch an
instance using RunInstances, you can specify a launch template instead
of providing the launch parameters in the request. For more information,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html}{Launching an instance from a launch template}in
the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{LaunchTemplateName}{

A name for the launch
template.
}

\section{LaunchTemplateData}{

The information for the launch
template.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ClientToken}{


Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.

Constraint: Maximum 128 ASCII characters.
}

\section{VersionDescription}{

A description for the first version of the launch
template.
}

\section{TagSpecification}{

The tags to apply to the launch template
during creation.
}

