% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avar.r
\name{plot.avar}
\alias{plot.avar}
\title{Plot Allan Deviation}
\usage{
\method{plot}{avar}(
  x,
  units = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  col_ad = NULL,
  col_ci = NULL,
  nb_ticks_x = NULL,
  nb_ticks_y = NULL,
  legend_position = NULL,
  ci_ad = NULL,
  point_cex = NULL,
  point_pch = NULL,
  text_legend_cex = 1,
  ...
)
}
\arguments{
\item{x}{An \code{avar} object.}

\item{units}{A \code{string} that specifies the units of time plotted on the x axis.}

\item{xlab}{A \code{string} that gives a title for the x axis.}

\item{ylab}{A \code{string} that gives a title for the y axis.}

\item{main}{A \code{string} that gives an overall title for the plot.}

\item{col_ad}{A \code{string} that specifies the color of the line allan variance line.}

\item{col_ci}{A \code{string} that specifies the color of the shaded area covered by the confidence intervals.}

\item{nb_ticks_x}{An \code{integer} that specifies the maximum number of ticks for the x-axis.}

\item{nb_ticks_y}{An \code{integer} that specifies the maximum number of ticks for the y-axis.}

\item{legend_position}{A \code{string} that specifies the position of the legend (use \code{legend_position = NA} to remove legend).}

\item{ci_ad}{A \code{boolean} that determines whether to plot the confidence interval shaded area.}

\item{point_cex}{A \code{double} that specifies the size of each symbol to be plotted.}

\item{point_pch}{A \code{double} that specifies the symbol type to be plotted.}

\item{text_legend_cex}{A \code{double} that specifies the size of the legend text.}

\item{...}{Additional arguments affecting the plot.}
}
\value{
A plot of the Allan deviation and relative confidence interval for each scale.
}
\description{
Displays a plot of Allan variance with its corresponding pointwise confidence intervals.
}
\examples{
\donttest{
set.seed(999)
Xt = rnorm(10000)
av = avar(Xt)

plot(av)
plot(av, main = "Simulated white noise", xlab = "Scales")
plot(av, units = "sec", legend_position = "topright")
plot(av, col_ad = "darkred", col_ci = "pink")
}
}
\author{
Stephane Guerrier, Nathanael Claussen and Justin Lee
}
