% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av-package.r, R/avar.r
\docType{package}
\name{avar}
\alias{avar}
\alias{avar-package}
\title{avar}
\usage{
avar(x, type = "mo", freq = 1)
}
\arguments{
\item{x}{A \code{vec} of time series observations or an \code{imu} object.}

\item{type}{A \code{string} containing either \code{"mo"} for Maximal Overlap or \code{"to"} for Tau Overlap.}

\item{freq}{An \code{integer} with the frequency at which the error signal is measured.}
}
\value{
A \code{list} that contains:
\itemize{
 \item{"levels": }{The averaging time at each level.}
 \item{"allan": }{The estimated Allan variance.}
 \item{"type": }{Type of estimator (\code{mo} or \code{to}).}
}
}
\description{
This function estimates the Allan variance.
}
\details{
The decomposition and the amount of time it takes to perform this function depends on whether you are using
the Maximal Overlap or the Tau Overlap.
}
\section{Maximal Overlap Allan Variance}{

Given \eqn{N} equally spaced samples with averaging time \eqn{\tau = n\tau _0}{tau = n*tau_0},
we define \eqn{n} as an integer such that \eqn{ 1 \le n \le \frac{N}{2}}{1<= n <= N/2}.
Therefore, \eqn{n} can be selected from \eqn{\left\{ {n|n < \left\lfloor {{{\log }_2}\left( N \right)} \right\rfloor } \right\}}{{n | n < floor(log2(N))}}
Based on the latter, we have \eqn{M = N - 2n} levels of decomposition.
The Maximal-overlap estimator is given by:
\deqn{\frac{1}{{2\left( {N - 2k + 1} \right)}}\sum\limits_{t = 2k}^N {{{\left[ {{{\bar Y}_t}\left( k \right) - {{\bar Y}_{t - k}}\left( k \right)} \right]}^2}} }{See PDF Manual}

where \deqn{ {{\bar y}_t}\left( \tau  \right) = \frac{1}{\tau }\sum\limits_{i = 0}^{\tau  - 1} {{{\bar y}_{t - i}}} }{See PDF Manual}.
}

\section{Tau-Overlap Allan Variance}{

Given \eqn{N} equally spaced samples with averaging time \eqn{\tau = n\tau _0}{tau = n*tau_0},
we define \eqn{n} as an integer such that \eqn{ 1 \le n \le \frac{N}{2}}{1<= n <= N/2}.
Therefore, \eqn{n} can be selected from \eqn{\left\{ {n|n < \left\lfloor {{{\log }_2}\left( N \right)} \right\rfloor } \right\}}{{n | n < floor(log2(N))}}
Based on the latter, we have \eqn{m = \left\lfloor {\frac{{N - 1}}{n}} \right\rfloor  - 1} levels of decomposition.
The tau-overlap estimator is given by:

where \eqn{ {{\bar y}_t}\left( \tau  \right) = \frac{1}{\tau }\sum\limits_{i = 0}^{\tau  - 1} {{{\bar y}_{t - i}}} }{See PDF Manual}.
}

\examples{
set.seed(999)
Xt = rnorm(10000)
av_mat_mo = avar(Xt, type = "mo", freq = 100)
av_mat_tau = avar(Xt, type = "to")

}
\references{
Long-Memory Processes, the Allan Variance and Wavelets, D. B. Percival and P. Guttorp
}
\keyword{internal}
