% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fft.R
\name{read_audio_fft}
\alias{read_audio_fft}
\alias{read_audio_bin}
\title{Read audio binary and frequency data}
\usage{
read_audio_fft(
  audio,
  window = hanning(1024),
  overlap = 0.75,
  sample_rate = NULL
)

read_audio_bin(audio, channels = NULL, sample_rate = NULL)
}
\arguments{
\item{audio}{path to the audio file}

\item{window}{vector with weights defining the moving \link[=hanning]{fft window function}.
The length of this vector is the size of the window and hence determines the output
frequency range.}

\item{overlap}{value between 0 and 1 of overlap proportion between moving fft windows}

\item{sample_rate}{downsample audio to reduce FFT output size. Default keeps sample
rate from the input file.}

\item{channels}{number of output channels, set to 1 to conver to mono sound}
}
\description{
Fast implementation to read audio files in any format. Use \link{read_audio_bin} to read
raw audio samples, and \link{read_audio_fft} to stream-convert directly to frequency domain
(spectrum data) using FFmpeg built-in FFT.
}
\details{
Use the \code{plot()} method on data returned by \link{read_audio_fft} to show the spectrogram.
The \link{av_spectrogram_video} generates a video based on the spectrogram with a moving bar
and background audio.
}
\examples{
# Use a 5 sec fragment
wonderland <- system.file('samples/Synapsis-Wonderland.mp3', package='av')
av_audio_convert(wonderland, 'example.mp3', total_time = 5)

# Read as frequency spectrum
fft_data <- read_audio_fft('example.mp3')
dim(fft_data)

# Plot the spectrogram
plot(fft_data)

# Show other parameters
dim(read_audio_fft('example.mp3', hamming(2048)))
dim(read_audio_fft('example.mp3', hamming(4096)))

# Cleanup
unlink('example.mp3')
}
