% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI$summary_rank_plot}
\alias{AUTO_VI$summary_rank_plot}
\title{Draw a summary rank plot for the result}
\arguments{
\item{vss}{Numeric. Observed visual signal strength.}

\item{null_dist}{Numeric. Null visual signal strength.}

\item{p_value}{Numeric. P-value of the visual test. See also
\code{\link[=AUTO_VI$p_value]{AUTO_VI$p_value()}}.}
}
\value{
A \code{ggplot}.
}
\description{
This function draws a summary rank plot for the result.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{AUTO_VI$summary_plot(
  vss = self$check_result$observed$vss,
  null_dist = self$check_result$null$vss,
  p_value = self$check_result$p_value
)
}\if{html}{\out{</div>}}
}
}
\examples{
keras_model <- try(get_keras_model("vss_phn_32"))
if (!inherits(keras_model, "try-error")) {
  myvi <- auto_vi(lm(dist ~ speed, data = cars), keras_model)

  myvi$lineup_check()
  myvi$summary_rank_plot()
}

}
