% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/compete.r
\name{compete}
\alias{compete}
\title{Returns the winning model}
\usage{
compete(best, challenger, compare_outliers)
}
\arguments{
\item{best}{A model given as a list with at least the properties \code{model_score, nr_dummy_variables,} and \code{bucket}.}

\item{challenger}{Another model, also given as a list with properties \code{model_score, nr_dummy_variables,} and \code{bucket}.}

\item{compare_outliers}{A boolean. When \code{FALSE}, the model comparison does not take the number of dummy variables into account.}
}
\value{
This function returns the best model of the two given models.
}
\description{
This function returns the best model as explained in the documentation for the \code{autovar} function.
}
\examples{
model1 <- list(logtransformed = FALSE, lag = 1, nr_dummy_variables = 1,
               model_score = 100, bucket = 0.05)
model2 <- list(logtransformed = FALSE, lag = 2, nr_dummy_variables = 2,
               model_score = 200, bucket = 0.01)
autovarCore:::compete(model1, model2, TRUE)
}

