% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_constructors.R
\name{stack_threshed_img}
\alias{stack_threshed_img}
\title{Stack-thresholded image class.}
\usage{
stack_threshed_img(img, thresh, fail_value, stack_thresh_method)
}
\arguments{
\item{img}{A 4-dimensional array in the style of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, channel, frame]})
or a 3-dimensional array which is a single channel of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, frame]}).}

\item{thresh}{The threshold that was used. Either a number or an object of
class \link{th}.}

\item{fail_value}{The value to which elements of the array which failed the
thresholding were set.}

\item{stack_thresh_method}{This must be set to either \code{"mean"} or \code{"median"}
to tell which stacked-thresholding method was employed.}
}
\value{
An object of class \code{stack_threshed_img}.
}
\description{
A stack-thresholded array is an array which has had stack-thresholding
applied to it. See \code{\link[=mean_stack_thresh]{mean_stack_thresh()}}. It has 3 necessary attributes:
\itemize{ \item \code{thresh} is the threshold that was applied. This is either a
number or an object of class \link{th}. Values in the original array which were
less than this value are deemed to have failed the thresholding. \item
\code{fail_value} is the value to which elements of the array which failed the
thresholding were set. This could be something like \code{0} or \code{NA}.  \item
\code{stack_thresh_method} details which stacked-thresholding method was employed;
this is either \code{"mean"} or \code{"median"}. }
}
\seealso{
\link{threshed_arr}, \code{\link[=mean_stack_thresh]{mean_stack_thresh()}}, \code{\link[=med_stack_thresh]{med_stack_thresh()}}.
}
