% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{am_map_range}
\alias{am_map_range}
\title{Get a range of map items by key}
\usage{
am_map_range(doc, obj, begin = "", end = "", heads = NULL)
}
\arguments{
\item{doc}{An Automerge document}

\item{obj}{An Automerge object ID (must be a map), or \code{AM_ROOT}}

\item{begin}{Start key (inclusive). Use \code{""} (default) for unbounded start.}

\item{end}{End key (inclusive). Use \code{""} (default) for unbounded end.}

\item{heads}{Optional list of change hashes (raw vectors) for historical
query. If \code{NULL} (default), uses the current state.}
}
\value{
A named list of values in the key range.
}
\description{
Returns map entries whose keys fall within the lexicographic range
\verb{[begin, end]} (inclusive on both sides).
}
\examples{
doc <- am_create()
doc$a <- 1
doc$b <- 2
doc$c <- 3
doc$d <- 4

# Get entries with keys in [b, c] -> b and c
range <- am_map_range(doc, AM_ROOT, "b", "c")
names(range)  # "b" "c"

# Get all entries
all <- am_map_range(doc, AM_ROOT, "", "")

am_close(doc)

}
