% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_models.R
\name{plot_PImap}
\alias{plot_PImap}
\title{Plot The Person-Item Map}
\usage{
plot_PImap(
  obj,
  main = NULL,
  xlab = NULL,
  cex = NULL,
  cex.lab = NULL,
  cex.axis = NULL,
  cex.main = NULL,
  lwd = NULL,
  v = NULL,
  th_dif = 1e-05
)
}
\arguments{
\item{obj}{The object of class \code{'pcm'}.}

\item{main}{main title of the plot; see \code{\link[graphics:plot.default]{plot.default()}}.}

\item{xlab}{Label for the x-axis; see \code{\link[graphics:plot.default]{plot.default()}}.}

\item{cex}{A numerical value giving the amount by which plotting text and symbols should be magnified relative to the default;
see \code{\link[graphics:par]{par()}}.}

\item{cex.lab}{The magnification to be used for x and y labels relative to the current setting of cex;
see \code{\link[graphics:par]{par()}}.}

\item{cex.axis}{The magnification to be used for axis annotation relative to the current setting of cex;
see \code{\link[graphics:par]{par()}}.}

\item{cex.main}{The magnification to be used for main titles relative to the current setting of cex;
see \code{\link[graphics:par]{par()}}.}

\item{lwd}{The line width, a positive number, defaulting to 1;
see \code{\link[graphics:par]{par()}}.}

\item{v}{Variable names used}

\item{th_dif}{The threshold at which a DIF effect is still considered a DIF.}
}
\value{
There are no values to return. Instead, it shows a graphical map of the estimated ability and the estimated difficulty on the same scale.
}
\description{
This function maps the distribution of the persons' abilities and the items difficulties along the latent continuum.
}
\examples{
\dontrun{
groupsMap <- matrix(c(rep(1,50),rep(0,50)),ncol = 1, dimnames = list(c(1:100),c("V1")))
pcmdif_res <- pcm_dif(shortDIF, groups_map = groupsMap)
plot_PImap(pcmdif_res)
}

}
