% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_auc.R
\name{score_one_minus_auc}
\alias{score_one_minus_auc}
\title{One minus Area Under ROC Curve (AUC)}
\usage{
score_one_minus_auc(object, data = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{explainer} created with function \code{\link[DALEX]{explain}} from the DALEX package.}

\item{data}{New data that will be used to calcuate the score. Pass \code{NULL} if you want to use \code{data} from \code{object}.}

\item{...}{Other arguments dependent on the type of score.}
}
\value{
An object of class \code{auditor_score}.
}
\description{
One minus Area Under Curve (AUC) for Receiver Operating Characteristic.
}
\examples{
titanic <- na.omit(DALEX::titanic)
titanic$survived <- titanic$survived == "yes"

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic)

#create an explainer
exp_glm <- DALEX::explain(model_glm, y = titanic$survived)

# calculate score
score_one_minus_auc(exp_glm)


}
