% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.auditor_model_evaluation}
\alias{print.auditor_model_evaluation}
\title{Prints Model Evaluation Summary}
\usage{
\method{print}{auditor_model_evaluation}(x, ...)
}
\arguments{
\item{x}{an object \code{auditor_model_evaluation} created with \code{\link{model_evaluation}} function.}

\item{...}{other parameters}
}
\description{
Prints Model Evaluation Summary
}
\examples{
titanic <- na.omit(DALEX::titanic)
titanic$survived <- titanic$survived == "yes"

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic)

# use DALEX package to wrap up a model into explainer
exp_glm <- DALEX::explain(model_glm, data= titanic, y = titanic$survived,
                          predict_function = function(m, d)predict(m, newdata=d, type="response"))

# validate a model with auditor
library(auditor)
model_evaluation(exp_glm)


}
