% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotD3_rec.R
\name{plotD3_rec}
\alias{plotD3_rec}
\alias{plotD3REC}
\title{Regression Error Characteristic Curves (REC) in D3 with r2d3 package.}
\usage{
plotD3_rec(object, ..., scale_plot = FALSE)

plotD3REC(object, ..., scale_plot = FALSE)
}
\arguments{
\item{object}{An object of class 'auditor_model_residual' created with \code{\link{model_residual}} function.}

\item{...}{Other 'auditor_model_residual' objects to be plotted together.}

\item{scale_plot}{Logical, indicates whenever the plot should scale with height. By default it's FALSE.}
}
\value{
a `r2d3` object.
}
\description{
Error Characteristic curves are a generalization of ROC curves.
On the x axis of the plot there is an error tolerance and on the y axis there is a percentage
of observations predicted within the given tolerance.
}
\details{
REC curve estimates the Cumulative Distribution Function (CDF) of the error

Area Over the REC Curve (REC) is a biased estimate of the expected error
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# use DALEX package to wrap up a model into explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
library(auditor)
mr_lm <- model_residual(exp_lm)
plotD3_rec(mr_lm)

library(randomForest)
model_rf <- randomForest(life_length~., data = dragons)
exp_rf <- DALEX::explain(model_rf, data = dragons, y = dragons$life_length)
mr_rf <- model_residual(exp_rf)
plotD3_rec(mr_lm, mr_rf)

}
\references{
Bi J., Bennett K.P. (2003). Regression error characteristic curves, in: Twentieth
International Conference on Machine Learning (ICML-2003), Washington, DC.
}
\seealso{
\code{\link{plot_rec}}
}
