% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLIFT.R
\name{plotLIFT}
\alias{plotLIFT}
\title{LIFT}
\usage{
plotLIFT(object, ...)
}
\arguments{
\item{object}{An object of class modelAudit or modelEvaluation.}

\item{...}{Other modelAudit objects to be plotted together.}
}
\value{
ggplot object
}
\description{
LIFT is a plot of the rate of positive prediction against true positive rate for the different thresholds.
It is useful for measuring and comparing the accuracy of the classificators.
}
\examples{
library(mlbench)
data("PimaIndiansDiabetes")
Pima <- PimaIndiansDiabetes
Pima$diabetes <- ifelse(Pima$diabetes == "pos", 1, 0)
glm_model <- glm(diabetes~., family=binomial,	data=Pima)
glm_au <- audit(glm_model, data = Pima, y = Pima$diabetes)
plotLIFT(glm_au)

}
\seealso{
\code{\link{plot.modelAudit}}
}
