% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attrCUSUM_getxxx_and_utils.R
\name{XtToCt}
\alias{XtToCt}
\title{Convert from Data to FSI CUSUM Statistic}
\usage{
XtToCt(Xt, refv, c.zero = 0, maxndec = 7L)
}
\arguments{
\item{Xt}{A non-negative integer-valued vector of count process of interest.}

\item{refv}{A reference value of CUSUM statistic.}

\item{c.zero}{An initial state of CUSUM statistic (default is 0).}

\item{maxndec}{The maximum number of decimal places
of \code{refv} (\eqn{\le} 7L).}
}
\value{
A time-series object of
   CUSUM statistic for monitoring of mean increase.
}
\description{
Conversion of data to FSI CUSUM statistic
   for monitoring of mean increase.
}
\details{
For CUSUM control chart for detecting mean increase,
   the CUSUM statistic \eqn{(C_{t})} are defined as following:
   \deqn{C_{t}=max(C_{t-1}, 0) + X_{t} - refv,  t=1,2,...,}
   wherein \eqn{X_{t}} is a count process of interest.
}
\examples{
# Example 1: Poisson distribution
Ct <- XtToCt(Xt = rpois(200L, 4), refv = 5, c.zero = 0)
plot(Ct, type = "o", pch = 16, main = "CUSUM statistic",
     ylab = expression(C[t]),
     sub = expression(paste(C[t],"=", "max(",C[t - 1],",",0,")",
                            "+ refv -",X[t])))
}

