% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dependencies_file.R
\name{create_dependencies_file}
\alias{create_dependencies_file}
\title{Create a dependencies.R in the `inst` folder}
\usage{
create_dependencies_file(
  path = "DESCRIPTION",
  field = c("Depends", "Imports"),
  to = "inst/dependencies.R",
  open_file = TRUE,
  ignore_base = TRUE
)
}
\arguments{
\item{path}{path to the DESCRIPTION file}

\item{field}{DESCRIPTION field to parse, "Import" and "Depends" by default. Can add "Suggests"}

\item{to}{path to dependencies.R. "inst/dependencies.R" by default}

\item{open_file}{Logical. Open the file created in an editor}

\item{ignore_base}{Logical. Whether to ignore package coming with base, as they cannot be installed}
}
\value{
Used for side effect. Shows a message with installation instructions and
creates a R file containing these instructions.
}
\description{
Create a dependencies.R in the `inst` folder
}
\examples{
tmpdir <- tempdir()
file.copy(system.file("dummypackage",package = "attachment"), tmpdir,
 recursive = TRUE)
dummypackage <- file.path(tmpdir, "dummypackage")
# browseURL(dummypackage)

create_dependencies_file(path = file.path(dummypackage,"DESCRIPTION"),
to = file.path(dummypackage, "inst/dependencies.R"),
open_file = FALSE)
}
