% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-add-polygon-overview.R
\name{plot_add_polygon_overview}
\alias{plot_add_polygon_overview}
\title{Add spatial representation of polygon layout to a ggplot2 object.}
\usage{
plot_add_polygon_overview(plot, bgm_as_df, polygon_overview = 0.2)
}
\arguments{
\item{plot}{ggplot2 object. Can be a ggplot grob.}

\item{bgm_as_df}{*.bgm file converted to a dataframe. Please use \code{\link{convert_bgm}}
to convert your bgm-file to a dataframe with columns 'lat', 'long', 'inside_lat',
'inside_long' and 'polygon'.}

\item{polygon_overview}{numeric value between 0 and 1 indicating the size used to plot the polygon overview in the
upper right corner of the plot. Default is \code{0.2}.}
}
\value{
ggplot grob
}
\description{
Add spatial representation of polygon layout to a ggplot2 object.
}
\examples{
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
bgm_as_df <- convert_bgm(bgm = file.path(d, "VMPA_setas.bgm"))

p <- plot_line(preprocess$physics, wrap = NULL)
p <- custom_grid(p, grid_x = "polygon", grid_y = "variable")

grob <- plot_add_polygon_overview(p, bgm_as_df)
gridExtra::grid.arrange(grob)
}
