#' add_name_to_tests
#'
#' Helper-function to add a field to a list or data.frame
#'
#' Not intended to be called by the user.
#'
#' checks if the new field already exists
#' @param x an object
#' @param name a value
#' @param colname_for_variable a character length 1. Default is defined in atable_options
#' @param ... passed to methods
#'
#' @return x now with new field colname_for_variable
#'
#'
#'
#' @export
add_name_to_tests <- function(x, name, ...) {
# add a column to a data.frame x with value name as character
UseMethod("add_name_to_tests")
}

#' @export
#' @describeIn add_name_to_tests apply add_name_to_statistics to all field of the list
add_name_to_tests.list <- function(x, name, ...) {
  return(lapply(x, add_name_to_tests, name, ...))
}

#' @export
#' @describeIn add_name_to_tests add field colname_for_variable to the data.frame. chekc for a name clash as this field as there are many user-defined fields
add_name_to_tests.data.frame <- function(x, name, colname_for_variable = atable_options("colname_for_variable"), ...) {
  # the colnames of x are generated by format_tests(), which is user defined.
  # there may be name clashes with atable_options('colname_for_variable')
  b <- colname_for_variable %in% colnames(x)
  if (b) {
    stop("Name clash. ", colname_for_variable, " already in ", paste(colnames(x),
                                                                     collapse = ", "), ". Please change atable_options('colname_for_variable')")
  }

  x[[colname_for_variable]] <- name
  return(x)
}

