% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy.plot.R
\name{accuracy.plot}
\alias{accuracy.plot}
\title{Make a boxplot (ggplot2 style) of assignment accuracy from cross-validation results}
\usage{
accuracy.plot(df, pop = "all")
}
\arguments{
\item{df}{A dataframe of your assignment accuracy results. It could be the object returned from the function accuracy.MC() or accuracy.kfold() or a data frame imported to R via other functions (e.g., read.table(...)).}

\item{pop}{Population names (one or multiple string characters) for making the plot. By default, it uses "all", meaning overall assignment accuracies. It creates faceted plot with one population per panel, if multiple population names are given. The specified population name should match what you entered in read.genpop() earlier.}
}
\value{
This function returns a boxplot plot using the ggplot2 library. Users can modified the plot (e.g., change color, text, etc.) using functions provided by ggplot2 library.
}
\description{
This functions allows you to make a boxplot of assignment accuracies estimated from Monte-Carlo or K-fold cross-validation results.
}
\examples{
Your_df <- read.table(system.file("extdata/Rate.txt", package="assignPOP"), header=TRUE)
accuracy.plot(Your_df, pop="all")
}

