% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert}
\alias{assert}
\alias{assert_}
\title{Raises error if predicate is FALSE in any columns selected}
\usage{
assert(data, predicate, ..., error_fun = assertr_stop)

assert_(data, predicate, ..., .dots, error_fun = assertr_stop,
  .nameofpred = "")
}
\arguments{
\item{data}{A data frame}

\item{predicate}{A function that returns FALSE when violated}

\item{...}{Comma separated list of unquoted expressions.
Uses dplyr's \code{select} to select
columns from data.}

\item{error_fun}{Function to call if assertion fails. Takes one error
string. Uses \code{stop} by default}

\item{.dots}{Use assert_() to select columns using standard evaluation.}

\item{.nameofpred}{Text representation of predicate for printing in case
of assertion violation. Will automatically be retrieved if left
blank (default)}
}
\value{
data if predicate assertion is TRUE. error if not.
}
\description{
Meant for use in a data analysis pipeline, this function will
just return the data it's supplied if there are no FALSEs
when the predicate is applied to every element of the columns
indicated. If any element in any of the columns, when applied
to the predicate, is FALSE, then this function will raise an
error, effectively terminating the pipeline early.
}
\note{
See \code{vignette("assertr")} for how to use this in context
}
\examples{

# returns mtcars
assert(mtcars, not_na, vs)

# equivalent statements using standard evaluation
assert_(mtcars, not_na, "vs")
var <- "vs"
assert_(mtcars, not_na, var)

# return mtcars
assert(mtcars, not_na, mpg:carb)

# equivalent using standard evaluation
assert_(mtcars, not_na, "mpg:carb")


library(magrittr)                    # for piping operator

mtcars \%>\%
  assert(in_set(c(0,1)), vs)
  # anything here will run

\dontrun{
mtcars \%>\%
  assert(in_set(c(1, 2, 3, 4, 6)), carb)
  # the assertion is untrue so
  # nothing here will run}

}
\seealso{
\code{\link{verify}} \code{\link{insist}}
         \code{\link{assert_rows}} \code{\link{insist_rows}}
}

