% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-type.R, R/is-type.R
\name{assert_is_factor}
\alias{assert_is_factor}
\alias{assert_is_ordered}
\alias{is_factor}
\alias{is_ordered}
\title{Is the input an factor?}
\usage{
assert_is_factor(x)

assert_is_ordered(x)

is_factor(x, .xname = get_name_in_parent(x))

is_ordered(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_factor} wraps \code{is.factor}, providing more
information on failure.  \code{assert_is_factor} returns nothing
but throws an error if \code{is_factor} returns \code{FALSE}.
}
\description{
Checks to see if the input is an factor.
}
\examples{
assert_is_factor(factor(sample(letters, 10)))
}
\seealso{
\code{\link[base]{is.factor}}.
}

