% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-connection.R, R/is-connection.R
\name{assert_is_bzfile_connection}
\alias{assert_is_bzfile_connection}
\alias{assert_is_connection}
\alias{assert_is_fifo_connection}
\alias{assert_is_file_connection}
\alias{assert_is_gzfile_connection}
\alias{assert_is_incomplete_connection}
\alias{assert_is_open_connection}
\alias{assert_is_pipe_connection}
\alias{assert_is_readable_connection}
\alias{assert_is_socket_connection}
\alias{assert_is_stderr}
\alias{assert_is_stdin}
\alias{assert_is_stdout}
\alias{assert_is_terminal_connection}
\alias{assert_is_text_connection}
\alias{assert_is_unz_connection}
\alias{assert_is_url_connection}
\alias{assert_is_writable_connection}
\alias{assert_is_xzfile_connection}
\alias{is_bzfile_connection}
\alias{is_connection}
\alias{is_fifo_connection}
\alias{is_file_connection}
\alias{is_gzfile_connection}
\alias{is_incomplete_connection}
\alias{is_open_connection}
\alias{is_pipe_connection}
\alias{is_readable_connection}
\alias{is_socket_connection}
\alias{is_stderr}
\alias{is_stdin}
\alias{is_stdout}
\alias{is_terminal_connection}
\alias{is_text_connection}
\alias{is_unz_connection}
\alias{is_url_connection}
\alias{is_writable_connection}
\alias{is_xzfile_connection}
\title{Is the input a connection?}
\usage{
assert_is_bzfile_connection(x)

assert_is_connection(x)

assert_is_fifo_connection(x)

assert_is_file_connection(x)

assert_is_gzfile_connection(x)

assert_is_incomplete_connection(x)

assert_is_open_connection(x, rw = "")

assert_is_pipe_connection(x)

assert_is_readable_connection(x)

assert_is_socket_connection(x)

assert_is_stderr(x)

assert_is_stdin(x)

assert_is_stdout(x)

assert_is_terminal_connection(x)

assert_is_text_connection(x)

assert_is_unz_connection(x)

assert_is_url_connection(x)

assert_is_writable_connection(x)

assert_is_xzfile_connection(x)

is_bzfile_connection(x, .xname = get_name_in_parent(x))

is_connection(x, .xname = get_name_in_parent(x))

is_fifo_connection(x, .xname = get_name_in_parent(x))

is_file_connection(x, .xname = get_name_in_parent(x))

is_gzfile_connection(x, .xname = get_name_in_parent(x))

is_incomplete_connection(x, .xname = get_name_in_parent(x))

is_open_connection(x, rw = "", .xname = get_name_in_parent(x))

is_pipe_connection(x, .xname = get_name_in_parent(x))

is_readable_connection(x, .xname = get_name_in_parent(x))

is_socket_connection(x, .xname = get_name_in_parent(x))

is_stderr(x, .xname = get_name_in_parent(x))

is_stdin(x, .xname = get_name_in_parent(x))

is_stdout(x, .xname = get_name_in_parent(x))

is_terminal_connection(x, .xname = get_name_in_parent(x))

is_text_connection(x, .xname = get_name_in_parent(x))

is_unz_connection(x, .xname = get_name_in_parent(x))

is_url_connection(x, .xname = get_name_in_parent(x))

is_writable_connection(x, .xname = get_name_in_parent(x))

is_xzfile_connection(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{rw}{Read-write status of connection.  Passed to \code{isOpen}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_connection} checks for objects of class "connection".
\code{is_open_connection} and \code{is_incomplete_connection} wrap
\code{isOpen} and \code{isIncomplete} respectively, providing more
information on failure.
\code{is_readable_connection} and \code{is_writable_connection} tell you
whether the connection is readable from or writable to.
\code{is_bzfile_connection}, \code{is_fifo_connection},
\code{is_file_connection}, \code{is_pipe_connection},
\code{is_socket_connection}, \code{is_stderr}, \code{is_stdin},
\code{is_stdout}, \code{is_text_connection}, \code{is_unz_connection},
\code{is_url_connection} and \code{is_xzfile_connection} give more
specific tests on the type of connection.
The \code{assert_*} functions return nothing but throw an error if the
corresponding \code{is_*} function returns \code{FALSE}.
}
\description{
Various checks to see if the input is a (particular type of/open/incomplete)
connection.
}
\note{
\code{is_incomplete_connection} will return false for closed
connections, regardless of whether or not the connection ends with a newline
character.
(\code{isIncomplete} throws an error for closed connections.)
}
\examples{
assert_is_terminal_connection(stdin())
assert_is_readable_connection(stdin())
assert_is_open_connection(stdin())
assert_is_stdin(stdin())
# Next line is usually true but, e.g., devtools::run_examples overrides it
dont_stop(assert_is_terminal_connection(stdout()))
assert_is_writable_connection(stdout())
assert_is_open_connection(stdout())
assert_is_stdout(stdout())
assert_is_terminal_connection(stderr())
assert_is_writable_connection(stderr())
assert_is_open_connection(stderr())
assert_is_stderr(stderr())
tcon <- textConnection("txt", "w", local = TRUE)
assert_is_text_connection(tcon)
assert_is_open_connection(tcon)
cat("this has no final newline character", file = tcon)
assert_is_incomplete_connection(tcon)
close(tcon)
#These examples should fail.
dont_stop(assert_is_connection("not a connection"))
dont_stop(assert_is_readable_connection(stdout()))
dont_stop(assert_is_writable_connection(stdin()))
\dontrun{
fcon <- file()
close(fcon)
assert_is_open_connection(fcon)
}
}
\seealso{
\code{\link[base]{isOpen}}.
}

