% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-code.R, R/is-code.R
\name{assert_all_are_valid_variable_names}
\alias{assert_all_are_valid_variable_names}
\alias{assert_any_are_valid_variable_names}
\alias{is_valid_variable_name}
\title{Is the string a valid variable name?}
\usage{
assert_all_are_valid_variable_names(x, allow_reserved = TRUE,
  allow_duplicates, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_valid_variable_names(x, allow_reserved = TRUE,
  allow_duplicates, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

is_valid_variable_name(x, allow_reserved = TRUE, allow_duplicates)
}
\arguments{
\item{x}{Input to check.}

\item{allow_reserved}{If \code{TRUE} then "..." and "..1", "..2", etc.
are considered valid.}

\item{allow_duplicates}{Deprecated and ignored.}

\item{na_ignore}{A logical value.  If \code{FALSE}, \code{NA} values
cause an error; otherwise they do not.  Like \code{na.rm} in many
stats package functions, except that the position of the failing
values does not change.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}
}
\value{
The \code{assert_*} functions return nothing but throw an error if the
corresponding \code{is_*} function returns \code{FALSE}.
}
\description{
Checks strings to see if they are valid variable names.
}
\examples{
make_random_string <- function(n)
{
  paste0(sample(letters, n, replace = TRUE), collapse = "")
}
long <- c(make_random_string(10000), make_random_string(10001))
x <- c("x", "y_y0.Y", ".", "x y", "...", "..1", long)
unname(is_valid_variable_name(x))
unname(is_valid_variable_name(x, allow_reserved = FALSE))
#These examples should fail.
assertive.base::dont_stop(
  assert_all_are_valid_variable_names(c("...", "..1"), allow_reserved = FALSE)
)
}
\references{
\url{http://4dpiecharts.com/2011/07/04/testing-for-valid-variable-names/}
}
\seealso{
\code{\link{make.names}}.
}

