% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{assert}
\alias{assert}
\title{Assert that conditions are met}
\usage{
assert(..., msg = NULL, call = rlang::caller_env())
}
\arguments{
\item{...}{a list of conditions to check}

\item{msg}{A character string containing the error message to display if any of the conditions are not met. The string can include the placeholder {failed_expressions} to insert a list of the failed expressions. The string can also include {?s} and {?is/are} to insert the correct pluralization for the list of failed expressions.}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}
}
\value{
invisible(TRUE) if all conditions are met, otherwise aborts with the error message specified by msg
}
\description{
Assert that conditions are met
}
\examples{
try({
assert(1 == 1) # Passes
assert(2 == 2, 3 == 3) # Passes
assert(2 == 1, 3 == 3) # Throws default error
assert(2 == 1, 3 == 3, msg = "Custom error message") # Throws custom error
})

}
\concept{assert_create}
