% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeLlamaExps.R
\name{summarizeLlamaExps}
\alias{summarizeLlamaExps}
\title{Creates summary data.table for runLlamaModel experiments.}
\usage{
summarizeLlamaExps(
  reg,
  ids = findSubmitted(),
  fun = function(job, res) {
     return(list(succ = res$succ, par10 = res$par10, mcp =
    res$mcp))
 },
  missing.val = list(succ = 0, par10 = Inf, mcp = Inf)
)
}
\arguments{
\item{reg}{[\code{\link{Registry}}]\cr
batchtools registry.}

\item{ids}{[\code{data.table}]\cr
Selected job ids. Default is all submitted jobs.}

\item{fun}{[\code{function()}]\cr
Function to aggregate results with. Default is a function
that returns succ, par10 and mcp values.
For a detailed description, see [\link{reduceResultsList}].}

\item{missing.val}{[\code{list(1)}]\cr
List with defaults for missing values that are needed for
aggregation.
For a detailed description, see [\link{reduceResultsList}].}
}
\value{
[\code{data.table}].
}
\description{
Creates summary data.table for runLlamaModel experiments.
}
