% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{expect_snapshot_r_process}
\alias{expect_snapshot_r_process}
\title{testthat snapshot test with asciicast}
\usage{
expect_snapshot_r_process(
  ...,
  interactive = TRUE,
  echo = TRUE,
  startup = NULL,
  transform = NULL,
  variant = NULL
)
}
\arguments{
\item{...}{Code to run (unnamed arguments) and arguments to pass to
\code{\link[=record_output]{record_output()}} (named arguments). The code is evaluated in a new
asciicast subprocess. Their output is returned and used in a testthat
snapshot test.}

\item{interactive}{Whether to use an interactive R process to evaluate
the code.}

\item{echo}{Whether to echo the code in the subprocess before running
it.}

\item{startup}{Expression to evaluate in the subprocess before
recording the snapshot. By default it loads and attaches the calling
package, including its internal functions.}

\item{transform}{Passed to \code{\link[testthat:expect_snapshot]{testthat::expect_snapshot()}}.}

\item{variant}{Passed to \code{\link[testthat:expect_snapshot]{testthat::expect_snapshot()}}.}
}
\description{
This function is very similar to \code{\link[testthat:expect_snapshot_output]{testthat::expect_snapshot_output()}},
but it runs the code in an asciciast subprocess, uwing \code{\link[=record_output]{record_output()}}.
}
\details{
THe \code{Code} part of the snapshot is always the same, but the
\code{Output} part shows the code, assuming \code{echo = TRUE} (the default).
}
\examples{
\dontshow{if (!asciicast:::is_rcmd_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
Sys.getpid()
testthat::local_edition(3)
expect_snapshot_r_process(Sys.getpid())
\dontshow{\}) # examplesIf}
}
