*-------------------------------------------------------------------------*
|              SAS DATA DEFINITION STATEMENTS FOR ICPSR 9028              |
|                                                                         |
|          UNIFORM CRIME REPORTING PROGRAM DATA: [UNITED STATES]          |
|                                                                         |
|               PART #4: Police Employee (LEOKA) Data, 1980               |
|                                                                         |
|                                                                         |
| This SAS setup file contains the following statements:                  |
|                                                                         |
| PROC FORMAT:  Creates user-defined formats. Formats replace original    |
| value codes with value code descriptions. Formats may not be present    |
| for all variables in the data file.                                     |
|                                                                         |
| DATA:  Begins a SAS data step and names an output SAS data set.         |
|                                                                         |
| INFILE:  Specifies the input data file to be read with the input        |
| statement. Users must replace "file-specification" with a complete      |
| statement of the location of the data file.                             |
|                                                                         |
| INPUT:  Assigns the name, type, decimal specification (if any), and     |
| identifies variable beginning and ending column locations.              |
|                                                                         |
| LABEL:  Assigns descriptive labels to variables. Variable labels and    |
| variable names may be identical for certain variables.                  |
|                                                                         |
| FORMAT:  Associates the formats created by the PROC FORMAT step with    |
| the variables named in the INPUT statement. Format statements may not   |
| be present for all variables in the data file.                          |
|                                                                         |
| NOTE:  Users should modify this SAS setup file to suit their specific   |
| needs. PROC FORMAT and FORMAT  sections have                            |
| been marked by SAS comment statements. To include these sections in a   |
| final SAS setup, users should remove the SAS comment statements from    |
| the desired section(s).                                                 |
*-------------------------------------------------------------------------;
                                                                           
* SAS PROC FORMAT;                                                         
/*                                                                         
PROC FORMAT;                                                               
   VALUE V5FT (MAX=40)                                                     
   1 = "ALABAMA"                                                           
   2 = "ARIZONA"                                                           
   3 = "ARKANSAS"                                                          
   4 = "CALIFORNIA"                                                        
   5 = "COLORADO"                                                          
   6 = "CONNECTICUT"                                                       
   7 = "DELAWARE"                                                          
   8 = "WASHINGTON, D.C"                                                   
   9 = "FLORIDA"                                                           
   10 = "GEORGIA"                                                          
   11 = "IDAHO"                                                            
   12 = "ILLINOIS"                                                         
   13 = "INDIANA"                                                          
   14 = "IOWA"                                                             
   15 = "KANSAS"                                                           
   16 = "KENTUCKY"                                                         
   17 = "LOUISIANA"                                                        
   18 = "MAINE"                                                            
   19 = "MARYLAND"                                                         
   20 = "MASSACHUSETTS"                                                    
   21 = "MICHIGAN"                                                         
   22 = "MINNESOTA"                                                        
   23 = "MISSISSIPPI"                                                      
   24 = "MISSOURI"                                                         
   25 = "MONTANA"                                                          
   26 = "NEBRASKA"                                                         
   27 = "NEVADA"                                                           
   28 = "NEW HAMPSHIRE"                                                    
   29 = "NEW JERSEY"                                                       
   30 = "NEW MEXICO"                                                       
   31 = "NEW YORK"                                                         
   32 = "NORTH CAROLINA"                                                   
   33 = "NORTH DAKOTA"                                                     
   34 = "OHIO"                                                             
   35 = "OKLAHOMA"                                                         
   36 = "OREGON"                                                           
   37 = "PENNSYLVANIA"                                                     
   38 = "RHODE ISLAND"                                                     
   39 = "SOUTH CAROLINA"                                                   
   40 = "SOUTH DAKOTA"                                                     
   41 = "TENNESSEE"                                                        
   42 = "TEXAS"                                                            
   43 = "UTAH"                                                             
   44 = "VERMONT"                                                          
   45 = "VIRGINIA"                                                         
   46 = "WASHINGTON"                                                       
   47 = "WEST VIRGINIA"                                                    
   48 = "WISCONSIN"                                                        
   49 = "WYOMING"                                                          
   50 = "ALASKA"                                                           
   51 = "HAWAII";                                                          
   VALUE V7FT (MAX=40)                                                     
   1 = "ALL CITIE 250K+"                                                   
   2 = "CIT BET 100-249K"                                                  
   3 = "CIT BET 50-99.9K"                                                  
   4 = "CIT BET 25-49.9K"                                                  
   5 = "CIT BET 10-24.9K"                                                  
   6 = "CIT BET 2.5-9.9K"                                                  
   7 = "CITIE UNDER 2.5K"                                                  
   8 = "NON-SMSA COUNTIE"                                                  
   9 = "SMSA COUNTIES";                                                    
   VALUE V8FT (MAX=40)                                                     
   0 = "POSSESS GUAM ETC"                                                  
   11 = "ALL CITIES 1M+"                                                   
   12 = "CIT BET 500-999K"                                                 
   13 = "CIT BET 250-499K"                                                 
   20 = "CIT BET 100-249K"                                                 
   30 = "CIT BET 50-99.9K"                                                 
   40 = "CIT BET 25-49.9K"                                                 
   50 = "CIT BET 10-24.9K"                                                 
   60 = "CIT BET 2.5-9.9K"                                                 
   70 = "CITIE UNDER 2.5K"                                                 
   81 = "NON-SMSA  100K+"                                                  
   82 = "NON-SMSA  25-99K"                                                 
   83 = "NON-SMSA  10-24K"                                                 
   84 = "NON-SMSA  <10K"                                                   
   85 = "NON-SMSA STATE POLICE"                                                     
   91 = "SMSA COUNT 10K+"                                                  
   92 = "SMSA  25-99.9K"                                                   
   93 = "SMSA  100K+"                                                      
   94 = "SMSA COUNT <10K"                                                  
   95 = "SMSA STATE POLICE";                                                    
   VALUE V11FT (MAX=40)                                                    
   0 = "GROUPS 8 AND 9";                                                   
   VALUE V12FT (MAX=40)                                                    
   0 = "NO SMSA NUMBER";                                                   
   VALUE V55FT (MAX=40)                                                    
   0 = "FOR ALL REPORTS"                                                   
   1 = "CITY LIST ASSAUL"                                                  
   2 = "CITY LIST ONLY";                                                   
   VALUE V56FT (MAX=40)                                                    
   0 = "POL EMPLOY DA"                                                     
   1 = "NOT UPDATED,NONE"                                                  
   2 = "CONTAINS POL DA";                                                  
   VALUE V57FT (MAX=40)                                                    
   0 = "NORMAL UPDATE"                                                     
   1 = "NOT REPORTED"                                                      
   2 = "REPORTED,NO DATA"                                                  
   3 = "DELETED";                                                          
   VALUE V58FT (MAX=40)                                                    
   0 = "NORMAL UPDATE"                                                     
   1 = "NOT REPORTED"                                                      
   2 = "REPORTED,NO DATA"                                                  
   3 = "DELETED";                                                          
   VALUE V59FT (MAX=40)                                                    
   0 = "NORMAL UPDATE"                                                     
   1 = "NOT REPORTED"                                                      
   2 = "REPORTED,NO DATA"                                                  
   3 = "DELETED";                                                          
   VALUE V60FT (MAX=40)                                                    
   0 = "NORMAL UPDATE"                                                     
   1 = "NOT REPORTED"                                                      
   2 = "REPORTED,NO DATA"                                                  
   3 = "DELETED";                                                          
   VALUE V61FT (MAX=40)                                                    
   0 = "NORMAL UPDATE"                                                     
   1 = "NOT REPORTED"                                                      
   2 = "REPORTED,NO DATA"                                                  
   3 = "DELETED";                                                          
   VALUE V62FT (MAX=40)                                                    
   0 = "NORMAL UPDATE"                                                     
   1 = "NOT REPORTED"                                                      
   2 = "REPORTED,NO DATA"                                                  
   3 = "DELETED";                                                          
   VALUE V63FT (MAX=40)                                                    
   0 = "NORMAL UPDATE"                                                     
   1 = "NOT REPORTED"                                                      
   2 = "REPORTED,NO DATA"                                                  
   3 = "DELETED";                                                          
   VALUE V64FT (MAX=40)                                                    
   0 = "NORMAL UPDATE"                                                     
   1 = "NOT REPORTED"                                                      
   2 = "REPORTED,NO DATA"                                                  
   3 = "DELETED";                                                          
   VALUE V65FT (MAX=40)                                                    
   0 = "NORMAL UPDATE"                                                     
   1 = "NOT REPORTED"                                                      
   2 = "REPORTED,NO DATA"                                                  
   3 = "DELETED";                                                          
   VALUE V66FT (MAX=40)                                                    
   0 = "NORMAL UPDATE"                                                     
   1 = "NOT REPORTED"                                                      
   2 = "REPORTED,NO DATA"                                                  
   3 = "DELETED";                                                          
   VALUE V67FT (MAX=40)                                                    
   0 = "NORMAL UPDATE"                                                     
   1 = "NOT REPORTED"                                                      
   2 = "REPORTED,NO DATA"                                                  
   3 = "DELETED";                                                          
   VALUE V68FT (MAX=40)                                                    
   0 = "NORMAL UPDATE"                                                     
   1 = "NOT REPORTED"                                                      
   2 = "REPORTED,NO DATA"                                                  
   3 = "DELETED";                                                          
   VALUE V70FT (MAX=40)                                                    
   0 = "ALL OTHERS"                                                        
   1 = "AGENCY COVERED";                                                   
   VALUE V71FT (MAX=40)                                                    
   0 = "REPORTED"                                                          
   1 = "REPORTED,NO DATA"                                                  
   2 = "NOT REPORTED";                                                     
   VALUE V72FT (MAX=40)                                                    
   0 = "NORMAL"                                                            
   1 = "NO BREAKDOWNS. A";                                                 
   VALUE V73FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V74FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V75FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V76FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V77FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V78FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V79FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V80FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V81FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V82FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V83FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V84FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V85FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V86FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V87FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V88FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V89FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V90FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V91FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V92FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V93FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V94FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V95FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
   VALUE V96FT (MAX=40)                                                    
   0 = "INFORMAT COMPLET"                                                  
   1 = "ASSAULTS NOT REP"                                                  
   2 = "ASSAULTS REPORTE";                                                 
*/                                                                         
                                                                           
* SAS DATA, INFILE, INPUT STATEMENTS;                                      
                                                                           
DATA;                                                                      
INFILE "file-specification" LRECL=3401;                                    
INPUT                                                                      
   V1 1-4                   V2 5-5                   V3 6-6                
   V4 7-11                  V5 12-13                 V6 $ 14-20            
   V7 21-21                 V8 22-23                 V9 24-24              
   V10 25-26                V11 27-31                V12 32-34             
   V13 35-42                V14 $ 43-66              V15 $ 67-72           
   V16 73-77                V17 78-81                V18 82-86             
   V19 87-89                V20 90-93                V21 94-97             
   V22 98-102               V23 103-107 .1              V24 108-112 .1     
   V25 113-114              V26 115-116              V27 117-118           
   V28 119-119              V29 120-122              V30 123-123           
   V31 124-125              V32 126-126              V33 127-127           
   V34 128-129              V35 130-130              V36 131-131           
   V37 132-133              V38 134-134              V39 135-136           
   V40 137-137              V41 138-138              V42 139-139           
   V43 140-140              V44 141-141              V45 142-142           
   V46 143-143              V47 144-144              V48 145-145           
   V49 146-147              V50 148-149              V51 150-151           
   V52 152-153              V53 154-154              V54 155-157           
   V55 158-158              V56 159-159              V57 160-160           
   V58 161-161              V59 162-162              V60 163-163           
   V61 164-164              V62 165-165              V63 166-166           
   V64 167-167              V65 168-168              V66 169-169           
   V67 170-170              V68 171-171              V69 172-173           
   V70 174-174              V71 175-176              V72 177-178           
   V73 179-179              V74 180-180              V75 181-181           
   V76 182-182              V77 183-183              V78 184-184           
   V79 185-185              V80 186-186              V81 187-187           
   V82 188-188              V83 189-189              V84 190-190           
   V85 191-191              V86 192-192              V87 193-193           
   V88 194-194              V89 195-195              V90 196-196           
   V91 197-197              V92 198-198              V93 199-199           
   V94 200-200              V95 201-201              V96 202-202           
   V97 203-203              V98 204-204              V99 205-205           
   V100 206-206             V101 207-207             V102 208-208          
   V103 209-209             V104 210-211             V105 212-212          
   V106 213-213             V107 214-214             V108 215-215          
   V109 216-216             V110 217-217             V111 218-218          
   V112 219-219             V113 220-220             V114 221-221          
   V115 222-222             V116 223-223             V117 224-224          
   V118 225-225             V119 226-226             V120 227-227          
   V121 228-229             V122 230-231             V123 232-233          
   V124 234-235             V125 236-236             V126 237-238          
   V127 239-240             V128 241-242             V129 243-244          
   V130 245-245             V131 246-247             V132 248-249          
   V133 250-250             V134 251-251             V135 252-252          
   V136 253-253             V137 254-254             V138 255-255          
   V139 256-257             V140 258-258             V141 259-259          
   V142 260-260             V143 261-261             V144 262-262          
   V145 263-263             V146 264-264             V147 265-266          
   V148 267-268             V149 269-270             V150 271-272          
   V151 273-274             V152 275-276             V153 277-278          
   V154 279-279             V155 280-280             V156 281-281          
   V157 282-284             V158 285-287             V159 288-290          
   V160 291-293             V161 294-296             V162 297-299          
   V163 300-302             V164 303-305             V165 306-308          
   V166 309-311             V167 312-314             V168 315-317          
   V169 318-320             V170 321-323             V171 324-326          
   V172 327-329             V173 330-332             V174 333-335          
   V175 336-338             V176 339-341             V177 342-344          
   V178 345-347             V179 348-350             V180 351-353          
   V181 354-354             V182 355-356             V183 357-358          
   V184 359-360             V185 361-362             V186 363-364          
   V187 365-366             V188 367-368             V189 369-370          
   V190 371-372             V191 373-374             V192 375-376          
   V193 377-377             V194 378-378             V195 379-379          
   V196 380-380             V197 381-381             V198 382-382          
   V199 383-383             V200 384-384             V201 385-385          
   V202 386-386             V203 387-387             V204 388-388          
   V205 389-390             V206 391-392             V207 393-394          
   V208 395-396             V209 397-398             V210 399-400          
   V211 401-402             V212 403-404             V213 405-406          
   V214 407-408             V215 409-409             V216 410-411          
   V217 412-414             V218 415-416             V219 417-419          
   V220 420-422             V221 423-425             V222 426-427          
   V223 428-430             V224 431-432             V225 433-435          
   V226 436-438             V227 439-441             V228 442-444          
   V229 445-447             V230 448-450             V231 451-453          
   V232 454-456             V233 457-459             V234 460-462          
   V235 463-465             V236 466-468             V237 469-471          
   V238 472-474             V239 475-477             V240 478-480          
   V241 481-482             V242 483-484             V243 485-486          
   V244 487-488             V245 489-490             V246 491-492          
   V247 493-494             V248 495-496             V249 497-498          
   V250 499-500             V251 501-502             V252 503-504          
   V253 505-505             V254 506-507             V255 508-508          
   V256 509-509             V257 510-510             V258 511-512          
   V259 513-514             V260 515-516             V261 517-517          
   V262 518-518             V263 519-520             V264 521-521          
   V265 522-522             V266 523-523             V267 524-524          
   V268 525-525             V269 526-526             V270 527-527          
   V271 528-528             V272 529-529             V273 530-530          
   V274 531-531             V275 532-532             V276 533-533          
   V277 534-534             V278 535-535             V279 536-536          
   V280 537-537             V281 538-538             V282 539-539          
   V283 540-541             V284 542-543             V285 544-544          
   V286 545-546             V287 547-547             V288 548-548          
   V289 549-550             V290 551-552             V291 553-554          
   V292 555-556             V293 557-558             V294 559-560          
   V295 561-562             V296 563-564             V297 565-566          
   V298 567-568             V299 569-570             V300 571-572          
   V301 573-574             V302 575-576             V303 577-578          
   V304 579-580             V305 581-582             V306 583-584          
   V307 585-586             V308 587-588             V309 589-590          
   V310 591-592             V311 593-594             V312 595-596          
   V313 597-598             V314 599-600             V315 601-602          
   V316 603-604             V317 605-606             V318 607-608          
   V319 609-610             V320 611-612             V321 613-614          
   V322 615-616             V323 617-618             V324 619-620          
   V325 621-622             V326 623-624             V327 625-626          
   V328 627-628             V329 629-630             V330 631-632          
   V331 633-634             V332 635-636             V333 637-638          
   V334 639-640             V335 641-642             V336 643-644          
   V337 645-645             V338 646-646             V339 647-647          
   V340 648-648             V341 649-649             V342 650-650          
   V343 651-651             V344 652-652             V345 653-653          
   V346 654-654             V347 655-655             V348 656-656          
   V349 657-657             V350 658-658             V351 659-659          
   V352 660-660             V353 661-661             V354 662-662          
   V355 663-664             V356 665-665             V357 666-666          
   V358 667-667             V359 668-668             V360 669-669          
   V361 670-670             V362 671-671             V363 672-672          
   V364 673-673             V365 674-674             V366 675-675          
   V367 676-676             V368 677-677             V369 678-678          
   V370 679-679             V371 680-680             V372 681-681          
   V373 682-682             V374 683-683             V375 684-685          
   V376 686-686             V377 687-687             V378 688-688          
   V379 689-689             V380 690-690             V381 691-691          
   V382 692-692             V383 693-694             V384 695-696          
   V385 697-698             V386 699-700             V387 701-702          
   V388 703-704             V389 705-706             V390 707-708          
   V391 709-710             V392 711-712             V393 713-714          
   V394 715-716             V395 717-718             V396 719-720          
   V397 721-722             V398 723-724             V399 725-726          
   V400 727-728             V401 729-730             V402 731-732          
   V403 733-734             V404 735-736             V405 737-738          
   V406 739-740             V407 741-742             V408 743-744          
   V409 745-745             V410 746-746             V411 747-747          
   V412 748-748             V413 749-749             V414 750-750          
   V415 751-751             V416 752-752             V417 753-753          
   V418 754-754             V419 755-755             V420 756-756          
   V421 757-757             V422 758-758             V423 759-759          
   V424 760-760             V425 761-761             V426 762-762          
   V427 763-763             V428 764-764             V429 765-765          
   V430 766-766             V431 767-767             V432 768-768          
   V433 769-769             V434 770-770             V435 771-771          
   V436 772-772             V437 773-773             V438 774-774          
   V439 775-775             V440 776-776             V441 777-777          
   V442 778-778             V443 779-779             V444 780-780          
   V445 781-781             V446 782-783             V447 784-785          
   V448 786-786             V449 787-788             V450 789-790          
   V451 791-792             V452 793-794             V453 795-795          
   V454 796-796             V455 797-798             V456 799-800          
   V457 801-801             V458 802-803             V459 804-804          
   V460 805-806             V461 807-808             V462 809-810          
   V463 811-812             V464 813-813             V465 814-814          
   V466 815-815             V467 816-817             V468 818-819          
   V469 820-820             V470 821-821             V471 822-822          
   V472 823-823             V473 824-824             V474 825-825          
   V475 826-826             V476 827-827             V477 828-828          
   V478 829-829             V479 830-830             V480 831-831          
   V481 832-832             V482 833-833             V483 834-834          
   V484 835-835             V485 836-836             V486 837-837          
   V487 838-838             V488 839-839             V489 840-840          
   V490 841-841             V491 842-842             V492 843-843          
   V493 844-844             V494 845-845             V495 846-846          
   V496 847-847             V497 848-848             V498 849-849          
   V499 850-850             V500 851-851             V501 852-852          
   V502 853-853             V503 854-854             V504 855-855          
   V505 856-856             V506 857-857             V507 858-858          
   V508 859-859             V509 860-860             V510 861-861          
   V511 862-862             V512 863-863             V513 864-864          
   V514 865-865             V515 866-866             V516 867-867          
   V517 868-868             V518 869-869             V519 870-870          
   V520 871-871             V521 872-872             V522 873-873          
   V523 874-874             V524 875-875             V525 876-876          
   V526 877-877             V527 878-878             V528 879-879          
   V529 880-880             V530 881-881             V531 882-882          
   V532 883-883             V533 884-884             V534 885-885          
   V535 886-886             V536 887-887             V537 888-888          
   V538 889-889             V539 890-890             V540 891-891          
   V541 892-893             V542 894-895             V543 896-897          
   V544 898-899             V545 900-901             V546 902-903          
   V547 904-905             V548 906-907             V549 908-908          
   V550 909-910             V551 911-912             V552 913-914          
   V553 915-916             V554 917-918             V555 919-920          
   V556 921-922             V557 923-924             V558 925-926          
   V559 927-928             V560 929-930             V561 931-932          
   V562 933-934             V563 935-936             V564 937-938          
   V565 939-939             V566 940-941             V567 942-943          
   V568 944-945             V569 946-947             V570 948-949          
   V571 950-951             V572 952-953             V573 954-955          
   V574 956-957             V575 958-958             V576 959-960          
   V577 961-961             V578 962-962             V579 963-963          
   V580 964-964             V581 965-965             V582 966-966          
   V583 967-967             V584 968-968             V585 969-969          
   V586 970-970             V587 971-971             V588 972-972          
   V589 973-973             V590 974-974             V591 975-975          
   V592 976-976             V593 977-977             V594 978-978          
   V595 979-979             V596 980-980             V597 981-981          
   V598 982-982             V599 983-983             V600 984-984          
   V601 985-985             V602 986-987             V603 988-988          
   V604 989-990             V605 991-992             V606 993-994          
   V607 995-996             V608 997-998             V609 999-1000         
   V610 1001-1002           V611 1003-1004           V612 1005-1006        
   V613 1007-1007           V614 1008-1009           V615 1010-1011        
   V616 1012-1013           V617 1014-1015           V618 1016-1017        
   V619 1018-1019           V620 1020-1021           V621 1022-1023        
   V622 1024-1025           V623 1026-1026           V624 1027-1028        
   V625 1029-1030           V626 1031-1031           V627 1032-1032        
   V628 1033-1033           V629 1034-1034           V630 1035-1035        
   V631 1036-1036           V632 1037-1037           V633 1038-1038        
   V634 1039-1039           V635 1040-1040           V636 1041-1041        
   V637 1042-1042           V638 1043-1043           V639 1044-1044        
   V640 1045-1045           V641 1046-1046           V642 1047-1047        
   V643 1048-1048           V644 1049-1049           V645 1050-1050        
   V646 1051-1051           V647 1052-1052           V648 1053-1053        
   V649 1054-1054           V650 1055-1055           V651 1056-1056        
   V652 1057-1057           V653 1058-1058           V654 1059-1059        
   V655 1060-1060           V656 1061-1061           V657 1062-1062        
   V658 1063-1063           V659 1064-1064           V660 1065-1065        
   V661 1066-1066           V662 1067-1068           V663 1069-1069        
   V664 1070-1070           V665 1071-1071           V666 1072-1072        
   V667 1073-1074           V668 1075-1075           V669 1076-1076        
   V670 1077-1078           V671 1079-1079           V672 1080-1080        
   V673 1081-1081           V674 1082-1082           V675 1083-1083        
   V676 1084-1084           V677 1085-1085           V678 1086-1086        
   V679 1087-1087           V680 1088-1089           V681 1090-1090        
   V682 1091-1091           V683 1092-1092           V684 1093-1093        
   V685 1094-1094           V686 1095-1095           V687 1096-1096        
   V688 1097-1097           V689 1098-1098           V690 1099-1099        
   V691 1100-1100           V692 1101-1101           V693 1102-1102        
   V694 1103-1103           V695 1104-1104           V696 1105-1105        
   V697 1106-1107           V698 1108-1109           V699 1110-1111        
   V700 1112-1113           V701 1114-1115           V702 1116-1117        
   V703 1118-1119           V704 1120-1121           V705 1122-1123        
   V706 1124-1125           V707 1126-1127           V708 1128-1129        
   V709 1130-1131           V710 1132-1133           V711 1134-1135        
   V712 1136-1137           V713 1138-1139           V714 1140-1141        
   V715 1142-1143           V716 1144-1145           V717 1146-1147        
   V718 1148-1149           V719 1150-1151           V720 1152-1153        
   V721 1154-1155           V722 1156-1157           V723 1158-1158        
   V724 1159-1160           V725 1161-1162           V726 1163-1163        
   V727 1164-1164           V728 1165-1166           V729 1167-1168        
   V730 1169-1170           V731 1171-1172           V732 1173-1174        
   V733 1175-1175           V734 1176-1176           V735 1177-1177        
   V736 1178-1178           V737 1179-1179           V738 1180-1180        
   V739 1181-1181           V740 1182-1182           V741 1183-1183        
   V742 1184-1184           V743 1185-1185           V744 1186-1186        
   V745 1187-1187           V746 1188-1188           V747 1189-1189        
   V748 1190-1190           V749 1191-1191           V750 1192-1192        
   V751 1193-1193           V752 1194-1194           V753 1195-1195        
   V754 1196-1196           V755 1197-1197           V756 1198-1198        
   V757 1199-1200           V758 1201-1202           V759 1203-1204        
   V760 1205-1206           V761 1207-1208           V762 1209-1210        
   V763 1211-1212           V764 1213-1214           V765 1215-1216        
   V766 1217-1218           V767 1219-1220           V768 1221-1222        
   V769 1223-1224           V770 1225-1226           V771 1227-1228        
   V772 1229-1230           V773 1231-1232           V774 1233-1234        
   V775 1235-1236           V776 1237-1238           V777 1239-1240        
   V778 1241-1242           V779 1243-1244           V780 1245-1246        
   V781 1247-1248           V782 1249-1250           V783 1251-1252        
   V784 1253-1254           V785 1255-1256           V786 1257-1258        
   V787 1259-1260           V788 1261-1262           V789 1263-1264        
   V790 1265-1266           V791 1267-1268           V792 1269-1270        
   V793 1271-1272           V794 1273-1274           V795 1275-1276        
   V796 1277-1278           V797 1279-1280           V798 1281-1282        
   V799 1283-1284           V800 1285-1286           V801 1287-1288        
   V802 1289-1290           V803 1291-1292           V804 1293-1294        
   V805 1295-1295           V806 1296-1296           V807 1297-1297        
   V808 1298-1298           V809 1299-1299           V810 1300-1300        
   V811 1301-1301           V812 1302-1302           V813 1303-1303        
   V814 1304-1304           V815 1305-1305           V816 1306-1306        
   V817 1307-1307           V818 1308-1309           V819 1310-1310        
   V820 1311-1311           V821 1312-1313           V822 1314-1315        
   V823 1316-1317           V824 1318-1319           V825 1320-1321        
   V826 1322-1323           V827 1324-1325           V828 1326-1327        
   V829 1328-1328           V830 1329-1329           V831 1330-1330        
   V832 1331-1331           V833 1332-1333           V834 1334-1335        
   V835 1336-1337           V836 1338-1338           V837 1339-1340        
   V838 1341-1341           V839 1342-1342           V840 1343-1343        
   V841 1344-1344           V842 1345-1345           V843 1346-1346        
   V844 1347-1347           V845 1348-1348           V846 1349-1350        
   V847 1351-1351           V848 1352-1352           V849 1353-1353        
   V850 1354-1354           V851 1355-1355           V852 1356-1356        
   V853 1357-1358           V854 1359-1360           V855 1361-1362        
   V856 1363-1364           V857 1365-1366           V858 1367-1368        
   V859 1369-1370           V860 1371-1372           V861 1373-1374        
   V862 1375-1376           V863 1377-1378           V864 1379-1380        
   V865 1381-1381           V866 1382-1383           V867 1384-1384        
   V868 1385-1386           V869 1387-1388           V870 1389-1390        
   V871 1391-1392           V872 1393-1394           V873 1395-1396        
   V874 1397-1397           V875 1398-1398           V876 1399-1400        
   V877 1401-1401           V878 1402-1402           V879 1403-1403        
   V880 1404-1404           V881 1405-1405           V882 1406-1406        
   V883 1407-1407           V884 1408-1408           V885 1409-1409        
   V886 1410-1410           V887 1411-1411           V888 1412-1412        
   V889 1413-1413           V890 1414-1414           V891 1415-1415        
   V892 1416-1416           V893 1417-1417           V894 1418-1418        
   V895 1419-1419           V896 1420-1420           V897 1421-1421        
   V898 1422-1422           V899 1423-1423           V900 1424-1424        
   V901 1425-1425           V902 1426-1426           V903 1427-1427        
   V904 1428-1428           V905 1429-1429           V906 1430-1430        
   V907 1431-1432           V908 1433-1433           V909 1434-1434        
   V910 1435-1435           V911 1436-1436           V912 1437-1437        
   V913 1438-1438           V914 1439-1440           V915 1441-1441        
   V916 1442-1442           V917 1443-1444           V918 1445-1446        
   V919 1447-1447           V920 1448-1449           V921 1450-1451        
   V922 1452-1452           V923 1453-1453           V924 1454-1455        
   V925 1456-1456           V926 1457-1457           V927 1458-1458        
   V928 1459-1460           V929 1461-1462           V930 1463-1463        
   V931 1464-1465           V932 1466-1467           V933 1468-1468        
   V934 1469-1469           V935 1470-1470           V936 1471-1471        
   V937 1472-1472           V938 1473-1473           V939 1474-1474        
   V940 1475-1475           V941 1476-1476           V942 1477-1477        
   V943 1478-1478           V944 1479-1479           V945 1480-1480        
   V946 1481-1481           V947 1482-1482           V948 1483-1483        
   V949 1484-1484           V950 1485-1485           V951 1486-1486        
   V952 1487-1488           V953 1489-1489           V954 1490-1490        
   V955 1491-1491           V956 1492-1492           V957 1493-1493        
   V958 1494-1494           V959 1495-1495           V960 1496-1496        
   V961 1497-1497           V962 1498-1498           V963 1499-1499        
   V964 1500-1500           V965 1501-1501           V966 1502-1502        
   V967 1503-1503           V968 1504-1504           V969 1505-1505        
   V970 1506-1506           V971 1507-1507           V972 1508-1508        
   V973 1509-1509           V974 1510-1510           V975 1511-1511        
   V976 1512-1512           V977 1513-1513           V978 1514-1514        
   V979 1515-1515           V980 1516-1516           V981 1517-1517        
   V982 1518-1518           V983 1519-1519           V984 1520-1521        
   V985 1522-1522           V986 1523-1523           V987 1524-1524        
   V988 1525-1525           V989 1526-1526           V990 1527-1527        
   V991 1528-1528           V992 1529-1529           V993 1530-1530        
   V994 1531-1531           V995 1532-1532           V996 1533-1533        
   V997 1534-1534           V998 1535-1535           V999 1536-1536        
   V1000 1537-1537          V1001 1538-1539          V1002 1540-1540       
   V1003 1541-1541          V1004 1542-1542          V1005 1543-1544       
   V1006 1545-1545          V1007 1546-1546          V1008 1547-1547       
   V1009 1548-1548          V1010 1549-1550          V1011 1551-1551       
   V1012 1552-1553          V1013 1554-1555          V1014 1556-1556       
   V1015 1557-1558          V1016 1559-1560          V1017 1561-1562       
   V1018 1563-1563          V1019 1564-1564          V1020 1565-1566       
   V1021 1567-1568          V1022 1569-1570          V1023 1571-1572       
   V1024 1573-1574          V1025 1575-1576          V1026 1577-1578       
   V1027 1579-1580          V1028 1581-1582          V1029 1583-1584       
   V1030 1585-1586          V1031 1587-1588          V1032 1589-1590       
   V1033 1591-1591          V1034 1592-1592          V1035 1593-1593       
   V1036 1594-1594          V1037 1595-1595          V1038 1596-1596       
   V1039 1597-1597          V1040 1598-1598          V1041 1599-1599       
   V1042 1600-1600          V1043 1601-1601          V1044 1602-1602       
   V1045 1603-1603          V1046 1604-1604          V1047 1605-1605       
   V1048 1606-1606          V1049 1607-1607          V1050 1608-1608       
   V1051 1609-1609          V1052 1610-1610          V1053 1611-1611       
   V1054 1612-1612          V1055 1613-1613          V1056 1614-1614       
   V1057 1615-1615          V1058 1616-1616          V1059 1617-1617       
   V1060 1618-1619          V1061 1620-1620          V1062 1621-1621       
   V1063 1622-1622          V1064 1623-1624          V1065 1625-1625       
   V1066 1626-1626          V1067 1627-1627          V1068 1628-1628       
   V1069 1629-1630          V1070 1631-1632          V1071 1633-1634       
   V1072 1635-1636          V1073 1637-1638          V1074 1639-1640       
   V1075 1641-1642          V1076 1643-1644          V1077 1645-1646       
   V1078 1647-1648          V1079 1649-1650          V1080 1651-1652       
   V1081 1653-1654          V1082 1655-1656          V1083 1657-1658       
   V1084 1659-1660          V1085 1661-1662          V1086 1663-1664       
   V1087 1665-1666          V1088 1667-1668          V1089 1669-1670       
   V1090 1671-1672          V1091 1673-1673          V1092 1674-1674       
   V1093 1675-1675          V1094 1676-1676          V1095 1677-1677       
   V1096 1678-1678          V1097 1679-1679          V1098 1680-1680       
   V1099 1681-1681          V1100 1682-1682          V1101 1683-1683       
   V1102 1684-1684          V1103 1685-1685          V1104 1686-1686       
   V1105 1687-1687          V1106 1688-1688          V1107 1689-1689       
   V1108 1690-1690          V1109 1691-1691          V1110 1692-1693       
   V1111 1694-1694          V1112 1695-1695          V1113 1696-1696       
   V1114 1697-1697          V1115 1698-1698          V1116 1699-1699       
   V1117 1700-1700          V1118 1701-1701          V1119 1702-1702       
   V1120 1703-1703          V1121 1704-1704          V1122 1705-1705       
   V1123 1706-1706          V1124 1707-1707          V1125 1708-1708       
   V1126 1709-1709          V1127 1710-1710          V1128 1711-1711       
   V1129 1712-1713          V1130 1714-1714          V1131 1715-1716       
   V1132 1717-1718          V1133 1719-1720          V1134 1721-1722       
   V1135 1723-1723          V1136 1724-1725          V1137 1726-1726       
   V1138 1727-1727          V1139 1728-1728          V1140 1729-1729       
   V1141 1730-1730          V1142 1731-1731          V1143 1732-1732       
   V1144 1733-1733          V1145 1734-1734          V1146 1735-1735       
   V1147 1736-1736          V1148 1737-1737          V1149 1738-1738       
   V1150 1739-1739          V1151 1740-1740          V1152 1741-1741       
   V1153 1742-1742          V1154 1743-1744          V1155 1745-1746       
   V1156 1747-1747          V1157 1748-1748          V1158 1749-1749       
   V1159 1750-1751          V1160 1752-1753          V1161 1754-1755       
   V1162 1756-1757          V1163 1758-1759          V1164 1760-1761       
   V1165 1762-1763          V1166 1764-1765          V1167 1766-1767       
   V1168 1768-1769          V1169 1770-1771          V1170 1772-1773       
   V1171 1774-1775          V1172 1776-1777          V1173 1778-1779       
   V1174 1780-1781          V1175 1782-1783          V1176 1784-1785       
   V1177 1786-1787          V1178 1788-1789          V1179 1790-1791       
   V1180 1792-1793          V1181 1794-1795          V1182 1796-1797       
   V1183 1798-1799          V1184 1800-1801          V1185 1802-1803       
   V1186 1804-1805          V1187 1806-1807          V1188 1808-1809       
   V1189 1810-1810          V1190 1811-1811          V1191 1812-1812       
   V1192 1813-1813          V1193 1814-1814          V1194 1815-1815       
   V1195 1816-1816          V1196 1817-1817          V1197 1818-1818       
   V1198 1819-1819          V1199 1820-1820          V1200 1821-1821       
   V1201 1822-1822          V1202 1823-1823          V1203 1824-1824       
   V1204 1825-1825          V1205 1826-1826          V1206 1827-1827       
   V1207 1828-1828          V1208 1829-1829          V1209 1830-1830       
   V1210 1831-1831          V1211 1832-1832          V1212 1833-1833       
   V1213 1834-1834          V1214 1835-1835          V1215 1836-1836       
   V1216 1837-1837          V1217 1838-1838          V1218 1839-1839       
   V1219 1840-1840          V1220 1841-1841          V1221 1842-1842       
   V1222 1843-1843          V1223 1844-1844          V1224 1845-1845       
   V1225 1846-1847          V1226 1848-1849          V1227 1850-1851       
   V1228 1852-1853          V1229 1854-1855          V1230 1856-1857       
   V1231 1858-1859          V1232 1860-1861          V1233 1862-1863       
   V1234 1864-1865          V1235 1866-1867          V1236 1868-1868       
   V1237 1869-1870          V1238 1871-1872          V1239 1873-1874       
   V1240 1875-1876          V1241 1877-1878          V1242 1879-1880       
   V1243 1881-1882          V1244 1883-1884          V1245 1885-1886       
   V1246 1887-1888          V1247 1889-1889          V1248 1890-1891       
   V1249 1892-1892          V1250 1893-1893          V1251 1894-1894       
   V1252 1895-1895          V1253 1896-1896          V1254 1897-1897       
   V1255 1898-1898          V1256 1899-1899          V1257 1900-1900       
   V1258 1901-1901          V1259 1902-1902          V1260 1903-1903       
   V1261 1904-1905          V1262 1906-1906          V1263 1907-1907       
   V1264 1908-1908          V1265 1909-1909          V1266 1910-1910       
   V1267 1911-1911          V1268 1912-1912          V1269 1913-1913       
   V1270 1914-1914          V1271 1915-1915          V1272 1916-1916       
   V1273 1917-1917          V1274 1918-1918          V1275 1919-1919       
   V1276 1920-1920          V1277 1921-1921          V1278 1922-1922       
   V1279 1923-1923          V1280 1924-1924          V1281 1925-1925       
   V1282 1926-1926          V1283 1927-1927          V1284 1928-1928       
   V1285 1929-1929          V1286 1930-1930          V1287 1931-1931       
   V1288 1932-1932          V1289 1933-1933          V1290 1934-1934       
   V1291 1935-1935          V1292 1936-1936          V1293 1937-1937       
   V1294 1938-1938          V1295 1939-1939          V1296 1940-1940       
   V1297 1941-1941          V1298 1942-1942          V1299 1943-1943       
   V1300 1944-1944          V1301 1945-1945          V1302 1946-1946       
   V1303 1947-1947          V1304 1948-1948          V1305 1949-1949       
   V1306 1950-1950          V1307 1951-1951          V1308 1952-1952       
   V1309 1953-1953          V1310 1954-1954          V1311 1955-1955       
   V1312 1956-1956          V1313 1957-1957          V1314 1958-1958       
   V1315 1959-1959          V1316 1960-1960          V1317 1961-1961       
   V1318 1962-1962          V1319 1963-1963          V1320 1964-1964       
   V1321 1965-1966          V1322 1967-1968          V1323 1969-1970       
   V1324 1971-1972          V1325 1973-1974          V1326 1975-1976       
   V1327 1977-1978          V1328 1979-1980          V1329 1981-1982       
   V1330 1983-1984          V1331 1985-1986          V1332 1987-1988       
   V1333 1989-1989          V1334 1990-1990          V1335 1991-1991       
   V1336 1992-1992          V1337 1993-1993          V1338 1994-1994       
   V1339 1995-1995          V1340 1996-1997          V1341 1998-1998       
   V1342 1999-1999          V1343 2000-2000          V1344 2001-2001       
   V1345 2002-2002          V1346 2003-2003          V1347 2004-2004       
   V1348 2005-2005          V1349 2006-2006          V1350 2007-2007       
   V1351 2008-2008          V1352 2009-2009          V1353 2010-2010       
   V1354 2011-2011          V1355 2012-2012          V1356 2013-2013       
   V1357 2014-2014          V1358 2015-2015          V1359 2016-2016       
   V1360 2017-2017          V1361 2018-2018          V1362 2019-2019       
   V1363 2020-2020          V1364 2021-2021          V1365 2022-2022       
   V1366 2023-2023          V1367 2024-2024          V1368 2025-2025       
   V1369 2026-2026          V1370 2027-2027          V1371 2028-2028       
   V1372 2029-2029          V1373 2030-2030          V1374 2031-2031       
   V1375 2032-2032          V1376 2033-2033          V1377 2034-2034       
   V1378 2035-2035          V1379 2036-2036          V1380 2037-2037       
   V1381 2038-2038          V1382 2039-2039          V1383 2040-2040       
   V1384 2041-2041          V1385 2042-2042          V1386 2043-2043       
   V1387 2044-2044          V1388 2045-2045          V1389 2046-2046       
   V1390 2047-2047          V1391 2048-2048          V1392 2049-2049       
   V1393 2050-2050          V1394 2051-2051          V1395 2052-2052       
   V1396 2053-2053          V1397 2054-2054          V1398 2055-2055       
   V1399 2056-2056          V1400 2057-2057          V1401 2058-2058       
   V1402 2059-2059          V1403 2060-2060          V1404 2061-2061       
   V1405 2062-2062          V1406 2063-2063          V1407 2064-2064       
   V1408 2065-2065          V1409 2066-2066          V1410 2067-2067       
   V1411 2068-2068          V1412 2069-2069          V1413 2070-2070       
   V1414 2071-2071          V1415 2072-2072          V1416 2073-2073       
   V1417 2074-2074          V1418 2075-2075          V1419 2076-2076       
   V1420 2077-2077          V1421 2078-2078          V1422 2079-2079       
   V1423 2080-2080          V1424 2081-2081          V1425 2082-2082       
   V1426 2083-2083          V1427 2084-2084          V1428 2085-2085       
   V1429 2086-2086          V1430 2087-2087          V1431 2088-2088       
   V1432 2089-2089          V1433 2090-2090          V1434 2091-2091       
   V1435 2092-2092          V1436 2093-2093          V1437 2094-2094       
   V1438 2095-2095          V1439 2096-2096          V1440 2097-2097       
   V1441 2098-2098          V1442 2099-2099          V1443 2100-2100       
   V1444 2101-2101          V1445 2102-2102          V1446 2103-2103       
   V1447 2104-2104          V1448 2105-2105          V1449 2106-2106       
   V1450 2107-2107          V1451 2108-2108          V1452 2109-2109       
   V1453 2110-2110          V1454 2111-2111          V1455 2112-2112       
   V1456 2113-2113          V1457 2114-2114          V1458 2115-2115       
   V1459 2116-2116          V1460 2117-2117          V1461 2118-2118       
   V1462 2119-2119          V1463 2120-2120          V1464 2121-2121       
   V1465 2122-2122          V1466 2123-2123          V1467 2124-2124       
   V1468 2125-2125          V1469 2126-2126          V1470 2127-2127       
   V1471 2128-2128          V1472 2129-2129          V1473 2130-2130       
   V1474 2131-2131          V1475 2132-2132          V1476 2133-2133       
   V1477 2134-2134          V1478 2135-2135          V1479 2136-2136       
   V1480 2137-2137          V1481 2138-2138          V1482 2139-2139       
   V1483 2140-2140          V1484 2141-2142          V1485 2143-2143       
   V1486 2144-2144          V1487 2145-2145          V1488 2146-2146       
   V1489 2147-2148          V1490 2149-2150          V1491 2151-2152       
   V1492 2153-2154          V1493 2155-2156          V1494 2157-2158       
   V1495 2159-2160          V1496 2161-2162          V1497 2163-2164       
   V1498 2165-2166          V1499 2167-2168          V1500 2169-2170       
   V1501 2171-2171          V1502 2172-2172          V1503 2173-2173       
   V1504 2174-2174          V1505 2175-2175          V1506 2176-2176       
   V1507 2177-2177          V1508 2178-2178          V1509 2179-2179       
   V1510 2180-2180          V1511 2181-2181          V1512 2182-2182       
   V1513 2183-2183          V1514 2184-2184          V1515 2185-2185       
   V1516 2186-2186          V1517 2187-2187          V1518 2188-2188       
   V1519 2189-2189          V1520 2190-2190          V1521 2191-2191       
   V1522 2192-2192          V1523 2193-2193          V1524 2194-2194       
   V1525 2195-2195          V1526 2196-2196          V1527 2197-2197       
   V1528 2198-2198          V1529 2199-2199          V1530 2200-2200       
   V1531 2201-2201          V1532 2202-2202          V1533 2203-2203       
   V1534 2204-2204          V1535 2205-2205          V1536 2206-2206       
   V1537 2207-2208          V1538 2209-2210          V1539 2211-2212       
   V1540 2213-2214          V1541 2215-2216          V1542 2217-2218       
   V1543 2219-2220          V1544 2221-2222          V1545 2223-2224       
   V1546 2225-2226          V1547 2227-2228          V1548 2229-2230       
   V1549 2231-2232          V1550 2233-2234          V1551 2235-2236       
   V1552 2237-2238          V1553 2239-2240          V1554 2241-2242       
   V1555 2243-2244          V1556 2245-2246          V1557 2247-2248       
   V1558 2249-2250          V1559 2251-2252          V1560 2253-2254       
   V1561 2255-2255          V1562 2256-2256          V1563 2257-2257       
   V1564 2258-2258          V1565 2259-2259          V1566 2260-2260       
   V1567 2261-2261          V1568 2262-2262          V1569 2263-2263       
   V1570 2264-2264          V1571 2265-2265          V1572 2266-2266       
   V1573 2267-2267          V1574 2268-2268          V1575 2269-2269       
   V1576 2270-2270          V1577 2271-2271          V1578 2272-2272       
   V1579 2273-2273          V1580 2274-2274          V1581 2275-2275       
   V1582 2276-2276          V1583 2277-2277          V1584 2278-2278       
   V1585 2279-2279          V1586 2280-2280          V1587 2281-2281       
   V1588 2282-2282          V1589 2283-2283          V1590 2284-2284       
   V1591 2285-2285          V1592 2286-2286          V1593 2287-2287       
   V1594 2288-2288          V1595 2289-2289          V1596 2290-2290       
   V1597 2291-2291          V1598 2292-2292          V1599 2293-2293       
   V1600 2294-2294          V1601 2295-2295          V1602 2296-2296       
   V1603 2297-2297          V1604 2298-2298          V1605 2299-2299       
   V1606 2300-2300          V1607 2301-2301          V1608 2302-2302       
   V1609 2303-2303          V1610 2304-2304          V1611 2305-2305       
   V1612 2306-2306          V1613 2307-2307          V1614 2308-2308       
   V1615 2309-2309          V1616 2310-2310          V1617 2311-2311       
   V1618 2312-2312          V1619 2313-2313          V1620 2314-2314       
   V1621 2315-2315          V1622 2316-2316          V1623 2317-2317       
   V1624 2318-2318          V1625 2319-2319          V1626 2320-2320       
   V1627 2321-2321          V1628 2322-2322          V1629 2323-2323       
   V1630 2324-2324          V1631 2325-2325          V1632 2326-2326       
   V1633 2327-2328          V1634 2329-2330          V1635 2331-2332       
   V1636 2333-2334          V1637 2335-2336          V1638 2337-2338       
   V1639 2339-2340          V1640 2341-2342          V1641 2343-2344       
   V1642 2345-2346          V1643 2347-2348          V1644 2349-2350       
   V1645 2351-2352          V1646 2353-2354          V1647 2355-2356       
   V1648 2357-2358          V1649 2359-2360          V1650 2361-2362       
   V1651 2363-2364          V1652 2365-2366          V1653 2367-2368       
   V1654 2369-2370          V1655 2371-2372          V1656 2373-2374       
   V1657 2375-2375          V1658 2376-2376          V1659 2377-2377       
   V1660 2378-2378          V1661 2379-2379          V1662 2380-2380       
   V1663 2381-2381          V1664 2382-2382          V1665 2383-2383       
   V1666 2384-2384          V1667 2385-2385          V1668 2386-2386       
   V1669 2387-2387          V1670 2388-2388          V1671 2389-2389       
   V1672 2390-2390          V1673 2391-2391          V1674 2392-2392       
   V1675 2393-2393          V1676 2394-2394          V1677 2395-2395       
   V1678 2396-2396          V1679 2397-2397          V1680 2398-2398       
   V1681 2399-2399          V1682 2400-2400          V1683 2401-2401       
   V1684 2402-2402          V1685 2403-2403          V1686 2404-2404       
   V1687 2405-2405          V1688 2406-2406          V1689 2407-2408       
   V1690 2409-2409          V1691 2410-2410          V1692 2411-2411       
   V1693 2412-2413          V1694 2414-2415          V1695 2416-2417       
   V1696 2418-2419          V1697 2420-2421          V1698 2422-2423       
   V1699 2424-2425          V1700 2426-2427          V1701 2428-2429       
   V1702 2430-2431          V1703 2432-2433          V1704 2434-2435       
   V1705 2436-2437          V1706 2438-2439          V1707 2440-2441       
   V1708 2442-2443          V1709 2444-2445          V1710 2446-2447       
   V1711 2448-2448          V1712 2449-2450          V1713 2451-2451       
   V1714 2452-2453          V1715 2454-2455          V1716 2456-2457       
   V1717 2458-2459          V1718 2460-2461          V1719 2462-2463       
   V1720 2464-2465          V1721 2466-2467          V1722 2468-2469       
   V1723 2470-2471          V1724 2472-2473          V1725 2474-2475       
   V1726 2476-2476          V1727 2477-2478          V1728 2479-2480       
   V1729 2481-2481          V1730 2482-2483          V1731 2484-2484       
   V1732 2485-2485          V1733 2486-2486          V1734 2487-2487       
   V1735 2488-2489          V1736 2490-2490          V1737 2491-2491       
   V1738 2492-2492          V1739 2493-2493          V1740 2494-2495       
   V1741 2496-2496          V1742 2497-2497          V1743 2498-2498       
   V1744 2499-2499          V1745 2500-2500          V1746 2501-2501       
   V1747 2502-2502          V1748 2503-2503          V1749 2504-2504       
   V1750 2505-2505          V1751 2506-2506          V1752 2507-2507       
   V1753 2508-2508          V1754 2509-2509          V1755 2510-2510       
   V1756 2511-2511          V1757 2512-2512          V1758 2513-2513       
   V1759 2514-2514          V1760 2515-2515          V1761 2516-2516       
   V1762 2517-2517          V1763 2518-2518          V1764 2519-2519       
   V1765 2520-2520          V1766 2521-2521          V1767 2522-2522       
   V1768 2523-2523          V1769 2524-2524          V1770 2525-2525       
   V1771 2526-2526          V1772 2527-2527          V1773 2528-2528       
   V1774 2529-2529          V1775 2530-2530          V1776 2531-2531       
   V1777 2532-2532          V1778 2533-2533          V1779 2534-2534       
   V1780 2535-2535          V1781 2536-2536          V1782 2537-2537       
   V1783 2538-2538          V1784 2539-2539          V1785 2540-2540       
   V1786 2541-2541          V1787 2542-2542          V1788 2543-2543       
   V1789 2544-2545          V1790 2546-2547          V1791 2548-2549       
   V1792 2550-2551          V1793 2552-2553          V1794 2554-2555       
   V1795 2556-2557          V1796 2558-2559          V1797 2560-2561       
   V1798 2562-2563          V1799 2564-2565          V1800 2566-2567       
   V1801 2568-2569          V1802 2570-2571          V1803 2572-2573       
   V1804 2574-2575          V1805 2576-2577          V1806 2578-2579       
   V1807 2580-2581          V1808 2582-2583          V1809 2584-2585       
   V1810 2586-2587          V1811 2588-2589          V1812 2590-2591       
   V1813 2592-2592          V1814 2593-2593          V1815 2594-2594       
   V1816 2595-2595          V1817 2596-2596          V1818 2597-2597       
   V1819 2598-2598          V1820 2599-2599          V1821 2600-2600       
   V1822 2601-2601          V1823 2602-2602          V1824 2603-2603       
   V1825 2604-2604          V1826 2605-2605          V1827 2606-2606       
   V1828 2607-2607          V1829 2608-2608          V1830 2609-2609       
   V1831 2610-2610          V1832 2611-2611          V1833 2612-2612       
   V1834 2613-2613          V1835 2614-2614          V1836 2615-2615       
   V1837 2616-2616          V1838 2617-2617          V1839 2618-2619       
   V1840 2620-2620          V1841 2621-2622          V1842 2623-2623       
   V1843 2624-2624          V1844 2625-2625          V1845 2626-2626       
   V1846 2627-2627          V1847 2628-2628          V1848 2629-2629       
   V1849 2630-2631          V1850 2632-2633          V1851 2634-2635       
   V1852 2636-2637          V1853 2638-2639          V1854 2640-2641       
   V1855 2642-2643          V1856 2644-2645          V1857 2646-2647       
   V1858 2648-2649          V1859 2650-2651          V1860 2652-2653       
   V1861 2654-2655          V1862 2656-2657          V1863 2658-2659       
   V1864 2660-2661          V1865 2662-2663          V1866 2664-2665       
   V1867 2666-2667          V1868 2668-2669          V1869 2670-2671       
   V1870 2672-2673          V1871 2674-2675          V1872 2676-2677       
   V1873 2678-2678          V1874 2679-2679          V1875 2680-2680       
   V1876 2681-2681          V1877 2682-2682          V1878 2683-2683       
   V1879 2684-2684          V1880 2685-2685          V1881 2686-2687       
   V1882 2688-2689          V1883 2690-2690          V1884 2691-2691       
   V1885 2692-2692          V1886 2693-2693          V1887 2694-2694       
   V1888 2695-2695          V1889 2696-2696          V1890 2697-2697       
   V1891 2698-2699          V1892 2700-2701          V1893 2702-2702       
   V1894 2703-2704          V1895 2705-2705          V1896 2706-2706       
   V1897 2707-2707          V1898 2708-2708          V1899 2709-2709       
   V1900 2710-2710          V1901 2711-2711          V1902 2712-2712       
   V1903 2713-2713          V1904 2714-2714          V1905 2715-2715       
   V1906 2716-2716          V1907 2717-2717          V1908 2718-2718       
   V1909 2719-2719          V1910 2720-2721          V1911 2722-2723       
   V1912 2724-2724          V1913 2725-2725          V1914 2726-2726       
   V1915 2727-2728          V1916 2729-2729          V1917 2730-2730       
   V1918 2731-2731          V1919 2732-2732          V1920 2733-2733       
   V1921 2734-2735          V1922 2736-2736          V1923 2737-2737       
   V1924 2738-2739          V1925 2740-2740          V1926 2741-2741       
   V1927 2742-2743          V1928 2744-2745          V1929 2746-2746       
   V1930 2747-2748          V1931 2749-2749          V1932 2750-2750       
   V1933 2751-2751          V1934 2752-2752          V1935 2753-2753       
   V1936 2754-2754          V1937 2755-2755          V1938 2756-2756       
   V1939 2757-2757          V1940 2758-2758          V1941 2759-2759       
   V1942 2760-2760          V1943 2761-2761          V1944 2762-2762       
   V1945 2763-2764          V1946 2765-2766          V1947 2767-2768       
   V1948 2769-2770          V1949 2771-2772          V1950 2773-2774       
   V1951 2775-2776          V1952 2777-2778          V1953 2779-2780       
   V1954 2781-2782          V1955 2783-2784          V1956 2785-2786       
   V1957 2787-2789          V1958 2790-2792          V1959 2793-2795       
   V1960 2796-2798          V1961 2799-2801          V1962 2802-2804       
   V1963 2805-2807          V1964 2808-2810          V1965 2811-2813       
   V1966 2814-2816          V1967 2817-2819          V1968 2820-2822       
   V1969 2823-2824          V1970 2825-2826          V1971 2827-2828       
   V1972 2829-2830          V1973 2831-2832          V1974 2833-2834       
   V1975 2835-2836          V1976 2837-2838          V1977 2839-2840       
   V1978 2841-2842          V1979 2843-2844          V1980 2845-2846       
   V1981 2847-2847          V1982 2848-2848          V1983 2849-2850       
   V1984 2851-2851          V1985 2852-2852          V1986 2853-2853       
   V1987 2854-2855          V1988 2856-2856          V1989 2857-2857       
   V1990 2858-2859          V1991 2860-2860          V1992 2861-2861       
   V1993 2862-2863          V1994 2864-2865          V1995 2866-2867       
   V1996 2868-2869          V1997 2870-2871          V1998 2872-2873       
   V1999 2874-2875          V2000 2876-2877          V2001 2878-2879       
   V2002 2880-2881          V2003 2882-2882          V2004 2883-2884       
   V2005 2885-2887          V2006 2888-2890          V2007 2891-2893       
   V2008 2894-2896          V2009 2897-2899          V2010 2900-2902       
   V2011 2903-2905          V2012 2906-2908          V2013 2909-2911       
   V2014 2912-2914          V2015 2915-2917          V2016 2918-2920       
   V2017 2921-2923          V2018 2924-2926          V2019 2927-2929       
   V2020 2930-2932          V2021 2933-2935          V2022 2936-2938       
   V2023 2939-2941          V2024 2942-2944          V2025 2945-2947       
   V2026 2948-2950          V2027 2951-2952          V2028 2953-2955       
   V2029 2956-2957          V2030 2958-2959          V2031 2960-2961       
   V2032 2962-2963          V2033 2964-2965          V2034 2966-2967       
   V2035 2968-2969          V2036 2970-2971          V2037 2972-2973       
   V2038 2974-2975          V2039 2976-2977          V2040 2978-2979       
   V2041 2980-2981          V2042 2982-2983          V2043 2984-2985       
   V2044 2986-2987          V2045 2988-2989          V2046 2990-2991       
   V2047 2992-2993          V2048 2994-2995          V2049 2996-2997       
   V2050 2998-2999          V2051 3000-3001          V2052 3002-3003       
   V2053 3004-3004          V2054 3005-3005          V2055 3006-3006       
   V2056 3007-3008          V2057 3009-3009          V2058 3010-3010       
   V2059 3011-3011          V2060 3012-3012          V2061 3013-3013       
   V2062 3014-3014          V2063 3015-3015          V2064 3016-3016       
   V2065 3017-3018          V2066 3019-3020          V2067 3021-3022       
   V2068 3023-3024          V2069 3025-3026          V2070 3027-3028       
   V2071 3029-3030          V2072 3031-3032          V2073 3033-3034       
   V2074 3035-3036          V2075 3037-3038          V2076 3039-3040       
   V2077 3041-3042          V2078 3043-3044          V2079 3045-3046       
   V2080 3047-3048          V2081 3049-3050          V2082 3051-3052       
   V2083 3053-3054          V2084 3055-3056          V2085 3057-3058       
   V2086 3059-3060          V2087 3061-3062          V2088 3063-3064       
   V2089 3065-3066          V2090 3067-3068          V2091 3069-3070       
   V2092 3071-3072          V2093 3073-3074          V2094 3075-3076       
   V2095 3077-3078          V2096 3079-3080          V2097 3081-3082       
   V2098 3083-3084          V2099 3085-3086          V2100 3087-3088       
   V2101 3089-3091          V2102 3092-3094          V2103 3095-3097       
   V2104 3098-3100          V2105 3101-3103          V2106 3104-3106       
   V2107 3107-3109          V2108 3110-3112          V2109 3113-3115       
   V2110 3116-3118          V2111 3119-3121          V2112 3122-3124       
   V2113 3125-3126          V2114 3127-3128          V2115 3129-3130       
   V2116 3131-3132          V2117 3133-3134          V2118 3135-3136       
   V2119 3137-3138          V2120 3139-3140          V2121 3141-3142       
   V2122 3143-3144          V2123 3145-3146          V2124 3147-3148       
   V2125 3149-3150          V2126 3151-3152          V2127 3153-3154       
   V2128 3155-3156          V2129 3157-3158          V2130 3159-3160       
   V2131 3161-3162          V2132 3163-3164          V2133 3165-3166       
   V2134 3167-3168          V2135 3169-3170          V2136 3171-3172       
   V2137 3173-3173          V2138 3174-3175          V2139 3176-3176       
   V2140 3177-3178          V2141 3179-3180          V2142 3181-3182       
   V2143 3183-3184          V2144 3185-3186          V2145 3187-3188       
   V2146 3189-3189          V2147 3190-3190          V2148 3191-3192       
   V2149 3193-3193          V2150 3194-3194          V2151 3195-3195       
   V2152 3196-3197          V2153 3198-3198          V2154 3199-3199       
   V2155 3200-3200          V2156 3201-3201          V2157 3202-3202       
   V2158 3203-3203          V2159 3204-3204          V2160 3205-3205       
   V2161 3206-3207          V2162 3208-3208          V2163 3209-3209       
   V2164 3210-3211          V2165 3212-3213          V2166 3214-3215       
   V2167 3216-3217          V2168 3218-3218          V2169 3219-3220       
   V2170 3221-3222          V2171 3223-3223          V2172 3224-3224       
   V2173 3225-3226          V2174 3227-3228          V2175 3229-3229       
   V2176 3230-3231          V2177 3232-3233          V2178 3234-3235       
   V2179 3236-3237          V2180 3238-3238          V2181 3239-3240       
   V2182 3241-3242          V2183 3243-3244          V2184 3245-3245       
   V2185 3246-3247          V2186 3248-3249          V2187 3250-3251       
   V2188 3252-3253          V2189 3254-3255          V2190 3256-3257       
   V2191 3258-3259          V2192 3260-3261          V2193 3262-3263       
   V2194 3264-3265          V2195 3266-3267          V2196 3268-3269       
   V2197 3270-3271          V2198 3272-3273          V2199 3274-3275       
   V2200 3276-3277          V2201 3278-3279          V2202 3280-3281       
   V2203 3282-3283          V2204 3284-3285          V2205 3286-3287       
   V2206 3288-3289          V2207 3290-3291          V2208 3292-3293       
   V2209 3294-3295          V2210 3296-3297          V2211 3298-3299       
   V2212 3300-3301          V2213 3302-3303          V2214 3304-3305       
   V2215 3306-3307          V2216 3308-3309          V2217 3310-3311       
   V2218 3312-3313          V2219 3314-3315          V2220 3316-3317       
   V2221 3318-3319          V2222 3320-3321          V2223 3322-3323       
   V2224 3324-3325          V2225 3326-3327          V2226 3328-3329       
   V2227 3330-3331          V2228 3332-3333          V2229 3334-3335       
   V2230 3336-3337          V2231 3338-3339          V2232 3340-3341       
   V2233 3342-3343          V2234 3344-3345          V2235 3346-3347       
   V2236 3348-3349          V2237 3350-3351          V2238 3352-3353       
   V2239 3354-3355          V2240 3356-3357          V2241 3358-3359       
   V2242 3360-3361          V2243 3362-3363          V2244 3364-3365       
   V2245 3366-3367          V2246 3368-3369          V2247 3370-3371       
   V2248 3372-3373          V2249 3374-3375          V2250 3376-3377       
   V2251 3378-3379          V2252 3380-3381          V2253 3382-3383       
   V2254 3384-3389          V2255 3390-3395          V2256 3396-3401;      
                                                                           
* SAS LABEL STATEMENT;                                                     
                                                                           
LABEL                                                                      
   V1 = "ICPSR STUDY NUMBER"                                               
   V2 = "ICPSR EDITION NUMBER"                                             
   V3 = "ICPSR PART NUMBER"                                                
   V4 = "ICPSR SEQUENTIAL ID"                                              
   V5 = "STATE CODE"                                                       
   V6 = "ORI CODE"                                                         
   V7 = "GROUP"                                                            
   V8 = "SUB-GROUP"                                                        
   V9 = "GEOGRAPHIC DIVISION"                                              
   V10 = "YEAR"                                                            
   V11 = "SEQUENCE NUMBER"                                                 
   V12 = "SMSA"                                                            
   V13 = "POPULATION"                                                      
   V14 = "AGENCY NAME"                                                     
   V15 = "STATE NAME"                                                      
   V16 = "NUMBER MALE OFFICERS"                                            
   V17 = "NUMBER MALE CIVILIANS"                                           
   V18 = "TOTAL MALE EMPLOYEES"                                            
   V19 = "NUMBER FEMALE OFFICERS"                                          
   V20 = "NUMBER FEMALE CIVILIANS"                                         
   V21 = "TOTAL FEMALE EMPLOYEES"                                          
   V22 = "TOTAL EMPLOYEES"                                                 
   V23 = "OFFICER RATE PER 1K POP"                                         
   V24 = "EMPLOYEE RATE PER 1K POP"                                        
   V25 = "ONE MAN VEHICLE-DAY"                                             
   V26 = "ONE MAN VEHICLE-EVENING"                                         
   V27 = "ONE MAN VEHICLE-NIGHT"                                           
   V28 = "ONE MAN VEHICLE-OTHER"                                           
   V29 = "ONE MAN VEHICLE-TOTAL"                                           
   V30 = "TWO MAN VEHICLE-DAY"                                             
   V31 = "TWO MAN VEHICLE-EVENING"                                         
   V32 = "TWO MAN VEHICLE-NIGHT"                                           
   V33 = "TWO MAN VEHICLE-OTHER"                                           
   V34 = "TWO MAN VEHICLE-TOTAL"                                           
   V35 = "ONE MAN FOOT - DAY"                                              
   V36 = "ONE MAN FOOT - EVENING"                                          
   V37 = "ONE MAN FOOT - NIGHT"                                            
   V38 = "ONE MAN FOOT - OTHER"                                            
   V39 = "ONE MAN FOOT - TOTAL"                                            
   V40 = "TWO MAN FOOT - DAY"                                              
   V41 = "TWO MAN FOOT - EVENING"                                          
   V42 = "TWO MAN FOOT - NIGHT"                                            
   V43 = "TWO MAN FOOT - OTHER"                                            
   V44 = "TWO MAN FOOT - TOTAL"                                            
   V45 = "OTHER PATROLS - DAY"                                             
   V46 = "OTHER PATROLS - EVENING"                                         
   V47 = "OTHER PATROLS - NIGHT"                                           
   V48 = "OTHER PATROLS - OTHER"                                           
   V49 = "OTHER PATROLS - TOTAL"                                           
   V50 = "TOTAL PATROLS - DAY"                                             
   V51 = "TOTAL PATROLS - EVENING"                                         
   V52 = "TOTAL PATROLS - NIGHT"                                           
   V53 = "TOTAL PATROLS - OTHER"                                           
   V54 = "TOTAL PATROLS - TOTAL"                                           
   V55 = "REPORT INDICATOR"                                                
   V56 = "RECORD INDICATOR"                                                
   V57 = "MONTH INDICATOR - JAN"                                           
   V58 = "MONTH INDICATOR - FEB"                                           
   V59 = "MONTH INDICATOR - MAR"                                           
   V60 = "MONTH INDICATOR - APR"                                           
   V61 = "MONTH INDICATOR - MAY"                                           
   V62 = "MONTH INDICATOR - JUN"                                           
   V63 = "MONTH INDICATOR - JUL"                                           
   V64 = "MONTH INDICATOR - AUG"                                           
   V65 = "MONTH INDICATOR - SEP"                                           
   V66 = "MONTH INDICATOR - OCT"                                           
   V67 = "MONTH INDICATOR - NOV"                                           
   V68 = "MONTH INDICATOR - DEC"                                           
   V69 = "MONTH INCLUDED"                                                  
   V70 = "COVERED BY OTHER AGENCY"                                         
   V71 = "SHIFT DATA"                                                      
   V72 = "NO MALE-FEMALE BREAKDOWN"                                        
   V73 = "ASSAULT W-INJURY:  JAN"                                          
   V74 = "ASSAULT W-INJURY:  FEB"                                          
   V75 = "ASSAULT W-INJURY:  MAR"                                          
   V76 = "ASSAULT W-INJURY:  APR"                                          
   V77 = "ASSAULT W-INJURY:  MAY"                                          
   V78 = "ASSAULT W-INJURY:  JUN"                                          
   V79 = "ASSAULT W-INJURY:  JUL"                                          
   V80 = "ASSAULT W-INJURY:  AUG"                                          
   V81 = "ASSAULT W-INJURY:  SEP"                                          
   V82 = "ASSAULT W-INJURY:  OCT"                                          
   V83 = "ASSAULT W-INJURY:  NOV"                                          
   V84 = "ASSAULT W-INJURY:  DEC"                                          
   V85 = "ASSAULT W-O INJURY:JAN"                                          
   V86 = "ASSAULT W-O INJURY:FEB"                                          
   V87 = "ASSAULT W-O INJURY:MAR"                                          
   V88 = "ASSAULT W-O INJURY:APR"                                          
   V89 = "ASSAULT W-O INJURY:MAY"                                          
   V90 = "ASSAULT W-O INJURY:JUN"                                          
   V91 = "ASSAULT W-O INJURY:JUL"                                          
   V92 = "ASSAULT W-O INJURY:AUG"                                          
   V93 = "ASSAULT W-O INJURY:SEP"                                          
   V94 = "ASSAULT W-O INJURY:OCT"                                          
   V95 = "ASSAULT W-O INJURY:NOV"                                          
   V96 = "ASSAULT W-O INJURY:DEC"                                          
   V97 = "OFFCRS KILLED FELONY:JAN"                                        
   V98 = "OFFCRS KILLED FELONY:FEB"                                        
   V99 = "OFFCRS KILLED FELONY:MAR"                                        
   V100 = "OFFCRS KILLED FELONY:APR"                                       
   V101 = "OFFCRS KILLED FELONY:MAY"                                       
   V102 = "OFFCRS KILLED FELONY:JUN"                                       
   V103 = "OFFCRS KILLED FELONY:JUL"                                       
   V104 = "OFFCRS KILLED FELONY:AUG"                                       
   V105 = "OFFCRS KILLED FELONY:SEP"                                       
   V106 = "OFFCRS KILLED FELONY:OCT"                                       
   V107 = "OFFCRS KILLED FELONY:NOV"                                       
   V108 = "OFFCRS KILLED FELONY:DEC"                                       
   V109 = "OFFCRS KILLED ACCDNT:JAN"                                       
   V110 = "OFFCRS KILLED ACCDNT:FEB"                                       
   V111 = "OFFCRS KILLED ACCDNT:MAR"                                       
   V112 = "OFFCRS KILLED ACCDNT:APR"                                       
   V113 = "OFFCRS KILLED ACCDNT:MAY"                                       
   V114 = "OFFCRS KILLED ACCDNT:JUN"                                       
   V115 = "OFFCRS KILLED ACCDNT:JUL"                                       
   V116 = "OFFCRS KILLED ACCDNT:AUG"                                       
   V117 = "OFFCRS KILLED ACCDNT:SEP"                                       
   V118 = "OFFCRS KILLED ACCDNT:OCT"                                       
   V119 = "OFFCRS KILLED ACCDNT:NOV"                                       
   V120 = "OFFCRS KILLED ACCDNT:DEC"                                       
   V121 = "ASSLT-INJ-FIREARM:  JAN"                                        
   V122 = "ASSLT-INJ-FIREARM:  FEB"                                        
   V123 = "ASSLT-INJ-FIREARM:  MAR"                                        
   V124 = "ASSLT-INJ-FIREARM:  APR"                                        
   V125 = "ASSLT-INJ-FIREARM:  MAY"                                        
   V126 = "ASSLT-INJ-FIREARM:  JUN"                                        
   V127 = "ASSLT-INJ-FIREARM:  JUL"                                        
   V128 = "ASSLT-INJ-FIREARM:  AUG"                                        
   V129 = "ASSLT-INJ-FIREARM:  SEP"                                        
   V130 = "ASSLT-INJ-FIREARM:  OCT"                                        
   V131 = "ASSLT-INJ-FIREARM:  NOV"                                        
   V132 = "ASSLT-INJ-FIREARM:  DEC"                                        
   V133 = "ASSLT-INJ-KNIFE:  JAN"                                          
   V134 = "ASSLT-INJ-KNIFE:  FEB"                                          
   V135 = "ASSLT-INJ-KNIFE:  MAR"                                          
   V136 = "ASSLT-INJ-KNIFE:  APR"                                          
   V137 = "ASSLT-INJ-KNIFE:  MAY"                                          
   V138 = "ASSLT-INJ-KNIFE:  JUN"                                          
   V139 = "ASSLT-INJ-KNIFE:  JUL"                                          
   V140 = "ASSLT-INJ-KNIFE:  AUG"                                          
   V141 = "ASSLT-INJ-KNIFE:  SEP"                                          
   V142 = "ASSLT-INJ-KNIFE:  OCT"                                          
   V143 = "ASSLT-INJ-KNIFE:  NOV"                                          
   V144 = "ASSLT-INJ-KNIFE:  DEC"                                          
   V145 = "ASSLT-INJ-OTHER:  JAN"                                          
   V146 = "ASSLT-INJ-OTHER:  FEB"                                          
   V147 = "ASSLT-INJ-OTHER:  MAR"                                          
   V148 = "ASSLT-INJ-OTHER:  APR"                                          
   V149 = "ASSLT-INJ-OTHER:  MAY"                                          
   V150 = "ASSLT-INJ-OTHER:  JUN"                                          
   V151 = "ASSLT-INJ-OTHER:  JUL"                                          
   V152 = "ASSLT-INJ-OTHER:  AUG"                                          
   V153 = "ASSLT-INJ-OTHER:  SEP"                                          
   V154 = "ASSLT-INJ-OTHER:  OCT"                                          
   V155 = "ASSLT-INJ-OTHER:  NOV"                                          
   V156 = "ASSLT-INJ-OTHER:  DEC"                                          
   V157 = "ASSLT-INJ-HAND-FT:  JAN"                                        
   V158 = "ASSLT-INJ-HAND-FT:  FEB"                                        
   V159 = "ASSLT-INJ-HAND-FT:  MAR"                                        
   V160 = "ASSLT-INJ-HAND-FT:  APR"                                        
   V161 = "ASSLT-INJ-HAND-FT:  MAY"                                        
   V162 = "ASSLT-INJ-HAND-FT:  JUN"                                        
   V163 = "ASSLT-INJ-HAND-FT:  JUL"                                        
   V164 = "ASSLT-INJ-HAND-FT:  AUG"                                        
   V165 = "ASSLT-INJ-HAND-FT:  SEP"                                        
   V166 = "ASSLT-INJ-HAND-FT:  OCT"                                        
   V167 = "ASSLT-INJ-HAND-FT:  NOV"                                        
   V168 = "ASSLT-INJ-HAND-FT:  DEC"                                        
   V169 = "ASSLT-INJ-TOTAL:  JAN"                                          
   V170 = "ASSLT-INJ-TOTAL:  FEB"                                          
   V171 = "ASSLT-INJ-TOTAL:  MAR"                                          
   V172 = "ASSLT-INJ-TOTAL:  APR"                                          
   V173 = "ASSLT-INJ-TOTAL:  MAY"                                          
   V174 = "ASSLT-INJ-TOTAL:  JUN"                                          
   V175 = "ASSLT-INJ-TOTAL:  JUL"                                          
   V176 = "ASSLT-INJ-TOTAL:  AUG"                                          
   V177 = "ASSLT-INJ-TOTAL:  SEP"                                          
   V178 = "ASSLT-INJ-TOTAL:  OCT"                                          
   V179 = "ASSLT-INJ-TOTAL:  NOV"                                          
   V180 = "ASSLT-INJ-TOTAL:  DEC"                                          
   V181 = "ASSLT-NO INJ-FIREARM:JAN"                                       
   V182 = "ASSLT-NO INJ-FIREARM:FEB"                                       
   V183 = "ASSLT-NO INJ-FIREARM:MAR"                                       
   V184 = "ASSLT-NO INJ-FIREARM:APR"                                       
   V185 = "ASSLT-NO INJ-FIREARM:MAY"                                       
   V186 = "ASSLT-NO INJ-FIREARM:JUN"                                       
   V187 = "ASSLT-NO INJ-FIREARM:JUL"                                       
   V188 = "ASSLT-NO INJ-FIREARM:AUG"                                       
   V189 = "ASSLT-NO INJ-FIREARM:SEP"                                       
   V190 = "ASSLT-NO INJ-FIREARM:OCT"                                       
   V191 = "ASSLT-NO INJ-FIREARM:NOV"                                       
   V192 = "ASSLT-NO INJ-FIREARM:DEC"                                       
   V193 = "ASSLT-NO INJ-KNIFE:  JAN"                                       
   V194 = "ASSLT-NO INJ-KNIFE:  FEB"                                       
   V195 = "ASSLT-NO INJ-KNIFE:  MAR"                                       
   V196 = "ASSLT-NO INJ-KNIFE:  APR"                                       
   V197 = "ASSLT-NO INJ-KNIFE:  MAY"                                       
   V198 = "ASSLT-NO INJ-KNIFE:  JUN"                                       
   V199 = "ASSLT-NO INJ-KNIFE:  JUL"                                       
   V200 = "ASSLT-NO INJ-KNIFE:  AUG"                                       
   V201 = "ASSLT-NO INJ-KNIFE:  SEP"                                       
   V202 = "ASSLT-NO INJ-KNIFE:  OCT"                                       
   V203 = "ASSLT-NO INJ-KNIFE:  NOV"                                       
   V204 = "ASSLT-NO INJ-KNIFE:  DEC"                                       
   V205 = "ASSLT-NO INJ-OTHER:  JAN"                                       
   V206 = "ASSLT-NO INJ-OTHER:  FEB"                                       
   V207 = "ASSLT-NO INJ-OTHER:  MAR"                                       
   V208 = "ASSLT-NO INJ-OTHER:  APR"                                       
   V209 = "ASSLT-NO INJ-OTHER:  MAY"                                       
   V210 = "ASSLT-NO INJ-OTHER:  JUN"                                       
   V211 = "ASSLT-NO INJ-OTHER:  JUL"                                       
   V212 = "ASSLT-NO INJ-OTHER:  AUG"                                       
   V213 = "ASSLT-NO INJ-OTHER:  SEP"                                       
   V214 = "ASSLT-NO INJ-OTHER:  OCT"                                       
   V215 = "ASSLT-NO INJ-OTHER:  NOV"                                       
   V216 = "ASSLT-NO INJ-OTHER:  DEC"                                       
   V217 = "ASSLT-NO INJ-HAND-FT:JAN"                                       
   V218 = "ASSLT-NO INJ-HAND-FT:FEB"                                       
   V219 = "ASSLT-NO INJ-HAND-FT:MAR"                                       
   V220 = "ASSLT-NO INJ-HAND-FT:APR"                                       
   V221 = "ASSLT-NO INJ-HAND-FT:MAY"                                       
   V222 = "ASSLT-NO INJ-HAND-FT:JUN"                                       
   V223 = "ASSLT-NO INJ-HAND-FT:JUL"                                       
   V224 = "ASSLT-NO INJ-HAND-FT:AUG"                                       
   V225 = "ASSLT-NO INJ-HAND-FT:SEP"                                       
   V226 = "ASSLT-NO INJ-HAND-FT:OCT"                                       
   V227 = "ASSLT-NO INJ-HAND-FT:NOV"                                       
   V228 = "ASSLT-NO INJ-HAND-FT:DEC"                                       
   V229 = "ASSLT-NO INJ-TOTAL:  JAN"                                       
   V230 = "ASSLT-NO INJ-TOTAL:  FEB"                                       
   V231 = "ASSLT-NO INJ-TOTAL:  MAR"                                       
   V232 = "ASSLT-NO INJ-TOTAL:  APR"                                       
   V233 = "ASSLT-NO INJ-TOTAL:  MAY"                                       
   V234 = "ASSLT-NO INJ-TOTAL:  JUN"                                       
   V235 = "ASSLT-NO INJ-TOTAL:  JUL"                                       
   V236 = "ASSLT-NO INJ-TOTAL:  AUG"                                       
   V237 = "ASSLT-NO INJ-TOTAL:  SEP"                                       
   V238 = "ASSLT-NO INJ-TOTAL:  OCT"                                       
   V239 = "ASSLT-NO INJ-TOTAL:  NOV"                                       
   V240 = "ASSLT-NO INJ-TOTAL:  DEC"                                       
   V241 = "DISTRB-TOT ASSLT:  JAN"                                         
   V242 = "DISTRB-TOT ASSLT:  FEB"                                         
   V243 = "DISTRB-TOT ASSLT:  MAR"                                         
   V244 = "DISTRB-TOT ASSLT:  APR"                                         
   V245 = "DISTRB-TOT ASSLT:  MAY"                                         
   V246 = "DISTRB-TOT ASSLT:  JUN"                                         
   V247 = "DISTRB-TOT ASSLT:  JUL"                                         
   V248 = "DISTRB-TOT ASSLT:  AUG"                                         
   V249 = "DISTRB-TOT ASSLT:  SEP"                                         
   V250 = "DISTRB-TOT ASSLT:  OCT"                                         
   V251 = "DISTRB-TOT ASSLT:  NOV"                                         
   V252 = "DISTRB-TOT ASSLT:  DEC"                                         
   V253 = "DISTRB-FIREARM:  JAN"                                           
   V254 = "DISTRB-FIREARM:  FEB"                                           
   V255 = "DISTRB-FIREARM:  MAR"                                           
   V256 = "DISTRB-FIREARM:  APR"                                           
   V257 = "DISTRB-FIREARM:  MAY"                                           
   V258 = "DISTRB-FIREARM:  JUN"                                           
   V259 = "DISTRB-FIREARM:  JUL"                                           
   V260 = "DISTRB-FIREARM:  AUG"                                           
   V261 = "DISTRB-FIREARM:  SEP"                                           
   V262 = "DISTRB-FIREARM:  OCT"                                           
   V263 = "DISTRB-FIREARM:  NOV"                                           
   V264 = "DISTRB-FIREARM:  DEC"                                           
   V265 = "DISTRB-KNIFE:  JAN"                                             
   V266 = "DISTRB-KNIFE:  FEB"                                             
   V267 = "DISTRB-KNIFE:  MAR"                                             
   V268 = "DISTRB-KNIFE:  APR"                                             
   V269 = "DISTRB-KNIFE:  MAY"                                             
   V270 = "DISTRB-KNIFE:  JUN"                                             
   V271 = "DISTRB-KNIFE:  JUL"                                             
   V272 = "DISTRB-KNIFE:  AUG"                                             
   V273 = "DISTRB-KNIFE:  SEP"                                             
   V274 = "DISTRB-KNIFE:  OCT"                                             
   V275 = "DISTRB-KNIFE:  NOV"                                             
   V276 = "DISTRB-KNIFE:  DEC"                                             
   V277 = "DISTRB-OTHER:  JAN"                                             
   V278 = "DISTRB-OTHER:  FEB"                                             
   V279 = "DISTRB-OTHER:  MAR"                                             
   V280 = "DISTRB-OTHER:  APR"                                             
   V281 = "DISTRB-OTHER:  MAY"                                             
   V282 = "DISTRB-OTHER:  JUN"                                             
   V283 = "DISTRB-OTHER:  JUL"                                             
   V284 = "DISTRB-OTHER:  AUG"                                             
   V285 = "DISTRB-OTHER:  SEP"                                             
   V286 = "DISTRB-OTHER:  OCT"                                             
   V287 = "DISTRB-OTHER:  NOV"                                             
   V288 = "DISTRB-OTHER:  DEC"                                             
   V289 = "DISTRB-HANDS FEET:  JAN"                                        
   V290 = "DISTRB-HANDS FEET:  FEB"                                        
   V291 = "DISTRB-HANDS FEET:  MAR"                                        
   V292 = "DISTRB-HANDS FEET:  APR"                                        
   V293 = "DISTRB-HANDS FEET:  MAY"                                        
   V294 = "DISTRB-HANDS FEET:  JUN"                                        
   V295 = "DISTRB-HANDS FEET:  JUL"                                        
   V296 = "DISTRB-HANDS FEET:  AUG"                                        
   V297 = "DISTRB-HANDS FEET:  SEP"                                        
   V298 = "DISTRB-HANDS FEET:  OCT"                                        
   V299 = "DISTRB-HANDS FEET:  NOV"                                        
   V300 = "DISTRB-HANDS FEET:  DEC"                                        
   V301 = "DISTRB-2-MAN VEHICLE:JAN"                                       
   V302 = "DISTRB-2-MAN VEHICLE:FEB"                                       
   V303 = "DISTRB-2-MAN VEHICLE:MAR"                                       
   V304 = "DISTRB-2-MAN VEHICLE:APR"                                       
   V305 = "DISTRB-2-MAN VEHICLE:MAY"                                       
   V306 = "DISTRB-2-MAN VEHICLE:JUN"                                       
   V307 = "DISTRB-2-MAN VEHICLE:JUL"                                       
   V308 = "DISTRB-2-MAN VEHICLE:AUG"                                       
   V309 = "DISTRB-2-MAN VEHICLE:SEP"                                       
   V310 = "DISTRB-2-MAN VEHICLE:OCT"                                       
   V311 = "DISTRB-2-MAN VEHICLE:NOV"                                       
   V312 = "DISTRB-2-MAN VEHICLE:DEC"                                       
   V313 = "DISTRB-1-MAN ALONE:  JAN"                                       
   V314 = "DISTRB-1-MAN ALONE:  FEB"                                       
   V315 = "DISTRB-1-MAN ALONE:  MAR"                                       
   V316 = "DISTRB-1-MAN ALONE:  APR"                                       
   V317 = "DISTRB-1-MAN ALONE:  MAY"                                       
   V318 = "DISTRB-1-MAN ALONE:  JUN"                                       
   V319 = "DISTRB-1-MAN ALONE:  JUL"                                       
   V320 = "DISTRB-1-MAN ALONE:  AUG"                                       
   V321 = "DISTRB-1-MAN ALONE:  SEP"                                       
   V322 = "DISTRB-1-MAN ALONE:  OCT"                                       
   V323 = "DISTRB-1-MAN ALONE:  NOV"                                       
   V324 = "DISTRB-1-MAN ALONE:  DEC"                                       
   V325 = "DT: RB-1-MAN ASST:  JAN"                                        
   V326 = "DT: RB-1-MAN ASST:  FEB"                                        
   V327 = "DT: RB-1-MAN ASST:  MAR"                                        
   V328 = "DT: RB-1-MAN ASST:  APR"                                        
   V329 = "DT: RB-1-MAN ASST:  MAY"                                        
   V330 = "DT: RB-1-MAN ASST:  JUN"                                        
   V331 = "DT: RB-1-MAN ASST:  JUL"                                        
   V332 = "DT: RB-1-MAN ASST:  AUG"                                        
   V333 = "DT: RB-1-MAN ASST:  SEP"                                        
   V334 = "DT: RB-1-MAN ASST:  OCT"                                        
   V335 = "DT: RB-1-MAN ASST:  NOV"                                        
   V336 = "DT: RB-1-MAN ASST:  DEC"                                        
   V337 = "DIST-DETEC ALONE:  JAN"                                         
   V338 = "DIST-DETEC ALONE:  FEB"                                         
   V339 = "DIST-DETEC ALONE:  MAR"                                         
   V340 = "DIST-DETEC ALONE:  APR"                                         
   V341 = "DIST-DETEC ALONE:  MAY"                                         
   V342 = "DIST-DETEC ALONE:  JUN"                                         
   V343 = "DIST-DETEC ALONE:  JUL"                                         
   V344 = "DIST-DETEC ALONE:  AUG"                                         
   V345 = "DIST-DETEC ALONE:  SEP"                                         
   V346 = "DIST-DETEC ALONE:  OCT"                                         
   V347 = "DIST-DETEC ALONE:  NOV"                                         
   V348 = "DIST-DETEC ALONE:  DEC"                                         
   V349 = "DIST-DETEC ASST:  JAN"                                          
   V350 = "DIST-DETEC ASST:  FEB"                                          
   V351 = "DIST-DETEC ASST:  MAR"                                          
   V352 = "DIST-DETEC ASST:  APR"                                          
   V353 = "DIST-DETEC ASST:  MAY"                                          
   V354 = "DIST-DETEC ASST:  JUN"                                          
   V355 = "DIST-DETEC ASST:  JUL"                                          
   V356 = "DIST-DETEC ASST:  AUG"                                          
   V357 = "DIST-DETEC ASST:  SEP"                                          
   V358 = "DIST-DETEC ASST:  OCT"                                          
   V359 = "DIST-DETEC ASST:  NOV"                                          
   V360 = "DIST-DETEC ASST:  DEC"                                          
   V361 = "DISTRB-OTHER ALONE:  JAN"                                       
   V362 = "DISTRB-OTHER ALONE:  FEB"                                       
   V363 = "DISTRB-OTHER ALONE:  MAR"                                       
   V364 = "DISTRB-OTHER ALONE:  APR"                                       
   V365 = "DISTRB-OTHER ALONE:  MAY"                                       
   V366 = "DISTRB-OTHER ALONE:  JUN"                                       
   V367 = "DISTRB-OTHER ALONE:  JUL"                                       
   V368 = "DISTRB-OTHER ALONE:  AUG"                                       
   V369 = "DISTRB-OTHER ALONE:  SEP"                                       
   V370 = "DISTRB-OTHER ALONE:  OCT"                                       
   V371 = "DISTRB-OTHER ALONE:  NOV"                                       
   V372 = "DISTRB-OTHER ALONE:  DEC"                                       
   V373 = "DISTRB-OTHER ASST:  JAN"                                        
   V374 = "DISTRB-OTHER ASST:  FEB"                                        
   V375 = "DISTRB-OTHER ASST:  MAR"                                        
   V376 = "DISTRB-OTHER ASST:  APR"                                        
   V377 = "DISTRB-OTHER ASST:  MAY"                                        
   V378 = "DISTRB-OTHER ASST:  JUN"                                        
   V379 = "DISTRB-OTHER ASST:  JUL"                                        
   V380 = "DISTRB-OTHER ASST:  AUG"                                        
   V381 = "DISTRB-OTHER ASST:  SEP"                                        
   V382 = "DISTRB-OTHER ASST:  OCT"                                        
   V383 = "DISTRB-OTHER ASST:  NOV"                                        
   V384 = "DISTRB-OTHER ASST:  DEC"                                        
   V385 = "DISTRB-ASSLTS CLEAR: JAN"                                       
   V386 = "DISTRB-ASSLTS CLEAR: FEB"                                       
   V387 = "DISTRB-ASSLTS CLEAR: MAR"                                       
   V388 = "DISTRB-ASSLTS CLEAR: APR"                                       
   V389 = "DISTRB-ASSLTS CLEAR: MAY"                                       
   V390 = "DISTRB-ASSLTS CLEAR: JUN"                                       
   V391 = "DISTRB-ASSLTS CLEAR: JUL"                                       
   V392 = "DISTRB-ASSLTS CLEAR: AUG"                                       
   V393 = "DISTRB-ASSLTS CLEAR: SEP"                                       
   V394 = "DISTRB-ASSLTS CLEAR: OCT"                                       
   V395 = "DISTRB-ASSLTS CLEAR: NOV"                                       
   V396 = "DISTRB-ASSLTS CLEAR: DEC"                                       
   V397 = "BURGLAR-TOT ASSLT:  JAN"                                        
   V398 = "BURGLAR-TOT ASSLT:  FEB"                                        
   V399 = "BURGLAR-TOT ASSLT:  MAR"                                        
   V400 = "BURGLAR-TOT ASSLT:  APR"                                        
   V401 = "BURGLAR-TOT ASSLT:  MAY"                                        
   V402 = "BURGLAR-TOT ASSLT:  JUN"                                        
   V403 = "BURGLAR-TOT ASSLT:  JUL"                                        
   V404 = "BURGLAR-TOT ASSLT:  AUG"                                        
   V405 = "BURGLAR-TOT ASSLT:  SEP"                                        
   V406 = "BURGLAR-TOT ASSLT:  OCT"                                        
   V407 = "BURGLAR-TOT ASSLT:  NOV"                                        
   V408 = "BURGLAR-TOT ASSLT:  DEC"                                        
   V409 = "BURGLAR-FIREARM:  JAN"                                          
   V410 = "BURGLAR-FIREARM:  FEB"                                          
   V411 = "BURGLAR-FIREARM:  MAR"                                          
   V412 = "BURGLAR-FIREARM:  APR"                                          
   V413 = "BURGLAR-FIREARM:  MAY"                                          
   V414 = "BURGLAR-FIREARM:  JUN"                                          
   V415 = "BURGLAR-FIREARM:  JUL"                                          
   V416 = "BURGLAR-FIREARM:  AUG"                                          
   V417 = "BURGLAR-FIREARM:  SEP"                                          
   V418 = "BURGLAR-FIREARM:  OCT"                                          
   V419 = "BURGLAR-FIREARM:  NOV"                                          
   V420 = "BURGLAR-FIREARM:  DEC"                                          
   V421 = "BURGLAR-KNIFE:  JAN"                                            
   V422 = "BURGLAR-KNIFE:  FEB"                                            
   V423 = "BURGLAR-KNIFE:  MAR"                                            
   V424 = "BURGLAR-KNIFE:  APR"                                            
   V425 = "BURGLAR-KNIFE:  MAY"                                            
   V426 = "BURGLAR-KNIFE:  JUN"                                            
   V427 = "BURGLAR-KNIFE:  JUL"                                            
   V428 = "BURGLAR-KNIFE:  AUG"                                            
   V429 = "BURGLAR-KNIFE:  SEP"                                            
   V430 = "BURGLAR-KNIFE:  OCT"                                            
   V431 = "BURGLAR-KNIFE:  NOV"                                            
   V432 = "BURGLAR-KNIFE:  DEC"                                            
   V433 = "BURGLAR-OTHER:  JAN"                                            
   V434 = "BURGLAR-OTHER:  FEB"                                            
   V435 = "BURGLAR-OTHER:  MAR"                                            
   V436 = "BURGLAR-OTHER:  APR"                                            
   V437 = "BURGLAR-OTHER:  MAY"                                            
   V438 = "BURGLAR-OTHER:  JUN"                                            
   V439 = "BURGLAR-OTHER:  JUL"                                            
   V440 = "BURGLAR-OTHER:  AUG"                                            
   V441 = "BURGLAR-OTHER:  SEP"                                            
   V442 = "BURGLAR-OTHER:  OCT"                                            
   V443 = "BURGLAR-OTHER:  NOV"                                            
   V444 = "BURGLAR-OTHER:  DEC"                                            
   V445 = "BURGLAR-HANDS FT:  JAN"                                         
   V446 = "BURGLAR-HANDS FT:  FEB"                                         
   V447 = "BURGLAR-HANDS FT:  MAR"                                         
   V448 = "BURGLAR-HANDS FT:  APR"                                         
   V449 = "BURGLAR-HANDS FT:  MAY"                                         
   V450 = "BURGLAR-HANDS FT:  JUN"                                         
   V451 = "BURGLAR-HANDS FT:  JUL"                                         
   V452 = "BURGLAR-HANDS FT:  AUG"                                         
   V453 = "BURGLAR-HANDS FT:  SEP"                                         
   V454 = "BURGLAR-HANDS FT:  OCT"                                         
   V455 = "BURGLAR-HANDS FT:  NOV"                                         
   V456 = "BURGLAR-HANDS FT:  DEC"                                         
   V457 = "BURGLAR-2-MAN VEHICL:JAN"                                       
   V458 = "BURGLAR-2-MAN VEHICL:FEB"                                       
   V459 = "BURGLAR-2-MAN VEHICL:MAR"                                       
   V460 = "BURGLAR-2-MAN VEHICL:APR"                                       
   V461 = "BURGLAR-2-MAN VEHICL:MAY"                                       
   V462 = "BURGLAR-2-MAN VEHICL:JUN"                                       
   V463 = "BURGLAR-2-MAN VEHICL:JUL"                                       
   V464 = "BURGLAR-2-MAN VEHICL:AUG"                                       
   V465 = "BURGLAR-2-MAN VEHICL:SEP"                                       
   V466 = "BURGLAR-2-MAN VEHICL:OCT"                                       
   V467 = "BURGLAR-2-MAN VEHICL:NOV"                                       
   V468 = "BURGLAR-2-MAN VEHICL:DEC"                                       
   V469 = "BURGLAR-1-MAN ALONE: JAN"                                       
   V470 = "BURGLAR-1-MAN ALONE: FEB"                                       
   V471 = "BURGLAR-1-MAN ALONE: MAR"                                       
   V472 = "BURGLAR-1-MAN ALONE: APR"                                       
   V473 = "BURGLAR-1-MAN ALONE: MAY"                                       
   V474 = "BURGLAR-1-MAN ALONE: JUN"                                       
   V475 = "BURGLAR-1-MAN ALONE: JUL"                                       
   V476 = "BURGLAR-1-MAN ALONE: AUG"                                       
   V477 = "BURGLAR-1-MAN ALONE: SEP"                                       
   V478 = "BURGLAR-1-MAN ALONE: OCT"                                       
   V479 = "BURGLAR-1-MAN ALONE: NOV"                                       
   V480 = "BURGLAR-1-MAN ALONE: DEC"                                       
   V481 = "BURGLAR-1-MAN ASST:JAN"                                         
   V482 = "BURGLAR-1-MAN ASST:FEB"                                         
   V483 = "BURGLAR-1-MAN ASST:MAR"                                         
   V484 = "BURGLAR-1-MAN ASST:APR"                                         
   V485 = "BURGLAR-1-MAN ASST:MAY"                                         
   V486 = "BURGLAR-1-MAN ASST:JUN"                                         
   V487 = "BURGLAR-1-MAN ASST:JUL"                                         
   V488 = "BURGLAR-1-MAN ASST:AUG"                                         
   V489 = "BURGLAR-1-MAN ASST:SEP"                                         
   V490 = "BURGLAR-1-MAN ASST:OCT"                                         
   V491 = "BURGLAR-1-MAN ASST:NOV"                                         
   V492 = "BURGLAR-1-MAN ASST:DEC"                                         
   V493 = "BURGLAR-DETECT ALONE:JAN"                                       
   V494 = "BURGLAR-DETECT ALONE:FEB"                                       
   V495 = "BURGLAR-DETECT ALONE:MAR"                                       
   V496 = "BURGLAR-DETECT ALONE:APR"                                       
   V497 = "BURGLAR-DETECT ALONE:MAY"                                       
   V498 = "BURGLAR-DETECT ALONE:JUN"                                       
   V499 = "BURGLAR-DETECT ALONE:JUL"                                       
   V500 = "BURGLAR-DETECT ALONE:AUG"                                       
   V501 = "BURGLAR-DETECT ALONE:SEP"                                       
   V502 = "BURGLAR-DETECT ALONE:OCT"                                       
   V503 = "BURGLAR-DETECT ALONE:NOV"                                       
   V504 = "BURGLAR-DETECT ALONE:DEC"                                       
   V505 = "BURGLAR-DETECT ASST:JAN"                                        
   V506 = "BURGLAR-DETECT ASST:FEB"                                        
   V507 = "BURGLAR-DETECT ASST:MAR"                                        
   V508 = "BURGLAR-DETECT ASST:APR"                                        
   V509 = "BURGLAR-DETECT ASST:MAY"                                        
   V510 = "BURGLAR-DETECT ASST:JUN"                                        
   V511 = "BURGLAR-DETECT ASST:JUL"                                        
   V512 = "BURGLAR-DETECT ASST:AUG"                                        
   V513 = "BURGLAR-DETECT ASST:SEP"                                        
   V514 = "BURGLAR-DETECT ASST:OCT"                                        
   V515 = "BURGLAR-DETECT ASST:NOV"                                        
   V516 = "BURGLAR-DETECT ASST:DEC"                                        
   V517 = "BURGLAR-OTHER ALONE:JAN"                                        
   V518 = "BURGLAR-OTHER ALONE:FEB"                                        
   V519 = "BURGLAR-OTHER ALONE:MAR"                                        
   V520 = "BURGLAR-OTHER ALONE:APR"                                        
   V521 = "BURGLAR-OTHER ALONE:MAY"                                        
   V522 = "BURGLAR-OTHER ALONE:JUN"                                        
   V523 = "BURGLAR-OTHER ALONE:JUL"                                        
   V524 = "BURGLAR-OTHER ALONE:AUG"                                        
   V525 = "BURGLAR-OTHER ALONE:SEP"                                        
   V526 = "BURGLAR-OTHER ALONE:OCT"                                        
   V527 = "BURGLAR-OTHER ALONE:NOV"                                        
   V528 = "BURGLAR-OTHER ALONE:DEC"                                        
   V529 = "BURGLAR-OTHER ASSIST:JAN"                                       
   V530 = "BURGLAR-OTHER ASSIST:FEB"                                       
   V531 = "BURGLAR-OTHER ASSIST:MAR"                                       
   V532 = "BURGLAR-OTHER ASSIST:APR"                                       
   V533 = "BURGLAR-OTHER ASSIST:MAY"                                       
   V534 = "BURGLAR-OTHER ASSIST:JUN"                                       
   V535 = "BURGLAR-OTHER ASSIST:JUL"                                       
   V536 = "BURGLAR-OTHER ASSIST:AUG"                                       
   V537 = "BURGLAR-OTHER ASSIST:SEP"                                       
   V538 = "BURGLAR-OTHER ASSIST:OCT"                                       
   V539 = "BURGLAR-OTHER ASSIST:NOV"                                       
   V540 = "BURGLAR-OTHER ASSIST:DEC"                                       
   V541 = "BURGLAR-ASSLT CLEAR:JAN"                                        
   V542 = "BURGLAR-ASSLT CLEAR:FEB"                                        
   V543 = "BURGLAR-ASSLT CLEAR:MAR"                                        
   V544 = "BURGLAR-ASSLT CLEAR:APR"                                        
   V545 = "BURGLAR-ASSLT CLEAR:MAY"                                        
   V546 = "BURGLAR-ASSLT CLEAR:JUN"                                        
   V547 = "BURGLAR-ASSLT CLEAR:JUL"                                        
   V548 = "BURGLAR-ASSLT CLEAR:AUG"                                        
   V549 = "BURGLAR-ASSLT CLEAR:SEP"                                        
   V550 = "BURGLAR-ASSLT CLEAR:OCT"                                        
   V551 = "BURGLAR-ASSLT CLEAR:NOV"                                        
   V552 = "BURGLAR-ASSLT CLEAR:DEC"                                        
   V553 = "ROBBERY-TOTAL ASSLT:JAN"                                        
   V554 = "ROBBERY-TOTAL ASSLT:FEB"                                        
   V555 = "ROBBERY-TOTAL ASSLT:MAR"                                        
   V556 = "ROBBERY-TOTAL ASSLT:APR"                                        
   V557 = "ROBBERY-TOTAL ASSLT:MAY"                                        
   V558 = "ROBBERY-TOTAL ASSLT:JUN"                                        
   V559 = "ROBBERY-TOTAL ASSLT:JUL"                                        
   V560 = "ROBBERY-TOTAL ASSLT:AUG"                                        
   V561 = "ROBBERY-TOTAL ASSLT:SEP"                                        
   V562 = "ROBBERY-TOTAL ASSLT:OCT"                                        
   V563 = "ROBBERY-TOTAL ASSLT:NOV"                                        
   V564 = "ROBBERY-TOTAL ASSLT:DEC"                                        
   V565 = "ROBBERY-FIREARM:JAN"                                            
   V566 = "ROBBERY-FIREARM:FEB"                                            
   V567 = "ROBBERY-FIREARM:MAR"                                            
   V568 = "ROBBERY-FIREARM:APR"                                            
   V569 = "ROBBERY-FIREARM:MAY"                                            
   V570 = "ROBBERY-FIREARM:JUN"                                            
   V571 = "ROBBERY-FIREARM:JUL"                                            
   V572 = "ROBBERY-FIREARM:AUG"                                            
   V573 = "ROBBERY-FIREARM:SEP"                                            
   V574 = "ROBBERY-FIREARM:OCT"                                            
   V575 = "ROBBERY-FIREARM:NOV"                                            
   V576 = "ROBBERY-FIREARM:DEC"                                            
   V577 = "ROBBERY-KNIFE:JAN"                                              
   V578 = "ROBBERY-KNIFE:FEB"                                              
   V579 = "ROBBERY-KNIFE:MAR"                                              
   V580 = "ROBBERY-KNIFE:APR"                                              
   V581 = "ROBBERY-KNIFE:MAY"                                              
   V582 = "ROBBERY-KNIFE:JUN"                                              
   V583 = "ROBBERY-KNIFE:JUL"                                              
   V584 = "ROBBERY-KNIFE:AUG"                                              
   V585 = "ROBBERY-KNIFE:SEP"                                              
   V586 = "ROBBERY-KNIFE:OCT"                                              
   V587 = "ROBBERY-KNIFE:NOV"                                              
   V588 = "ROBBERY-KNIFE:DEC"                                              
   V589 = "ROBBERY-OTHER:JAN"                                              
   V590 = "ROBBERY-OTHER:FEB"                                              
   V591 = "ROBBERY-OTHER:MAR"                                              
   V592 = "ROBBERY-OTHER:APR"                                              
   V593 = "ROBBERY-OTHER:MAY"                                              
   V594 = "ROBBERY-OTHER:JUN"                                              
   V595 = "ROBBERY-OTHER:JUL"                                              
   V596 = "ROBBERY-OTHER:AUG"                                              
   V597 = "ROBBERY-OTHER:SEP"                                              
   V598 = "ROBBERY-OTHER:OCT"                                              
   V599 = "ROBBERY-OTHER:NOV"                                              
   V600 = "ROBBERY-OTHER:DEC"                                              
   V601 = "ROBBERY-HANDS FEET:JAN"                                         
   V602 = "ROBBERY-HANDS FEET:FEB"                                         
   V603 = "ROBBERY-HANDS FEET:MAR"                                         
   V604 = "ROBBERY-HANDS FEET:APR"                                         
   V605 = "ROBBERY-HANDS FEET:MAY"                                         
   V606 = "ROBBERY-HANDS FEET:JUN"                                         
   V607 = "ROBBERY-HANDS FEET:JUL"                                         
   V608 = "ROBBERY-HANDS FEET:AUG"                                         
   V609 = "ROBBERY-HANDS FEET:SEP"                                         
   V610 = "ROBBERY-HANDS FEET:OCT"                                         
   V611 = "ROBBERY-HANDS FEET:NOV"                                         
   V612 = "ROBBERY-HANDS FEET:DEC"                                         
   V613 = "ROBBERY-2-MAN VEHIC:JAN"                                        
   V614 = "ROBBERY-2-MAN VEHIC:FEB"                                        
   V615 = "ROBBERY-2-MAN VEHIC:MAR"                                        
   V616 = "ROBBERY-2-MAN VEHIC:APR"                                        
   V617 = "ROBBERY-2-MAN VEHIC:MAY"                                        
   V618 = "ROBBERY-2-MAN VEHIC:JUN"                                        
   V619 = "ROBBERY-2-MAN VEHIC:JUL"                                        
   V620 = "ROBBERY-2-MAN VEHIC:AUG"                                        
   V621 = "ROBBERY-2-MAN VEHIC:SEP"                                        
   V622 = "ROBBERY-2-MAN VEHIC:OCT"                                        
   V623 = "ROBBERY-2-MAN VEHIC:NOV"                                        
   V624 = "ROBBERY-2-MAN VEHIC:DEC"                                        
   V625 = "ROBBERY-1-MAN ALONE:JAN"                                        
   V626 = "ROBBERY-1-MAN ALONE:FEB"                                        
   V627 = "ROBBERY-1-MAN ALONE:MAR"                                        
   V628 = "ROBBERY-1-MAN ALONE:APR"                                        
   V629 = "ROBBERY-1-MAN ALONE:MAY"                                        
   V630 = "ROBBERY-1-MAN ALONE:JUN"                                        
   V631 = "ROBBERY-1-MAN ALONE:JUL"                                        
   V632 = "ROBBERY-1-MAN ALONE:AUG"                                        
   V633 = "ROBBERY-1-MAN ALONE:SEP"                                        
   V634 = "ROBBERY-1-MAN ALONE:OCT"                                        
   V635 = "ROBBERY-1-MAN ALONE:NOV"                                        
   V636 = "ROBBERY-1-MAN ALONE:DEC"                                        
   V637 = "ROBBERY-1-MAN ASSIST:JAN"                                       
   V638 = "ROBBERY-1-MAN ASSIST:FEB"                                       
   V639 = "ROBBERY-1-MAN ASSIST:MAR"                                       
   V640 = "ROBBERY-1-MAN ASSIST:APR"                                       
   V641 = "ROBBERY-1-MAN ASSIST:MAY"                                       
   V642 = "ROBBERY-1-MAN ASSIST:JUN"                                       
   V643 = "ROBBERY-1-MAN ASSIST:JUL"                                       
   V644 = "ROBBERY-1-MAN ASSIST:AUG"                                       
   V645 = "ROBBERY-1-MAN ASSIST:SEP"                                       
   V646 = "ROBBERY-1-MAN ASSIST:OCT"                                       
   V647 = "ROBBERY-1-MAN ASSIST:NOV"                                       
   V648 = "ROBBERY-1-MAN ASSIST:DEC"                                       
   V649 = "ROBBERY-DETECT ALONE:JAN"                                       
   V650 = "ROBBERY-DETECT ALONE:FEB"                                       
   V651 = "ROBBERY-DETECT ALONE:MAR"                                       
   V652 = "ROBBERY-DETECT ALONE:APR"                                       
   V653 = "ROBBERY-DETECT ALONE:MAY"                                       
   V654 = "ROBBERY-DETECT ALONE:JUN"                                       
   V655 = "ROBBERY-DETECT ALONE:JUL"                                       
   V656 = "ROBBERY-DETECT ALONE:AUG"                                       
   V657 = "ROBBERY-DETECT ALONE:SEP"                                       
   V658 = "ROBBERY-DETECT ALONE:OCT"                                       
   V659 = "ROBBERY-DETECT ALONE:NOV"                                       
   V660 = "ROBBERY-DETECT ALONE:DEC"                                       
   V661 = "ROBBERY-DETECT ASST:JAN"                                        
   V662 = "ROBBERY-DETECT ASST:FEB"                                        
   V663 = "ROBBERY-DETECT ASST:MAR"                                        
   V664 = "ROBBERY-DETECT ASST:APR"                                        
   V665 = "ROBBERY-DETECT ASST:MAY"                                        
   V666 = "ROBBERY-DETECT ASST:JUN"                                        
   V667 = "ROBBERY-DETECT ASST:JUL"                                        
   V668 = "ROBBERY-DETECT ASST:AUG"                                        
   V669 = "ROBBERY-DETECT ASST:SEP"                                        
   V670 = "ROBBERY-DETECT ASST:OCT"                                        
   V671 = "ROBBERY-DETECT ASST:NOV"                                        
   V672 = "ROBBERY-DETECT ASST:DEC"                                        
   V673 = "ROBBERY-OTHER ALONE:JAN"                                        
   V674 = "ROBBERY-OTHER ALONE:FEB"                                        
   V675 = "ROBBERY-OTHER ALONE:MAR"                                        
   V676 = "ROBBERY-OTHER ALONE:APR"                                        
   V677 = "ROBBERY-OTHER ALONE:MAY"                                        
   V678 = "ROBBERY-OTHER ALONE:JUN"                                        
   V679 = "ROBBERY-OTHER ALONE:JUL"                                        
   V680 = "ROBBERY-OTHER ALONE:AUG"                                        
   V681 = "ROBBERY-OTHER ALONE:SEP"                                        
   V682 = "ROBBERY-OTHER ALONE:OCT"                                        
   V683 = "ROBBERY-OTHER ALONE:NOV"                                        
   V684 = "ROBBERY-OTHER ALONE:DEC"                                        
   V685 = "ROBBERY-OTHER ASSIST:JAN"                                       
   V686 = "ROBBERY-OTHER ASSIST:FEB"                                       
   V687 = "ROBBERY-OTHER ASSIST:MAR"                                       
   V688 = "ROBBERY-OTHER ASSIST:APR"                                       
   V689 = "ROBBERY-OTHER ASSIST:MAY"                                       
   V690 = "ROBBERY-OTHER ASSIST:JUN"                                       
   V691 = "ROBBERY-OTHER ASSIST:JUL"                                       
   V692 = "ROBBERY-OTHER ASSIST:AUG"                                       
   V693 = "ROBBERY-OTHER ASSIST:SEP"                                       
   V694 = "ROBBERY-OTHER ASSIST:OCT"                                       
   V695 = "ROBBERY-OTHER ASSIST:NOV"                                       
   V696 = "ROBBERY-OTHER ASSIST:DEC"                                       
   V697 = "ROBBERY-ASSLT CLEAR:JAN"                                        
   V698 = "ROBBERY-ASSLT CLEAR:FEB"                                        
   V699 = "ROBBERY-ASSLT CLEAR:MAR"                                        
   V700 = "ROBBERY-ASSLT CLEAR:APR"                                        
   V701 = "ROBBERY-ASSLT CLEAR:MAY"                                        
   V702 = "ROBBERY-ASSLT CLEAR:JUN"                                        
   V703 = "ROBBERY-ASSLT CLEAR:JUL"                                        
   V704 = "ROBBERY-ASSLT CLEAR:AUG"                                        
   V705 = "ROBBERY-ASSLT CLEAR:SEP"                                        
   V706 = "ROBBERY-ASSLT CLEAR:OCT"                                        
   V707 = "ROBBERY-ASSLT CLEAR:NOV"                                        
   V708 = "ROBBERY-ASSLT CLEAR:DEC"                                        
   V709 = "ATTEMPT-TOTAL ASSLT:JAN"                                        
   V710 = "ATTEMPT-TOTAL ASSLT:FEB"                                        
   V711 = "ATTEMPT-TOTAL ASSLT:MAR"                                        
   V712 = "ATTEMPT-TOTAL ASSLT:APR"                                        
   V713 = "ATTEMPT-TOTAL ASSLT:MAY"                                        
   V714 = "ATTEMPT-TOTAL ASSLT:JUN"                                        
   V715 = "ATTEMPT-TOTAL ASSLT:JUL"                                        
   V716 = "ATTEMPT-TOTAL ASSLT:AUG"                                        
   V717 = "ATTEMPT-TOTAL ASSLT:SEP"                                        
   V718 = "ATTEMPT-TOTAL ASSLT:OCT"                                        
   V719 = "ATTEMPT-TOTAL ASSLT:NOV"                                        
   V720 = "ATTEMPT-TOTAL ASSLT:DEC"                                        
   V721 = "ATTEMPT-FIREARM:JAN"                                            
   V722 = "ATTEMPT-FIREARM:FEB"                                            
   V723 = "ATTEMPT-FIREARM:MAR"                                            
   V724 = "ATTEMPT-FIREARM:APR"                                            
   V725 = "ATTEMPT-FIREARM:MAY"                                            
   V726 = "ATTEMPT-FIREARM:JUN"                                            
   V727 = "ATTEMPT-FIREARM:JUL"                                            
   V728 = "ATTEMPT-FIREARM:AUG"                                            
   V729 = "ATTEMPT-FIREARM:SEP"                                            
   V730 = "ATTEMPT-FIREARM:OCT"                                            
   V731 = "ATTEMPT-FIREARM:NOV"                                            
   V732 = "ATTEMPT-FIREARM:DEC"                                            
   V733 = "ATTEMPT-KNIFE:JAN"                                              
   V734 = "ATTEMPT-KNIFE:FEB"                                              
   V735 = "ATTEMPT-KNIFE:MAR"                                              
   V736 = "ATTEMPT-KNIFE:APR"                                              
   V737 = "ATTEMPT-KNIFE:MAY"                                              
   V738 = "ATTEMPT-KNIFE:JUN"                                              
   V739 = "ATTEMPT-KNIFE:JUL"                                              
   V740 = "ATTEMPT-KNIFE:AUG"                                              
   V741 = "ATTEMPT-KNIFE:SEP"                                              
   V742 = "ATTEMPT-KNIFE:OCT"                                              
   V743 = "ATTEMPT-KNIFE:NOV"                                              
   V744 = "ATTEMPT-KNIFE:DEC"                                              
   V745 = "ATTEMPT-OTHER:JAN"                                              
   V746 = "ATTEMPT-OTHER:FEB"                                              
   V747 = "ATTEMPT-OTHER:MAR"                                              
   V748 = "ATTEMPT-OTHER:APR"                                              
   V749 = "ATTEMPT-OTHER:MAY"                                              
   V750 = "ATTEMPT-OTHER:JUN"                                              
   V751 = "ATTEMPT-OTHER:JUL"                                              
   V752 = "ATTEMPT-OTHER:AUG"                                              
   V753 = "ATTEMPT-OTHER:SEP"                                              
   V754 = "ATTEMPT-OTHER:OCT"                                              
   V755 = "ATTEMPT-OTHER:NOV"                                              
   V756 = "ATTEMPT-OTHER:DEC"                                              
   V757 = "ATTEMPT-HANDS FEET:JAN"                                         
   V758 = "ATTEMPT-HANDS FEET:FEB"                                         
   V759 = "ATTEMPT-HANDS FEET:MAR"                                         
   V760 = "ATTEMPT-HANDS FEET:APR"                                         
   V761 = "ATTEMPT-HANDS FEET:MAY"                                         
   V762 = "ATTEMPT-HANDS FEET:JUN"                                         
   V763 = "ATTEMPT-HANDS FEET:JUL"                                         
   V764 = "ATTEMPT-HANDS FEET:AUG"                                         
   V765 = "ATTEMPT-HANDS FEET:SEP"                                         
   V766 = "ATTEMPT-HANDS FEET:OCT"                                         
   V767 = "ATTEMPT-HANDS FEET:NOV"                                         
   V768 = "ATTEMPT-HANDS FEET:DEC"                                         
   V769 = "ATTEMPT-2-MAN VEHIC:JAN"                                        
   V770 = "ATTEMPT-2-MAN VEHIC:FEB"                                        
   V771 = "ATTEMPT-2-MAN VEHIC:MAR"                                        
   V772 = "ATTEMPT-2-MAN VEHIC:APR"                                        
   V773 = "ATTEMPT-2-MAN VEHIC:MAY"                                        
   V774 = "ATTEMPT-2-MAN VEHIC:JUN"                                        
   V775 = "ATTEMPT-2-MAN VEHIC:JUL"                                        
   V776 = "ATTEMPT-2-MAN VEHIC:AUG"                                        
   V777 = "ATTEMPT-2-MAN VEHIC:SEP"                                        
   V778 = "ATTEMPT-2-MAN VEHIC:OCT"                                        
   V779 = "ATTEMPT-2-MAN VEHIC:NOV"                                        
   V780 = "ATTEMPT-2-MAN VEHIC:DEC"                                        
   V781 = "ATTEMPT-1-MAN ALONE:JAN"                                        
   V782 = "ATTEMPT-1-MAN ALONE:FEB"                                        
   V783 = "ATTEMPT-1-MAN ALONE:MAR"                                        
   V784 = "ATTEMPT-1-MAN ALONE:APR"                                        
   V785 = "ATTEMPT-1-MAN ALONE:MAY"                                        
   V786 = "ATTEMPT-1-MAN ALONE:JUN"                                        
   V787 = "ATTEMPT-1-MAN ALONE:JUL"                                        
   V788 = "ATTEMPT-1-MAN ALONE:AUG"                                        
   V789 = "ATTEMPT-1-MAN ALONE:SEP"                                        
   V790 = "ATTEMPT-1-MAN ALONE:OCT"                                        
   V791 = "ATTEMPT-1-MAN ALONE:NOV"                                        
   V792 = "ATTEMPT-1-MAN ALONE:DEC"                                        
   V793 = "ATTEMPT-1-MAN ASSIST:JAN"                                       
   V794 = "ATTEMPT-1-MAN ASSIST:FEB"                                       
   V795 = "ATTEMPT-1-MAN ASSIST:MAR"                                       
   V796 = "ATTEMPT-1-MAN ASSIST:APR"                                       
   V797 = "ATTEMPT-1-MAN ASSIST:MAY"                                       
   V798 = "ATTEMPT-1-MAN ASSIST:JUN"                                       
   V799 = "ATTEMPT-1-MAN ASSIST:JUL"                                       
   V800 = "ATTEMPT-1-MAN ASSIST:AUG"                                       
   V801 = "ATTEMPT-1-MAN ASSIST:SEP"                                       
   V802 = "ATTEMPT-1-MAN ASSIST:OCT"                                       
   V803 = "ATTEMPT-1-MAN ASSIST:NOV"                                       
   V804 = "ATTEMPT-1-MAN ASSIST:DEC"                                       
   V805 = "ATTEMPT-DETECT ALONE:JAN"                                       
   V806 = "ATTEMPT-DETECT ALONE:FEB"                                       
   V807 = "ATTEMPT-DETECT ALONE:MAR"                                       
   V808 = "ATTEMPT-DETECT ALONE:APR"                                       
   V809 = "ATTEMPT-DETECT ALONE:MAY"                                       
   V810 = "ATTEMPT-DETECT ALONE:JUN"                                       
   V811 = "ATTEMPT-DETECT ALONE:JUL"                                       
   V812 = "ATTEMPT-DETECT ALONE:AUG"                                       
   V813 = "ATTEMPT-DETECT ALONE:SEP"                                       
   V814 = "ATTEMPT-DETECT ALONE:OCT"                                       
   V815 = "ATTEMPT-DETECT ALONE:NOV"                                       
   V816 = "ATTEMPT-DETECT ALONE:DEC"                                       
   V817 = "ATTEMPT-DETECT ASST:JAN"                                        
   V818 = "ATTEMPT-DETECT ASST:FEB"                                        
   V819 = "ATTEMPT-DETECT ASST:MAR"                                        
   V820 = "ATTEMPT-DETECT ASST:APR"                                        
   V821 = "ATTEMPT-DETECT ASST:MAY"                                        
   V822 = "ATTEMPT-DETECT ASST:JUN"                                        
   V823 = "ATTEMPT-DETECT ASST:JUL"                                        
   V824 = "ATTEMPT-DETECT ASST:AUG"                                        
   V825 = "ATTEMPT-DETECT ASST:SEP"                                        
   V826 = "ATTEMPT-DETECT ASST:OCT"                                        
   V827 = "ATTEMPT-DETECT ASST:NOV"                                        
   V828 = "ATTEMPT-DETECT ASST:DEC"                                        
   V829 = "ATTEMPT-OTHER ALONE:JAN"                                        
   V830 = "ATTEMPT-OTHER ALONE:FEB"                                        
   V831 = "ATTEMPT-OTHER ALONE:MAR"                                        
   V832 = "ATTEMPT-OTHER ALONE:APR"                                        
   V833 = "ATTEMPT-OTHER ALONE:MAY"                                        
   V834 = "ATTEMPT-OTHER ALONE:JUN"                                        
   V835 = "ATTEMPT-OTHER ALONE:JUL"                                        
   V836 = "ATTEMPT-OTHER ALONE:AUG"                                        
   V837 = "ATTEMPT-OTHER ALONE:SEP"                                        
   V838 = "ATTEMPT-OTHER ALONE:OCT"                                        
   V839 = "ATTEMPT-OTHER ALONE:NOV"                                        
   V840 = "ATTEMPT-OTHER ALONE:DEC"                                        
   V841 = "ATTEMPT-OTHER ASSIST:JAN"                                       
   V842 = "ATTEMPT-OTHER ASSIST:FEB"                                       
   V843 = "ATTEMPT-OTHER ASSIST:MAR"                                       
   V844 = "ATTEMPT-OTHER ASSIST:APR"                                       
   V845 = "ATTEMPT-OTHER ASSIST:MAY"                                       
   V846 = "ATTEMPT-OTHER ASSIST:JUN"                                       
   V847 = "ATTEMPT-OTHER ASSIST:JUL"                                       
   V848 = "ATTEMPT-OTHER ASSIST:AUG"                                       
   V849 = "ATTEMPT-OTHER ASSIST:SEP"                                       
   V850 = "ATTEMPT-OTHER ASSIST:OCT"                                       
   V851 = "ATTEMPT-OTHER ASSIST:NOV"                                       
   V852 = "ATTEMPT-OTHER ASSIST:DEC"                                       
   V853 = "ATTEMPT-ASSLTS CLEAR:JAN"                                       
   V854 = "ATTEMPT-ASSLTS CLEAR:FEB"                                       
   V855 = "ATTEMPT-ASSLTS CLEAR:MAR"                                       
   V856 = "ATTEMPT-ASSLTS CLEAR:APR"                                       
   V857 = "ATTEMPT-ASSLTS CLEAR:MAY"                                       
   V858 = "ATTEMPT-ASSLTS CLEAR:JUN"                                       
   V859 = "ATTEMPT-ASSLTS CLEAR:JUL"                                       
   V860 = "ATTEMPT-ASSLTS CLEAR:AUG"                                       
   V861 = "ATTEMPT-ASSLTS CLEAR:SEP"                                       
   V862 = "ATTEMPT-ASSLTS CLEAR:OCT"                                       
   V863 = "ATTEMPT-ASSLTS CLEAR:NOV"                                       
   V864 = "ATTEMPT-ASSLTS CLEAR:DEC"                                       
   V865 = "ATTEMPT-TOTAL ASSLT:JAN"                                        
   V866 = "ATTEMPT-TOTAL ASSLT:FEB"                                        
   V867 = "CIV DIS-TOTAL ASSLT:MAR"                                        
   V868 = "CIV DIS-TOTAL ASSLT:APR"                                        
   V869 = "CIV DIS-TOTAL ASSLT:MAY"                                        
   V870 = "CIV DIS-TOTAL ASSLT:JUN"                                        
   V871 = "CIV DIS-TOTAL ASSLT:JUL"                                        
   V872 = "CIV DIS-TOTAL ASSLT:AUG"                                        
   V873 = "CIV DIS-TOTAL ASSLT:SEP"                                        
   V874 = "CIV DIS-TOTAL ASSLT:OCT"                                        
   V875 = "CIV DIS-TOTAL ASSLT:NOV"                                        
   V876 = "CIV DIS-TOTAL ASSLT:DEC"                                        
   V877 = "CIV DIS-FIREARM:JAN"                                            
   V878 = "CIV DIS-FIREARM:FEB"                                            
   V879 = "CIV DIS-FIREARM:MAR"                                            
   V880 = "CIV DIS-FIREARM:APR"                                            
   V881 = "CIV DIS-FIREARM:MAY"                                            
   V882 = "CIV DIS-FIREARM:JUN"                                            
   V883 = "CIV DIS-FIREARM:JUL"                                            
   V884 = "CIV DIS-FIREARM:AUG"                                            
   V885 = "CIV DIS-FIREARM:SEP"                                            
   V886 = "CIV DIS-FIREARM:OCT"                                            
   V887 = "CIV DIS-FIREARM:NOV"                                            
   V888 = "CIV DIS-FIREARM:DEC"                                            
   V889 = "CIV DIS-KNIFE:JAN"                                              
   V890 = "CIV DIS-KNIFE:FEB"                                              
   V891 = "CIV DIS-KNIFE:MAR"                                              
   V892 = "CIV DIS-KNIFE:APR"                                              
   V893 = "CIV DIS-KNIFE:MAY"                                              
   V894 = "CIV DIS-KNIFE:JUN"                                              
   V895 = "CIV DIS-KNIFE:JUL"                                              
   V896 = "CIV DIS-KNIFE:AUG"                                              
   V897 = "CIV DIS-KNIFE:SEP"                                              
   V898 = "CIV DIS-KNIFE:OCT"                                              
   V899 = "CIV DIS-KNIFE:NOV"                                              
   V900 = "CIV DIS-KNIFE:DEC"                                              
   V901 = "CIV DIS-OTHER:JAN"                                              
   V902 = "CIV DIS-OTHER:FEB"                                              
   V903 = "CIV DIS-OTHER:MAR"                                              
   V904 = "CIV DIS-OTHER:APR"                                              
   V905 = "CIV DIS-OTHER:MAY"                                              
   V906 = "CIV DIS-OTHER:JUN"                                              
   V907 = "CIV DIS-OTHER:JUL"                                              
   V908 = "CIV DIS-OTHER:AUG"                                              
   V909 = "CIV DIS-OTHER:SEP"                                              
   V910 = "CIV DIS-OTHER:OCT"                                              
   V911 = "CIV DIS-OTHER:NOV"                                              
   V912 = "CIV DIS-OTHER:DEC"                                              
   V913 = "CIV DIS-HANDS FEET:JAN"                                         
   V914 = "CIV DIS-HANDS FEET:FEB"                                         
   V915 = "CIV DIS-HANDS FEET:MAR"                                         
   V916 = "CIV DIS-HANDS FEET:APR"                                         
   V917 = "CIV DIS-HANDS FEET:MAY"                                         
   V918 = "CIV DIS-HANDS FEET:JUN"                                         
   V919 = "CIV DIS-HANDS FEET:JUL"                                         
   V920 = "CIV DIS-HANDS FEET:AUG"                                         
   V921 = "CIV DIS-HANDS FEET:SEP"                                         
   V922 = "CIV DIS-HANDS FEET:OCT"                                         
   V923 = "CIV DIS-HANDS FEET:NOV"                                         
   V924 = "CIV DIS-HANDS FEET:DEC"                                         
   V925 = "CIV DIS-2-MAN VEHIC:JAN"                                        
   V926 = "CIV DIS-2-MAN VEHIC:FEB"                                        
   V927 = "CIV DIS-2-MAN VEHIC:MAR"                                        
   V928 = "CIV DIS-2-MAN VEHIC:APR"                                        
   V929 = "CIV DIS-2-MAN VEHIC:MAY"                                        
   V930 = "CIV DIS-2-MAN VEHIC:JUN"                                        
   V931 = "CIV DIS-2-MAN VEHIC:JUL"                                        
   V932 = "CIV DIS-2-MAN VEHIC:AUG"                                        
   V933 = "CIV DIS-2-MAN VEHIC:SEP"                                        
   V934 = "CIV DIS-2-MAN VEHIC:OCT"                                        
   V935 = "CIV DIS-2-MAN VEHIC:NOV"                                        
   V936 = "CIV DIS-2-MAN VEHIC:DEC"                                        
   V937 = "CIV DIS-1-MAN ALONE:JAN"                                        
   V938 = "CIV DIS-1-MAN ALONE:FEB"                                        
   V939 = "CIV DIS-1-MAN ALONE:MAR"                                        
   V940 = "CIV DIS-1-MAN ALONE:APR"                                        
   V941 = "CIV DIS-1-MAN ALONE:MAY"                                        
   V942 = "CIV DIS-1-MAN ALONE:JUN"                                        
   V943 = "CIV DIS-1-MAN ALONE:JUL"                                        
   V944 = "CIV DIS-1-MAN ALONE:AUG"                                        
   V945 = "CIV DIS-1-MAN ALONE:SEP"                                        
   V946 = "CIV DIS-1-MAN ALONE:OCT"                                        
   V947 = "CIV DIS-1-MAN ALONE:NOV"                                        
   V948 = "CIV DIS-1-MAN ALONE:DEC"                                        
   V949 = "CIV DIS-1-MAN ASSIST:JAN"                                       
   V950 = "CIV DIS-1-MAN ASSIST:FEB"                                       
   V951 = "CIV DIS-1-MAN ASSIST:MAR"                                       
   V952 = "CIV DIS-1-MAN ASSIST:APR"                                       
   V953 = "CIV DIS-1-MAN ASSIST:MAY"                                       
   V954 = "CIV DIS-1-MAN ASSIST:JUN"                                       
   V955 = "CIV DIS-1-MAN ASSIST:JUL"                                       
   V956 = "CIV DIS-1-MAN ASSIST:AUG"                                       
   V957 = "CIV DIS-1-MAN ASSIST:SEP"                                       
   V958 = "CIV DIS-1-MAN ASSIST:OCT"                                       
   V959 = "CIV DIS-1-MAN ASSIST:NOV"                                       
   V960 = "CIV DIS-1-MAN ASSIST:DEC"                                       
   V961 = "CIV DIS-DETECT ALONE:JAN"                                       
   V962 = "CIV DIS-DETECT ALONE:FEB"                                       
   V963 = "CIV DIS-DETECT ALONE:MAR"                                       
   V964 = "CIV DIS-DETECT ALONE:APR"                                       
   V965 = "CIV DIS-DETECT ALONE:MAY"                                       
   V966 = "CIV DIS-DETECT ALONE:JUN"                                       
   V967 = "CIV DIS-DETECT ALONE:JUL"                                       
   V968 = "CIV DIS-DETECT ALONE:AUG"                                       
   V969 = "CIV DIS-DETECT ALONE:SEP"                                       
   V970 = "CIV DIS-DETECT ALONE:OCT"                                       
   V971 = "CIV DIS-DETECT ALONE:NOV"                                       
   V972 = "CIV DIS-DETECT ALONE:DEC"                                       
   V973 = "CIV DIS-DETECT ASST:JAN"                                        
   V974 = "CIV DIS-DETECT ASST:FEB"                                        
   V975 = "CIV DIS-DETECT ASST:MAR"                                        
   V976 = "CIV DIS-DETECT ASST:APR"                                        
   V977 = "CIV DIS-DETECT ASST:MAY"                                        
   V978 = "CIV DIS-DETECT ASST:JUN"                                        
   V979 = "CIV DIS-DETECT ASST:JUL"                                        
   V980 = "CIV DIS-DETECT ASST:AUG"                                        
   V981 = "CIV DIS-DETECT ASST:SEP"                                        
   V982 = "CIV DIS-DETECT ASST:OCT"                                        
   V983 = "CIV DIS-DETECT ASST:NOV"                                        
   V984 = "CIV DIS-DETECT ASST:DEC"                                        
   V985 = "CIV DIS-OTHER ALONE:JAN"                                        
   V986 = "CIV DIS-OTHER ALONE:FEB"                                        
   V987 = "CIV DIS-OTHER ALONE:MAR"                                        
   V988 = "CIV DIS-OTHER ALONE:APR"                                        
   V989 = "CIV DIS-OTHER ALONE:MAY"                                        
   V990 = "CIV DIS-OTHER ALONE:JUN"                                        
   V991 = "CIV DIS-OTHER ALONE:JUL"                                        
   V992 = "CIV DIS-OTHER ALONE:AUG"                                        
   V993 = "CIV DIS-OTHER ALONE:SEP"                                        
   V994 = "CIV DIS-OTHER ALONE:OCT"                                        
   V995 = "CIV DIS-OTHER ALONE:NOV"                                        
   V996 = "CIV DIS-OTHER ALONE:DEC"                                        
   V997 = "CIV DIS-OTHER ASSIST:JAN"                                       
   V998 = "CIV DIS-OTHER ASSIST:FEB"                                       
   V999 = "CIV DIS-OTHER ASSIST:MAR"                                       
   V1000 = "CIV DIS-OTHER ASSIST:APR"                                      
   V1001 = "CIV DIS-OTHER ASSIST:MAY"                                      
   V1002 = "CIV DIS-OTHER ASSIST:JUN"                                      
   V1003 = "CIV DIS-OTHER ASSIST:JUL"                                      
   V1004 = "CIV DIS-OTHER ASSIST:AUG"                                      
   V1005 = "CIV DIS-OTHER ASSIST:SEP"                                      
   V1006 = "CIV DIS-OTHER ASSIST:OCT"                                      
   V1007 = "CIV DIS-OTHER ASSIST:NOV"                                      
   V1008 = "CIV DIS-OTHER ASSIST:DEC"                                      
   V1009 = "CIV DIS-ASSLTS CLEAR:JAN"                                      
   V1010 = "CIV DIS-ASSLTS CLEAR:FEB"                                      
   V1011 = "CIV DIS-ASSLTS CLEAR:MAR"                                      
   V1012 = "CIV DIS-ASSLTS CLEAR:APR"                                      
   V1013 = "CIV DIS-ASSLTS CLEAR:MAY"                                      
   V1014 = "CIV DIS-ASSLTS CLEAR:JUN"                                      
   V1015 = "CIV DIS-ASSLTS CLEAR:JUL"                                      
   V1016 = "CIV DIS-ASSLTS CLEAR:AUG"                                      
   V1017 = "CIV DIS-ASSLTS CLEAR:SEP"                                      
   V1018 = "CIV DIS-ASSLTS CLEAR:OCT"                                      
   V1019 = "CIV DIS-ASSLTS CLEAR:NOV"                                      
   V1020 = "CIV DIS-ASSLTS CLEAR:DEC"                                      
   V1021 = "CUSTODY-TOTAL ASSLT:JAN"                                       
   V1022 = "CUSTODY-TOTAL ASSLT:FEB"                                       
   V1023 = "CUSTODY-TOTAL ASSLT:MAR"                                       
   V1024 = "CUSTODY-TOTAL ASSLT:APR"                                       
   V1025 = "CUSTODY-TOTAL ASSLT:MAY"                                       
   V1026 = "CUSTODY-TOTAL ASSLT:JUN"                                       
   V1027 = "CUSTODY-TOTAL ASSLT:JUL"                                       
   V1028 = "CUSTODY-TOTAL ASSLT:AUG"                                       
   V1029 = "CUSTODY-TOTAL ASSLT:SEP"                                       
   V1030 = "CUSTODY-TOTAL ASSLT:OCT"                                       
   V1031 = "CUSTODY-TOTAL ASSLT:NOV"                                       
   V1032 = "CUSTODY-TOTAL ASSLT:DEC"                                       
   V1033 = "CUSTODY-FIREARM:JAN"                                           
   V1034 = "CUSTODY-FIREARM:FEB"                                           
   V1035 = "CUSTODY-FIREARM:MAR"                                           
   V1036 = "CUSTODY-FIREARM:APR"                                           
   V1037 = "CUSTODY-FIREARM:MAY"                                           
   V1038 = "CUSTODY-FIREARM:JUN"                                           
   V1039 = "CUSTODY-FIREARM:JUL"                                           
   V1040 = "CUSTODY-FIREARM:AUG"                                           
   V1041 = "CUSTODY-FIREARM:SEP"                                           
   V1042 = "CUSTODY-FIREARM:OCT"                                           
   V1043 = "CUSTODY-FIREARM:NOV"                                           
   V1044 = "CUSTODY-FIREARM:DEC"                                           
   V1045 = "CUSTODY-KNIFE:JAN"                                             
   V1046 = "CUSTODY-KNIFE:FEB"                                             
   V1047 = "CUSTODY-KNIFE:MAR"                                             
   V1048 = "CUSTODY-KNIFE:APR"                                             
   V1049 = "CUSTODY-KNIFE:MAY"                                             
   V1050 = "CUSTODY-KNIFE:JUN"                                             
   V1051 = "CUSTODY-KNIFE:JUL"                                             
   V1052 = "CUSTODY-KNIFE:AUG"                                             
   V1053 = "CUSTODY-KNIFE:SEP"                                             
   V1054 = "CUSTODY-KNIFE:OCT"                                             
   V1055 = "CUSTODY-KNIFE:NOV"                                             
   V1056 = "CUSTODY-KNIFE:DEC"                                             
   V1057 = "CUSTODY-OTHER:JAN"                                             
   V1058 = "CUSTODY-OTHER:FEB"                                             
   V1059 = "CUSTODY-OTHER:MAR"                                             
   V1060 = "CUSTODY-OTHER:APR"                                             
   V1061 = "CUSTODY-OTHER:MAY"                                             
   V1062 = "CUSTODY-OTHER:JUN"                                             
   V1063 = "CUSTODY-OTHER:JUL"                                             
   V1064 = "CUSTODY-OTHER:AUG"                                             
   V1065 = "CUSTODY-OTHER:SEP"                                             
   V1066 = "CUSTODY-OTHER:OCT"                                             
   V1067 = "CUSTODY-OTHER:NOV"                                             
   V1068 = "CUSTODY-OTHER:DEC"                                             
   V1069 = "CUSTODY-HANDS FEET:JAN"                                        
   V1070 = "CUSTODY-HANDS FEET:FEB"                                        
   V1071 = "CUSTODY-HANDS FEET:MAR"                                        
   V1072 = "CUSTODY-HANDS FEET:APR"                                        
   V1073 = "CUSTODY-HANDS FEET:MAY"                                        
   V1074 = "CUSTODY-HANDS FEET:JUN"                                        
   V1075 = "CUSTODY-HANDS FEET:JUL"                                        
   V1076 = "CUSTODY-HANDS FEET:AUG"                                        
   V1077 = "CUSTODY-HANDS FEET:SEP"                                        
   V1078 = "CUSTODY-HANDS FEET:OCT"                                        
   V1079 = "CUSTODY-HANDS FEET:NOV"                                        
   V1080 = "CUSTODY-HANDS FEET:DEC"                                        
   V1081 = "CUSTODY-2-MAN VEHIC:JAN"                                       
   V1082 = "CUSTODY-2-MAN VEHIC:FEB"                                       
   V1083 = "CUSTODY-2-MAN VEHIC:MAR"                                       
   V1084 = "CUSTODY-2-MAN VEHIC:APR"                                       
   V1085 = "CUSTODY-2-MAN VEHIC:MAY"                                       
   V1086 = "CUSTODY-2-MAN VEHIC:JUN"                                       
   V1087 = "CUSTODY-2-MAN VEHIC:JUL"                                       
   V1088 = "CUSTODY-2-MAN VEHIC:AUG"                                       
   V1089 = "CUSTODY-2-MAN VEHIC:SEP"                                       
   V1090 = "CUSTODY-2-MAN VEHIC:OCT"                                       
   V1091 = "CUSTODY-2-MAN VEHIC:NOV"                                       
   V1092 = "CUSTODY-2-MAN VEHIC:DEC"                                       
   V1093 = "CUSTODY-1-MAN ALONE:JAN"                                       
   V1094 = "CUSTODY-1-MAN ALONE:FEB"                                       
   V1095 = "CUSTODY-1-MAN ALONE:MAR"                                       
   V1096 = "CUSTODY-1-MAN ALONE:APR"                                       
   V1097 = "CUSTODY-1-MAN ALONE:MAY"                                       
   V1098 = "CUSTODY-1-MAN ALONE:JUN"                                       
   V1099 = "CUSTODY-1-MAN ALONE:JUL"                                       
   V1100 = "CUSTODY-1-MAN ALONE:AUG"                                       
   V1101 = "CUSTODY-1-MAN ALONE:SEP"                                       
   V1102 = "CUSTODY-1-MAN ALONE:OCT"                                       
   V1103 = "CUSTODY-1-MAN ALONE:NOV"                                       
   V1104 = "CUSTODY-1-MAN ALONE:DEC"                                       
   V1105 = "CUSTODY-1-MAN ASSIST:JAN"                                      
   V1106 = "CUSTODY-1-MAN ASSIST:FEB"                                      
   V1107 = "CUSTODY-1-MAN ASSIST:MAR"                                      
   V1108 = "CUSTODY-1-MAN ASSIST:APR"                                      
   V1109 = "CUSTODY-1-MAN ASSIST:MAY"                                      
   V1110 = "CUSTODY-1-MAN ASSIST:JUN"                                      
   V1111 = "CUSTODY-1-MAN ASSIST:JUL"                                      
   V1112 = "CUSTODY-1-MAN ASSIST:AUG"                                      
   V1113 = "CUSTODY-1-MAN ASSIST:SEP"                                      
   V1114 = "CUSTODY-1-MAN ASSIST:OCT"                                      
   V1115 = "CUSTODY-1-MAN ASSIST:NOV"                                      
   V1116 = "CUSTODY-1-MAN ASSIST:DEC"                                      
   V1117 = "CUSTODY-DETECT ALONE:JAN"                                      
   V1118 = "CUSTODY-DETECT ALONE:FEB"                                      
   V1119 = "CUSTODY-DETECT ALONE:MAR"                                      
   V1120 = "CUSTODY-DETECT ALONE:APR"                                      
   V1121 = "CUSTODY-DETECT ALONE:MAY"                                      
   V1122 = "CUSTODY-DETECT ALONE:JUN"                                      
   V1123 = "CUSTODY-DETECT ALONE:JUL"                                      
   V1124 = "CUSTODY-DETECT ALONE:AUG"                                      
   V1125 = "CUSTODY-DETECT ALONE:SEP"                                      
   V1126 = "CUSTODY-DETECT ALONE:OCT"                                      
   V1127 = "CUSTODY-DETECT ALONE:NOV"                                      
   V1128 = "CUSTODY-DETECT ALONE:DEC"                                      
   V1129 = "CUSTODY-DETECT ASST:JAN"                                       
   V1130 = "CUSTODY-DETECT ASST:FEB"                                       
   V1131 = "CUSTODY-DETECT ASST:MAR"                                       
   V1132 = "CUSTODY-DETECT ASST:APR"                                       
   V1133 = "CUSTODY-DETECT ASST:MAY"                                       
   V1134 = "CUSTODY-DETECT ASST:JUN"                                       
   V1135 = "CUSTODY-DETECT ASST:JUL"                                       
   V1136 = "CUSTODY-DETECT ASST:AUG"                                       
   V1137 = "CUSTODY-DETECT ASST:SEP"                                       
   V1138 = "CUSTODY-DETECT ASST:OCT"                                       
   V1139 = "CUSTODY-DETECT ASST:NOV"                                       
   V1140 = "CUSTODY-DETECT ASST:DEC"                                       
   V1141 = "CUSTODY-OTHER ALONE:JAN"                                       
   V1142 = "CUSTODY-OTHER ALONE:FEB"                                       
   V1143 = "CUSTODY-OTHER ALONE:MAR"                                       
   V1144 = "CUSTODY-OTHER ALONE:APR"                                       
   V1145 = "CUSTODY-OTHER ALONE:MAY"                                       
   V1146 = "CUSTODY-OTHER ALONE:JUN"                                       
   V1147 = "CUSTODY-OTHER ALONE:JUL"                                       
   V1148 = "CUSTODY-OTHER ALONE:AUG"                                       
   V1149 = "CUSTODY-OTHER ALONE:SEP"                                       
   V1150 = "CUSTODY-OTHER ALONE:OCT"                                       
   V1151 = "CUSTODY-OTHER ALONE:NOV"                                       
   V1152 = "CUSTODY-OTHER ALONE:DEC"                                       
   V1153 = "CUSTODY-OTHER ASSIST:JAN"                                      
   V1154 = "CUSTODY-OTHER ASSIST:FEB"                                      
   V1155 = "CUSTODY-OTHER ASSIST:MAR"                                      
   V1156 = "CUSTODY-OTHER ASSIST:APR"                                      
   V1157 = "CUSTODY-OTHER ASSIST:MAY"                                      
   V1158 = "CUSTODY-OTHER ASSIST:JUN"                                      
   V1159 = "CUSTODY-OTHER ASSIST:JUL"                                      
   V1160 = "CUSTODY-OTHER ASSIST:AUG"                                      
   V1161 = "CUSTODY-OTHER ASSIST:SEP"                                      
   V1162 = "CUSTODY-OTHER ASSIST:OCT"                                      
   V1163 = "CUSTODY-OTHER ASSIST:NOV"                                      
   V1164 = "CUSTODY-OTHER ASSIST:DEC"                                      
   V1165 = "CUSTODY-ASSLT CLEAR:JAN"                                       
   V1166 = "CUSTODY-ASSLT CLEAR:FEB"                                       
   V1167 = "CUSTODY-ASSLT CLEAR:MAR"                                       
   V1168 = "CUSTODY-ASSLT CLEAR:APR"                                       
   V1169 = "CUSTODY-ASSLT CLEAR:MAY"                                       
   V1170 = "CUSTODY-ASSLT CLEAR:JUN"                                       
   V1171 = "CUSTODY-ASSLT CLEAR:JUL"                                       
   V1172 = "CUSTODY-ASSLT CLEAR:AUG"                                       
   V1173 = "CUSTODY-ASSLT CLEAR:SEP"                                       
   V1174 = "CUSTODY-ASSLT CLEAR:OCT"                                       
   V1175 = "CUSTODY-ASSLT CLEAR:NOV"                                       
   V1176 = "CUSTODY-ASSLT CLEAR:DEC"                                       
   V1177 = "SUSPIC-TOTAL ASSAULT:JAN"                                      
   V1178 = "SUSPIC-TOTAL ASSAULT:FEB"                                      
   V1179 = "SUSPIC-TOTAL ASSAULT:MAR"                                      
   V1180 = "SUSPIC-TOTAL ASSAULT:APR"                                      
   V1181 = "SUSPIC-TOTAL ASSAULT:MAY"                                      
   V1182 = "SUSPIC-TOTAL ASSAULT:JUN"                                      
   V1183 = "SUSPIC-TOTAL ASSAULT:JUL"                                      
   V1184 = "SUSPIC-TOTAL ASSAULT:AUG"                                      
   V1185 = "SUSPIC-TOTAL ASSAULT:SEP"                                      
   V1186 = "SUSPIC-TOTAL ASSAULT:OCT"                                      
   V1187 = "SUSPIC-TOTAL ASSAULT:NOV"                                      
   V1188 = "SUSPIC-TOTAL ASSAULT:DEC"                                      
   V1189 = "SUSPIC-FIREARM:JAN"                                            
   V1190 = "SUSPIC-FIREARM:FEB"                                            
   V1191 = "SUSPIC-FIREARM:MAR"                                            
   V1192 = "SUSPIC-FIREARM:APR"                                            
   V1193 = "SUSPIC-FIREARM:MAY"                                            
   V1194 = "SUSPIC-FIREARM:JUN"                                            
   V1195 = "SUSPIC-FIREARM:JUL"                                            
   V1196 = "SUSPIC-FIREARM:AUG"                                            
   V1197 = "SUSPIC-FIREARM:SEP"                                            
   V1198 = "SUSPIC-FIREARM:OCT"                                            
   V1199 = "SUSPIC-FIREARM:NOV"                                            
   V1200 = "SUSPIC-FIREARM:DEC"                                            
   V1201 = "SUSPIC-KNIFE:JAN"                                              
   V1202 = "SUSPIC-KNIFE:FEB"                                              
   V1203 = "SUSPIC-KNIFE:MAR"                                              
   V1204 = "SUSPIC-KNIFE:APR"                                              
   V1205 = "SUSPIC-KNIFE:MAY"                                              
   V1206 = "SUSPIC-KNIFE:JUN"                                              
   V1207 = "SUSPIC-KNIFE:JUL"                                              
   V1208 = "SUSPIC-KNIFE:AUG"                                              
   V1209 = "SUSPIC-KNIFE:SEP"                                              
   V1210 = "SUSPIC-KNIFE:OCT"                                              
   V1211 = "SUSPIC-KNIFE:NOV"                                              
   V1212 = "SUSPIC-KNIFE:DEC"                                              
   V1213 = "SUSPIC-OTHER:JAN"                                              
   V1214 = "SUSPIC-OTHER:FEB"                                              
   V1215 = "SUSPIC-OTHER:MAR"                                              
   V1216 = "SUSPIC-OTHER:APR"                                              
   V1217 = "SUSPIC-OTHER:MAY"                                              
   V1218 = "SUSPIC-OTHER:JUN"                                              
   V1219 = "SUSPIC-OTHER:JUL"                                              
   V1220 = "SUSPIC-OTHER:AUG"                                              
   V1221 = "SUSPIC-OTHER:SEP"                                              
   V1222 = "SUSPIC-OTHER:OCT"                                              
   V1223 = "SUSPIC-OTHER:NOV"                                              
   V1224 = "SUSPIC-OTHER:DEC"                                              
   V1225 = "SUSPIC-HANDS FEET:JAN"                                         
   V1226 = "SUSPIC-HANDS FEET:FEB"                                         
   V1227 = "SUSPIC-HANDS FEET:MAR"                                         
   V1228 = "SUSPIC-HANDS FEET:APR"                                         
   V1229 = "SUSPIC-HANDS FEET:MAY"                                         
   V1230 = "SUSPIC-HANDS FEET:JUN"                                         
   V1231 = "SUSPIC-HANDS FEET:JUL"                                         
   V1232 = "SUSPIC-HANDS FEET:AUG"                                         
   V1233 = "SUSPIC-HANDS FEET:SEP"                                         
   V1234 = "SUSPIC-HANDS FEET:OCT"                                         
   V1235 = "SUSPIC-HANDS FEET:NOV"                                         
   V1236 = "SUSPIC-HANDS FEET:DEC"                                         
   V1237 = "SUSPIC-2-MAN VEHIC:JAN"                                        
   V1238 = "SUSPIC-2-MAN VEHIC:FEB"                                        
   V1239 = "SUSPIC-2-MAN VEHIC:MAR"                                        
   V1240 = "SUSPIC-2-MAN VEHIC:APR"                                        
   V1241 = "SUSPIC-2-MAN VEHIC:MAY"                                        
   V1242 = "SUSPIC-2-MAN VEHIC:JUN"                                        
   V1243 = "SUSPIC-2-MAN VEHIC:JUL"                                        
   V1244 = "SUSPIC-2-MAN VEHIC:AUG"                                        
   V1245 = "SUSPIC-2-MAN VEHIC:SEP"                                        
   V1246 = "SUSPIC-2-MAN VEHIC:OCT"                                        
   V1247 = "SUSPIC-2-MAN VEHIC:NOV"                                        
   V1248 = "SUSPIC-2-MAN VEHIC:DEC"                                        
   V1249 = "SUSPIC-1-MAN ALONE:JAN"                                        
   V1250 = "SUSPIC-1-MAN ALONE:FEB"                                        
   V1251 = "SUSPIC-1-MAN ALONE:MAR"                                        
   V1252 = "SUSPIC-1-MAN ALONE:APR"                                        
   V1253 = "SUSPIC-1-MAN ALONE:MAY"                                        
   V1254 = "SUSPIC-1-MAN ALONE:JUN"                                        
   V1255 = "SUSPIC-1-MAN ALONE:JUL"                                        
   V1256 = "SUSPIC-1-MAN ALONE:AUG"                                        
   V1257 = "SUSPIC-1-MAN ALONE:SEP"                                        
   V1258 = "SUSPIC-1-MAN ALONE:OCT"                                        
   V1259 = "SUSPIC-1-MAN ALONE:NOV"                                        
   V1260 = "SUSPIC-1-MAN ALONE:DEC"                                        
   V1261 = "SUSPIC-1-MAN ASSIST:JAN"                                       
   V1262 = "SUSPIC-1-MAN ASSIST:FEB"                                       
   V1263 = "SUSPIC-1-MAN ASSIST:MAR"                                       
   V1264 = "SUSPIC-1-MAN ASSIST:APR"                                       
   V1265 = "SUSPIC-1-MAN ASSIST:MAY"                                       
   V1266 = "SUSPIC-1-MAN ASSIST:JUN"                                       
   V1267 = "SUSPIC-1-MAN ASSIST:JUL"                                       
   V1268 = "SUSPIC-1-MAN ASSIST:AUG"                                       
   V1269 = "SUSPIC-1-MAN ASSIST:SEP"                                       
   V1270 = "SUSPIC-1-MAN ASSIST:OCT"                                       
   V1271 = "SUSPIC-1-MAN ASSIST:NOV"                                       
   V1272 = "SUSPIC-1-MAN ASSIST:DEC"                                       
   V1273 = "SUSPIC-DETECT ALONE:JAN"                                       
   V1274 = "SUSPIC-DETECT ALONE:FEB"                                       
   V1275 = "SUSPIC-DETECT ALONE:MAR"                                       
   V1276 = "SUSPIC-DETECT ALONE:APR"                                       
   V1277 = "SUSPIC-DETECT ALONE:MAY"                                       
   V1278 = "SUSPIC-DETECT ALONE:JUN"                                       
   V1279 = "SUSPIC-DETECT ALONE:JUL"                                       
   V1280 = "SUSPIC-DETECT ALONE:AUG"                                       
   V1281 = "SUSPIC-DETECT ALONE:SEP"                                       
   V1282 = "SUSPIC-DETECT ALONE:OCT"                                       
   V1283 = "SUSPIC-DETECT ALONE:NOV"                                       
   V1284 = "SUSPIC-DETECT ALONE:DEC"                                       
   V1285 = "SUSPIC-DETECT ASST:JAN"                                        
   V1286 = "SUSPIC-DETECT ASST:FEB"                                        
   V1287 = "SUSPIC-DETECT ASST:MAR"                                        
   V1288 = "SUSPIC-DETECT ASST:APR"                                        
   V1289 = "SUSPIC-DETECT ASST:MAY"                                        
   V1290 = "SUSPIC-DETECT ASST:JUN"                                        
   V1291 = "SUSPIC-DETECT ASST:JUL"                                        
   V1292 = "SUSPIC-DETECT ASST:AUG"                                        
   V1293 = "SUSPIC-DETECT ASST:SEP"                                        
   V1294 = "SUSPIC-DETECT ASST:OCT"                                        
   V1295 = "SUSPIC-DETECT ASST:NOV"                                        
   V1296 = "SUSPIC-DETECT ASST:DEC"                                        
   V1297 = "SUSPIC-OTHER ALONE:JAN"                                        
   V1298 = "SUSPIC-OTHER ALONE:FEB"                                        
   V1299 = "SUSPIC-OTHER ALONE:MAR"                                        
   V1300 = "SUSPIC-OTHER ALONE:APR"                                        
   V1301 = "SUSPIC-OTHER ALONE:MAY"                                        
   V1302 = "SUSPIC-OTHER ALONE:JUN"                                        
   V1303 = "SUSPIC-OTHER ALONE:JUL"                                        
   V1304 = "SUSPIC-OTHER ALONE:AUG"                                        
   V1305 = "SUSPIC-OTHER ALONE:SEP"                                        
   V1306 = "SUSPIC-OTHER ALONE:OCT"                                        
   V1307 = "SUSPIC-OTHER ALONE:NOV"                                        
   V1308 = "SUSPIC-OTHER ALONE:DEC"                                        
   V1309 = "SUSPIC-OTHER ASSIST:JAN"                                       
   V1310 = "SUSPIC-OTHER ASSIST:FEB"                                       
   V1311 = "SUSPIC-OTHER ASSIST:MAR"                                       
   V1312 = "SUSPIC-OTHER ASSIST:APR"                                       
   V1313 = "SUSPIC-OTHER ASSIST:MAY"                                       
   V1314 = "SUSPIC-OTHER ASSIST:JUN"                                       
   V1315 = "SUSPIC-OTHER ASSIST:JUL"                                       
   V1316 = "SUSPIC-OTHER ASSIST:AUG"                                       
   V1317 = "SUSPIC-OTHER ASSIST:SEP"                                       
   V1318 = "SUSPIC-OTHER ASSIST:OCT"                                       
   V1319 = "SUSPIC-OTHER ASSIST:NOV"                                       
   V1320 = "SUSPIC-OTHER ASSIST:DEC"                                       
   V1321 = "SUSPIC-ASSLT CLEAR:JAN"                                        
   V1322 = "SUSPIC-ASSLT CLEAR:FEB"                                        
   V1323 = "SUSPIC-ASSLT CLEAR:MAR"                                        
   V1324 = "SUSPIC-ASSLT CLEAR:APR"                                        
   V1325 = "SUSPIC-ASSLT CLEAR:MAY"                                        
   V1326 = "SUSPIC-ASSLT CLEAR:JUN"                                        
   V1327 = "SUSPIC-ASSLT CLEAR:JUL"                                        
   V1328 = "SUSPIC-ASSLT CLEAR:AUG"                                        
   V1329 = "SUSPIC-ASSLT CLEAR:SEP"                                        
   V1330 = "SUSPIC-ASSLT CLEAR:OCT"                                        
   V1331 = "SUSPIC-ASSLT CLEAR:NOV"                                        
   V1332 = "SUSPIC-ASSLT CLEAR:DEC"                                        
   V1333 = "AMBUSH-TOTAL ASSAULT:JAN"                                      
   V1334 = "AMBUSH-TOTAL ASSAULT:FEB"                                      
   V1335 = "AMBUSH-TOTAL ASSAULT:MAR"                                      
   V1336 = "AMBUSH-TOTAL ASSAULT:APR"                                      
   V1337 = "AMBUSH-TOTAL ASSAULT:MAY"                                      
   V1338 = "AMBUSH-TOTAL ASSAULT:JUN"                                      
   V1339 = "AMBUSH-TOTAL ASSAULT:JUL"                                      
   V1340 = "AMBUSH-TOTAL ASSAULT:AUG"                                      
   V1341 = "AMBUSH-TOTAL ASSAULT:SEP"                                      
   V1342 = "AMBUSH-TOTAL ASSAULT:OCT"                                      
   V1343 = "AMBUSH-TOTAL ASSAULT:NOV"                                      
   V1344 = "AMBUSH-TOTAL ASSAULT:DEC"                                      
   V1345 = "AMBUSH-FIREARM:JAN"                                            
   V1346 = "AMBUSH-FIREARM:FEB"                                            
   V1347 = "AMBUSH-FIREARM:MAR"                                            
   V1348 = "AMBUSH-FIREARM:APR"                                            
   V1349 = "AMBUSH-FIREARM:MAY"                                            
   V1350 = "AMBUSH-FIREARM:JUN"                                            
   V1351 = "AMBUSH-FIREARM:JUL"                                            
   V1352 = "AMBUSH-FIREARM:AUG"                                            
   V1353 = "AMBUSH-FIREARM:SEP"                                            
   V1354 = "AMBUSH-FIREARM:OCT"                                            
   V1355 = "AMBUSH-FIREARM:NOV"                                            
   V1356 = "AMBUSH-FIREARM:DEC"                                            
   V1357 = "AMBUSH-KNIFE:JAN"                                              
   V1358 = "AMBUSH-KNIFE:FEB"                                              
   V1359 = "AMBUSH-KNIFE:MAR"                                              
   V1360 = "AMBUSH-KNIFE:APR"                                              
   V1361 = "AMBUSH-KNIFE:MAY"                                              
   V1362 = "AMBUSH-KNIFE:JUN"                                              
   V1363 = "AMBUSH-KNIFE:JUL"                                              
   V1364 = "AMBUSH-KNIFE:AUG"                                              
   V1365 = "AMBUSH-KNIFE:SEP"                                              
   V1366 = "AMBUSH-KNIFE:OCT"                                              
   V1367 = "AMBUSH-KNIFE:NOV"                                              
   V1368 = "AMBUSH-KNIFE:DEC"                                              
   V1369 = "AMBUSH-OTHER:JAN"                                              
   V1370 = "AMBUSH-OTHER:FEB"                                              
   V1371 = "AMBUSH-OTHER:MAR"                                              
   V1372 = "AMBUSH-OTHER:APR"                                              
   V1373 = "AMBUSH-OTHER:MAY"                                              
   V1374 = "AMBUSH-OTHER:JUN"                                              
   V1375 = "AMBUSH-OTHER:JUL"                                              
   V1376 = "AMBUSH-OTHER:AUG"                                              
   V1377 = "AMBUSH-OTHER:SEP"                                              
   V1378 = "AMBUSH-OTHER:OCT"                                              
   V1379 = "AMBUSH-OTHER:NOV"                                              
   V1380 = "AMBUSH-OTHER:DEC"                                              
   V1381 = "AMBUSH-HANDS FEET:JAN"                                         
   V1382 = "AMBUSH-HANDS FEET:FEB"                                         
   V1383 = "AMBUSH-HANDS FEET:MAR"                                         
   V1384 = "AMBUSH-HANDS FEET:APR"                                         
   V1385 = "AMBUSH-HANDS FEET:MAY"                                         
   V1386 = "AMBUSH-HANDS FEET:JUN"                                         
   V1387 = "AMBUSH-HANDS FEET:JUL"                                         
   V1388 = "AMBUSH-HANDS FEET:AUG"                                         
   V1389 = "AMBUSH-HANDS FEET:SEP"                                         
   V1390 = "AMBUSH-HANDS FEET:OCT"                                         
   V1391 = "AMBUSH-HANDS FEET:NOV"                                         
   V1392 = "AMBUSH-HANDS FEET:DEC"                                         
   V1393 = "AMBUSH-2-MAN VEHIC:JAN"                                        
   V1394 = "AMBUSH-2-MAN VEHIC:FEB"                                        
   V1395 = "AMBUSH-2-MAN VEHIC:MAR"                                        
   V1396 = "AMBUSH-2-MAN VEHIC:APR"                                        
   V1397 = "AMBUSH-2-MAN VEHIC:MAY"                                        
   V1398 = "AMBUSH-2-MAN VEHIC:JUN"                                        
   V1399 = "AMBUSH-2-MAN VEHIC:JUL"                                        
   V1400 = "AMBUSH-2-MAN VEHIC:AUG"                                        
   V1401 = "AMBUSH-2-MAN VEHIC:SEP"                                        
   V1402 = "AMBUSH-2-MAN VEHIC:OCT"                                        
   V1403 = "AMBUSH-2-MAN VEHIC:NOV"                                        
   V1404 = "AMBUSH-2-MAN VEHIC:DEC"                                        
   V1405 = "AMBUSH-1-MAN ALONE:JAN"                                        
   V1406 = "AMBUSH-1-MAN ALONE:FEB"                                        
   V1407 = "AMBUSH-1-MAN ALONE:MAR"                                        
   V1408 = "AMBUSH-1-MAN ALONE:APR"                                        
   V1409 = "AMBUSH-1-MAN ALONE:MAY"                                        
   V1410 = "AMBUSH-1-MAN ALONE:JUN"                                        
   V1411 = "AMBUSH-1-MAN ALONE:JUL"                                        
   V1412 = "AMBUSH-1-MAN ALONE:AUG"                                        
   V1413 = "AMBUSH-1-MAN ALONE:SEP"                                        
   V1414 = "AMBUSH-1-MAN ALONE:OCT"                                        
   V1415 = "AMBUSH-1-MAN ALONE:NOV"                                        
   V1416 = "AMBUSH-1-MAN ALONE:DEC"                                        
   V1417 = "AMBUSH-1-MAN ASSIST:JAN"                                       
   V1418 = "AMBUSH-1-MAN ASSIST:FEB"                                       
   V1419 = "AMBUSH-1-MAN ASSIST:MAR"                                       
   V1420 = "AMBUSH-1-MAN ASSIST:APR"                                       
   V1421 = "AMBUSH-1-MAN ASSIST:MAY"                                       
   V1422 = "AMBUSH-1-MAN ASSIST:JUN"                                       
   V1423 = "AMBUSH-1-MAN ASSIST:JUL"                                       
   V1424 = "AMBUSH-1-MAN ASSIST:AUG"                                       
   V1425 = "AMBUSH-1-MAN ASSIST:SEP"                                       
   V1426 = "AMBUSH-1-MAN ASSIST:OCT"                                       
   V1427 = "AMBUSH-1-MAN ASSIST:NOV"                                       
   V1428 = "AMBUSH-1-MAN ASSIST:DEC"                                       
   V1429 = "AMBUSH-DETECT ALONE:JAN"                                       
   V1430 = "AMBUSH-DETECT ALONE:FEB"                                       
   V1431 = "AMBUSH-DETECT ALONE:MAR"                                       
   V1432 = "AMBUSH-DETECT ALONE:APR"                                       
   V1433 = "AMBUSH-DETECT ALONE:MAY"                                       
   V1434 = "AMBUSH-DETECT ALONE:JUN"                                       
   V1435 = "AMBUSH-DETECT ALONE:JUL"                                       
   V1436 = "AMBUSH-DETECT ALONE:AUG"                                       
   V1437 = "AMBUSH-DETECT ALONE:SEP"                                       
   V1438 = "AMBUSH-DETECT ALONE:OCT"                                       
   V1439 = "AMBUSH-DETECT ALONE:NOV"                                       
   V1440 = "AMBUSH-DETECT ALONE:DEC"                                       
   V1441 = "AMBUSH-DETECT ASST:JAN"                                        
   V1442 = "AMBUSH-DETECT ASST:FEB"                                        
   V1443 = "AMBUSH-DETECT ASST:MAR"                                        
   V1444 = "AMBUSH-DETECT ASST:APR"                                        
   V1445 = "AMBUSH-DETECT ASST:MAY"                                        
   V1446 = "AMBUSH-DETECT ASST:JUN"                                        
   V1447 = "AMBUSH-DETECT ASST:JUL"                                        
   V1448 = "AMBUSH-DETECT ASST:AUG"                                        
   V1449 = "AMBUSH-DETECT ASST:SEP"                                        
   V1450 = "AMBUSH-DETECT ASST:OCT"                                        
   V1451 = "AMBUSH-DETECT ASST:NOV"                                        
   V1452 = "AMBUSH-DETECT ASST:DEC"                                        
   V1453 = "AMBUSH-OTHER ALONE:JAN"                                        
   V1454 = "AMBUSH-OTHER ALONE:FEB"                                        
   V1455 = "AMBUSH-OTHER ALONE:MAR"                                        
   V1456 = "AMBUSH-OTHER ALONE:APR"                                        
   V1457 = "AMBUSH-OTHER ALONE:MAY"                                        
   V1458 = "AMBUSH-OTHER ALONE:JUN"                                        
   V1459 = "AMBUSH-OTHER ALONE:JUL"                                        
   V1460 = "AMBUSH-OTHER ALONE:AUG"                                        
   V1461 = "AMBUSH-OTHER ALONE:SEP"                                        
   V1462 = "AMBUSH-OTHER ALONE:OCT"                                        
   V1463 = "AMBUSH-OTHER ALONE:NOV"                                        
   V1464 = "AMBUSH-OTHER ALONE:DEC"                                        
   V1465 = "AMBUSH-OTHER ASSIST:JAN"                                       
   V1466 = "AMBUSH-OTHER ASSIST:FEB"                                       
   V1467 = "AMBUSH-OTHER ASSIST:MAR"                                       
   V1468 = "AMBUSH-OTHER ASSIST:APR"                                       
   V1469 = "AMBUSH-OTHER ASSIST:MAY"                                       
   V1470 = "AMBUSH-OTHER ASSIST:JUN"                                       
   V1471 = "AMBUSH-OTHER ASSIST:JUL"                                       
   V1472 = "AMBUSH-OTHER ASSIST:AUG"                                       
   V1473 = "AMBUSH-OTHER ASSIST:SEP"                                       
   V1474 = "AMBUSH-OTHER ASSIST:OCT"                                       
   V1475 = "AMBUSH-OTHER ASSIST:NOV"                                       
   V1476 = "AMBUSH-OTHER ASSIST:DEC"                                       
   V1477 = "AMBUSH-ASSLT CLEAR:JAN"                                        
   V1478 = "AMBUSH-ASSLT CLEAR:FEB"                                        
   V1479 = "AMBUSH-ASSLT CLEAR:MAR"                                        
   V1480 = "AMBUSH-ASSLT CLEAR:APR"                                        
   V1481 = "AMBUSH-ASSLT CLEAR:MAY"                                        
   V1482 = "AMBUSH-ASSLT CLEAR:JUN"                                        
   V1483 = "AMBUSH-ASSLT CLEAR:JUL"                                        
   V1484 = "AMBUSH-ASSLT CLEAR:AUG"                                        
   V1485 = "AMBUSH-ASSLT CLEAR:SEP"                                        
   V1486 = "AMBUSH-ASSLT CLEAR:OCT"                                        
   V1487 = "AMBUSH-ASSLT CLEAR:NOV"                                        
   V1488 = "AMBUSH-ASSLT CLEAR:DEC"                                        
   V1489 = "MENTAL-TOTAL ASSAULT:JAN"                                      
   V1490 = "MENTAL-TOTAL ASSAULT:FEB"                                      
   V1491 = "MENTAL-TOTAL ASSAULT:MAR"                                      
   V1492 = "MENTAL-TOTAL ASSAULT:APR"                                      
   V1493 = "MENTAL-TOTAL ASSAULT:MAY"                                      
   V1494 = "MENTAL-TOTAL ASSAULT:JUN"                                      
   V1495 = "MENTAL-TOTAL ASSAULT:JUL"                                      
   V1496 = "MENTAL-TOTAL ASSAULT:AUG"                                      
   V1497 = "MENTAL-TOTAL ASSAULT:SEP"                                      
   V1498 = "MENTAL-TOTAL ASSAULT:OCT"                                      
   V1499 = "MENTAL-TOTAL ASSAULT:NOV"                                      
   V1500 = "MENTAL-TOTAL ASSAULT:DEC"                                      
   V1501 = "MENTAL-FIREARM:JAN"                                            
   V1502 = "MENTAL-FIREARM:FEB"                                            
   V1503 = "MENTAL-FIREARM:MAR"                                            
   V1504 = "MENTAL-FIREARM:APR"                                            
   V1505 = "MENTAL-FIREARM:MAY"                                            
   V1506 = "MENTAL-FIREARM:JUN"                                            
   V1507 = "MENTAL-FIREARM:JUL"                                            
   V1508 = "MENTAL-FIREARM:AUG"                                            
   V1509 = "MENTAL-FIREARM:SEP"                                            
   V1510 = "MENTAL-FIREARM:OCT"                                            
   V1511 = "MENTAL-FIREARM:NOV"                                            
   V1512 = "MENTAL-FIREARM:DEC"                                            
   V1513 = "MENTAL-KNIFE:JAN"                                              
   V1514 = "MENTAL-KNIFE:FEB"                                              
   V1515 = "MENTAL-KNIFE:MAR"                                              
   V1516 = "MENTAL-KNIFE:APR"                                              
   V1517 = "MENTAL-KNIFE:MAY"                                              
   V1518 = "MENTAL-KNIFE:JUN"                                              
   V1519 = "MENTAL-KNIFE:JUL"                                              
   V1520 = "MENTAL-KNIFE:AUG"                                              
   V1521 = "MENTAL-KNIFE:SEP"                                              
   V1522 = "MENTAL-KNIFE:OCT"                                              
   V1523 = "MENTAL-KNIFE:NOV"                                              
   V1524 = "MENTAL-KNIFE:DEC"                                              
   V1525 = "MENTAL-OTHER:JAN"                                              
   V1526 = "MENTAL-OTHER:FEB"                                              
   V1527 = "MENTAL-OTHER:MAR"                                              
   V1528 = "MENTAL-OTHER:APR"                                              
   V1529 = "MENTAL-OTHER:MAY"                                              
   V1530 = "MENTAL-OTHER:JUN"                                              
   V1531 = "MENTAL-OTHER:JUL"                                              
   V1532 = "MENTAL-OTHER:AUG"                                              
   V1533 = "MENTAL-OTHER:SEP"                                              
   V1534 = "MENTAL-OTHER:OCT"                                              
   V1535 = "MENTAL-OTHER:NOV"                                              
   V1536 = "MENTAL-OTHER:DEC"                                              
   V1537 = "MENTAL-HANDS FEET:JAN"                                         
   V1538 = "MENTAL-HANDS FEET:FEB"                                         
   V1539 = "MENTAL-HANDS FEET:MAR"                                         
   V1540 = "MENTAL-HANDS FEET:APR"                                         
   V1541 = "MENTAL-HANDS FEET:MAY"                                         
   V1542 = "MENTAL-HANDS FEET:JUN"                                         
   V1543 = "MENTAL-HANDS FEET:JUL"                                         
   V1544 = "MENTAL-HANDS FEET:AUG"                                         
   V1545 = "MENTAL-HANDS FEET:SEP"                                         
   V1546 = "MENTAL-HANDS FEET:OCT"                                         
   V1547 = "MENTAL-HANDS FEET:NOV"                                         
   V1548 = "MENTAL-HANDS FEET:DEC"                                         
   V1549 = "MENTAL-2-MAN VEHICLE:JAN"                                      
   V1550 = "MENTAL-2-MAN VEHICLE:FEB"                                      
   V1551 = "MENTAL-2-MAN VEHICLE:MAR"                                      
   V1552 = "MENTAL-2-MAN VEHICLE:APR"                                      
   V1553 = "MENTAL-2-MAN VEHICLE:MAY"                                      
   V1554 = "MENTAL-2-MAN VEHICLE:JUN"                                      
   V1555 = "MENTAL-2-MAN VEHICLE:JUL"                                      
   V1556 = "MENTAL-2-MAN VEHICLE:AUG"                                      
   V1557 = "MENTAL-2-MAN VEHICLE:SEP"                                      
   V1558 = "MENTAL-2-MAN VEHICLE:OCT"                                      
   V1559 = "MENTAL-2-MAN VEHICLE:NOV"                                      
   V1560 = "MENTAL-2-MAN VEHICLE:DEC"                                      
   V1561 = "MENTAL-1-MAN ALONE:JAN"                                        
   V1562 = "MENTAL-1-MAN ALONE:FEB"                                        
   V1563 = "MENTAL-1-MAN ALONE:MAR"                                        
   V1564 = "MENTAL-1-MAN ALONE:APR"                                        
   V1565 = "MENTAL-1-MAN ALONE:MAY"                                        
   V1566 = "MENTAL-1-MAN ALONE:JUN"                                        
   V1567 = "MENTAL-1-MAN ALONE:JUL"                                        
   V1568 = "MENTAL-1-MAN ALONE:AUG"                                        
   V1569 = "MENTAL-1-MAN ALONE:SEP"                                        
   V1570 = "MENTAL-1-MAN ALONE:OCT"                                        
   V1571 = "MENTAL-1-MAN ALONE:NOV"                                        
   V1572 = "MENTAL-1-MAN ALONE:DEC"                                        
   V1573 = "MENTAL-1-MAN ASSIST:JAN"                                       
   V1574 = "MENTAL-1-MAN ASSIST:FEB"                                       
   V1575 = "MENTAL-1-MAN ASSIST:MAR"                                       
   V1576 = "MENTAL-1-MAN ASSIST:APR"                                       
   V1577 = "MENTAL-1-MAN ASSIST:MAY"                                       
   V1578 = "MENTAL-1-MAN ASSIST:JUN"                                       
   V1579 = "MENTAL-1-MAN ASSIST:JUL"                                       
   V1580 = "MENTAL-1-MAN ASSIST:AUG"                                       
   V1581 = "MENTAL-1-MAN ASSIST:SEP"                                       
   V1582 = "MENTAL-1-MAN ASSIST:OCT"                                       
   V1583 = "MENTAL-1-MAN ASSIST:NOV"                                       
   V1584 = "MENTAL-1-MAN ASSIST:DEC"                                       
   V1585 = "MENTAL-DETECT ALONE:JAN"                                       
   V1586 = "MENTAL-DETECT ALONE:FEB"                                       
   V1587 = "MENTAL-DETECT ALONE:MAR"                                       
   V1588 = "MENTAL-DETECT ALONE:APR"                                       
   V1589 = "MENTAL-DETECT ALONE:MAY"                                       
   V1590 = "MENTAL-DETECT ALONE:JUN"                                       
   V1591 = "MENTAL-DETECT ALONE:JUL"                                       
   V1592 = "MENTAL-DETECT ALONE:AUG"                                       
   V1593 = "MENTAL-DETECT ALONE:SEP"                                       
   V1594 = "MENTAL-DETECT ALONE:OCT"                                       
   V1595 = "MENTAL-DETECT ALONE:NOV"                                       
   V1596 = "MENTAL-DETECT ALONE:DEC"                                       
   V1597 = "MENTAL-DETECT ASSIST:JAN"                                      
   V1598 = "MENTAL-DETECT ASSIST:FEB"                                      
   V1599 = "MENTAL-DETECT ASSIST:MAR"                                      
   V1600 = "MENTAL-DETECT ASSIST:APR"                                      
   V1601 = "MENTAL-DETECT ASSIST:MAY"                                      
   V1602 = "MENTAL-DETECT ASSIST:JUN"                                      
   V1603 = "MENTAL-DETECT ASSIST:JUL"                                      
   V1604 = "MENTAL-DETECT ASSIST:AUG"                                      
   V1605 = "MENTAL-DETECT ASSIST:SEP"                                      
   V1606 = "MENTAL-DETECT ASSIST:OCT"                                      
   V1607 = "MENTAL-DETECT ASSIST:NOV"                                      
   V1608 = "MENTAL-DETECT ASSIST:DEC"                                      
   V1609 = "MENTAL-OTHER ALONE:JAN"                                        
   V1610 = "MENTAL-OTHER ALONE:FEB"                                        
   V1611 = "MENTAL-OTHER ALONE:MAR"                                        
   V1612 = "MENTAL-OTHER ALONE:APR"                                        
   V1613 = "MENTAL-OTHER ALONE:MAY"                                        
   V1614 = "MENTAL-OTHER ALONE:JUN"                                        
   V1615 = "MENTAL-OTHER ALONE:JUL"                                        
   V1616 = "MENTAL-OTHER ALONE:AUG"                                        
   V1617 = "MENTAL-OTHER ALONE:SEP"                                        
   V1618 = "MENTAL-OTHER ALONE:OCT"                                        
   V1619 = "MENTAL-OTHER ALONE:NOV"                                        
   V1620 = "MENTAL-OTHER ALONE:DEC"                                        
   V1621 = "MENTAL-OTHER ASSIST:JAN"                                       
   V1622 = "MENTAL-OTHER ASSIST:FEB"                                       
   V1623 = "MENTAL-OTHER ASSIST:MAR"                                       
   V1624 = "MENTAL-OTHER ASSIST:APR"                                       
   V1625 = "MENTAL-OTHER ASSIST:MAY"                                       
   V1626 = "MENTAL-OTHER ASSIST:JUN"                                       
   V1627 = "MENTAL-OTHER ASSIST:JUL"                                       
   V1628 = "MENTAL-OTHER ASSIST:AUG"                                       
   V1629 = "MENTAL-OTHER ASSIST:SEP"                                       
   V1630 = "MENTAL-OTHER ASSIST:OCT"                                       
   V1631 = "MENTAL-OTHER ASSIST:NOV"                                       
   V1632 = "MENTAL-OTHER ASSIST:DEC"                                       
   V1633 = "MENTAL-ASSLTS CLEAR:JAN"                                       
   V1634 = "MENTAL-ASSLTS CLEAR:FEB"                                       
   V1635 = "MENTAL-ASSLTS CLEAR:MAR"                                       
   V1636 = "MENTAL-ASSLTS CLEAR:APR"                                       
   V1637 = "MENTAL-ASSLTS CLEAR:MAY"                                       
   V1638 = "MENTAL-ASSLTS CLEAR:JUN"                                       
   V1639 = "MENTAL-ASSLTS CLEAR:JUL"                                       
   V1640 = "MENTAL-ASSLTS CLEAR:AUG"                                       
   V1641 = "MENTAL-ASSLTS CLEAR:SEP"                                       
   V1642 = "MENTAL-ASSLTS CLEAR:OCT"                                       
   V1643 = "MENTAL-ASSLTS CLEAR:NOV"                                       
   V1644 = "MENTAL-ASSLTS CLEAR:DEC"                                       
   V1645 = "TRAFFIC-TOTAL ASSLT:JAN"                                       
   V1646 = "TRAFFIC-TOTAL ASSLT:FEB"                                       
   V1647 = "TRAFFIC-TOTAL ASSLT:MAR"                                       
   V1648 = "TRAFFIC-TOTAL ASSLT:APR"                                       
   V1649 = "TRAFFIC-TOTAL ASSLT:MAY"                                       
   V1650 = "TRAFFIC-TOTAL ASSLT:JUN"                                       
   V1651 = "TRAFFIC-TOTAL ASSLT:JUL"                                       
   V1652 = "TRAFFIC-TOTAL ASSLT:AUG"                                       
   V1653 = "TRAFFIC-TOTAL ASSLT:SEP"                                       
   V1654 = "TRAFFIC-TOTAL ASSLT:OCT"                                       
   V1655 = "TRAFFIC-TOTAL ASSLT:NOV"                                       
   V1656 = "TRAFFIC-TOTAL ASSLT:DEC"                                       
   V1657 = "TRAFFIC-FIREARM:JAN"                                           
   V1658 = "TRAFFIC-FIREARM:FEB"                                           
   V1659 = "TRAFFIC-FIREARM:MAR"                                           
   V1660 = "TRAFFIC-FIREARM:APR"                                           
   V1661 = "TRAFFIC-FIREARM:MAY"                                           
   V1662 = "TRAFFIC-FIREARM:JUN"                                           
   V1663 = "TRAFFIC-FIREARM:JUL"                                           
   V1664 = "TRAFFIC-FIREARM:AUG"                                           
   V1665 = "TRAFFIC-FIREARM:SEP"                                           
   V1666 = "TRAFFIC-FIREARM:OCT"                                           
   V1667 = "TRAFFIC-FIREARM:NOV"                                           
   V1668 = "TRAFFIC-FIREARM:DEC"                                           
   V1669 = "TRAFFIC-KNIFE:JAN"                                             
   V1670 = "TRAFFIC-KNIFE:FEB"                                             
   V1671 = "TRAFFIC-KNIFE:MAR"                                             
   V1672 = "TRAFFIC-KNIFE:APR"                                             
   V1673 = "TRAFFIC-KNIFE:MAY"                                             
   V1674 = "TRAFFIC-KNIFE:JUN"                                             
   V1675 = "TRAFFIC-KNIFE:JUL"                                             
   V1676 = "TRAFFIC-KNIFE:AUG"                                             
   V1677 = "TRAFFIC-KNIFE:SEP"                                             
   V1678 = "TRAFFIC-KNIFE:OCT"                                             
   V1679 = "TRAFFIC-KNIFE:NOV"                                             
   V1680 = "TRAFFIC-KNIFE:DEC"                                             
   V1681 = "TRAFFIC-OTHER:JAN"                                             
   V1682 = "TRAFFIC-OTHER:FEB"                                             
   V1683 = "TRAFFIC-OTHER:MAR"                                             
   V1684 = "TRAFFIC-OTHER:APR"                                             
   V1685 = "TRAFFIC-OTHER:MAY"                                             
   V1686 = "TRAFFIC-OTHER:JUN"                                             
   V1687 = "TRAFFIC-OTHER:JUL"                                             
   V1688 = "TRAFFIC-OTHER:AUG"                                             
   V1689 = "TRAFFIC-OTHER:SEP"                                             
   V1690 = "TRAFFIC-OTHER:OCT"                                             
   V1691 = "TRAFFIC-OTHER:NOV"                                             
   V1692 = "TRAFFIC-OTHER:DEC"                                             
   V1693 = "TRAFFIC-HANDS FEET:JAN"                                        
   V1694 = "TRAFFIC-HANDS FEET:FEB"                                        
   V1695 = "TRAFFIC-HANDS FEET:MAR"                                        
   V1696 = "TRAFFIC-HANDS FEET:APR"                                        
   V1697 = "TRAFFIC-HANDS FEET:MAY"                                        
   V1698 = "TRAFFIC-HANDS FEET:JUN"                                        
   V1699 = "TRAFFIC-HANDS FEET:JUL"                                        
   V1700 = "TRAFFIC-HANDS FEET:AUG"                                        
   V1701 = "TRAFFIC-HANDS FEET:SEP"                                        
   V1702 = "TRAFFIC-HANDS FEET:OCT"                                        
   V1703 = "TRAFFIC-HANDS FEET:NOV"                                        
   V1704 = "TRAFFIC-HANDS FEET:DEC"                                        
   V1705 = "TRAFFIC-2-MAN VEHIC:JAN"                                       
   V1706 = "TRAFFIC-2-MAN VEHIC:FEB"                                       
   V1707 = "TRAFFIC-2-MAN VEHIC:MAR"                                       
   V1708 = "TRAFFIC-2-MAN VEHIC:APR"                                       
   V1709 = "TRAFFIC-2-MAN VEHIC:MAY"                                       
   V1710 = "TRAFFIC-2-MAN VEHIC:JUN"                                       
   V1711 = "TRAFFIC-2-MAN VEHIC:JUL"                                       
   V1712 = "TRAFFIC-2-MAN VEHIC:AUG"                                       
   V1713 = "TRAFFIC-2-MAN VEHIC:SEP"                                       
   V1714 = "TRAFFIC-2-MAN VEHIC:OCT"                                       
   V1715 = "TRAFFIC-2-MAN VEHIC:NOV"                                       
   V1716 = "TRAFFIC-2-MAN VEHIC:DEC"                                       
   V1717 = "TRAFFIC-1-MAN ALONE:JAN"                                       
   V1718 = "TRAFFIC-1-MAN ALONE:FEB"                                       
   V1719 = "TRAFFIC-1-MAN ALONE:MAR"                                       
   V1720 = "TRAFFIC-1-MAN ALONE:APR"                                       
   V1721 = "TRAFFIC-1-MAN ALONE:MAY"                                       
   V1722 = "TRAFFIC-1-MAN ALONE:JUN"                                       
   V1723 = "TRAFFIC-1-MAN ALONE:JUL"                                       
   V1724 = "TRAFFIC-1-MAN ALONE:AUG"                                       
   V1725 = "TRAFFIC-1-MAN ALONE:SEP"                                       
   V1726 = "TRAFFIC-1-MAN ALONE:OCT"                                       
   V1727 = "TRAFFIC-1-MAN ALONE:NOV"                                       
   V1728 = "TRAFFIC-1-MAN ALONE:DEC"                                       
   V1729 = "TRAFFIC-1-MAN ASSIST:JAN"                                      
   V1730 = "TRAFFIC-1-MAN ASSIST:FEB"                                      
   V1731 = "TRAFFIC-1-MAN ASSIST:MAR"                                      
   V1732 = "TRAFFIC-1-MAN ASSIST:APR"                                      
   V1733 = "TRAFFIC-1-MAN ASSIST:MAY"                                      
   V1734 = "TRAFFIC-1-MAN ASSIST:JUN"                                      
   V1735 = "TRAFFIC-1-MAN ASSIST:JUL"                                      
   V1736 = "TRAFFIC-1-MAN ASSIST:AUG"                                      
   V1737 = "TRAFFIC-1-MAN ASSIST:SEP"                                      
   V1738 = "TRAFFIC-1-MAN ASSIST:OCT"                                      
   V1739 = "TRAFFIC-1-MAN ASSIST:NOV"                                      
   V1740 = "TRAFFIC-1-MAN ASSIST:DEC"                                      
   V1741 = "TRAFFIC-DETECT ALONE:JAN"                                      
   V1742 = "TRAFFIC-DETECT ALONE:FEB"                                      
   V1743 = "TRAFFIC-DETECT ALONE:MAR"                                      
   V1744 = "TRAFFIC-DETECT ALONE:APR"                                      
   V1745 = "TRAFFIC-DETECT ALONE:MAY"                                      
   V1746 = "TRAFFIC-DETECT ALONE:JUN"                                      
   V1747 = "TRAFFIC-DETECT ALONE:JUL"                                      
   V1748 = "TRAFFIC-DETECT ALONE:AUG"                                      
   V1749 = "TRAFFIC-DETECT ALONE:SEP"                                      
   V1750 = "TRAFFIC-DETECT ALONE:OCT"                                      
   V1751 = "TRAFFIC-DETECT ALONE:NOV"                                      
   V1752 = "TRAFFIC-DETECT ALONE:DEC"                                      
   V1753 = "TRAFFIC-DETECT ASST:JAN"                                       
   V1754 = "TRAFFIC-DETECT ASST:FEB"                                       
   V1755 = "TRAFFIC-DETECT ASST:MAR"                                       
   V1756 = "TRAFFIC-DETECT ASST:APR"                                       
   V1757 = "TRAFFIC-DETECT ASST:MAY"                                       
   V1758 = "TRAFFIC-DETECT ASST:JUN"                                       
   V1759 = "TRAFFIC-DETECT ASST:JUL"                                       
   V1760 = "TRAFFIC-DETECT ASST:AUG"                                       
   V1761 = "TRAFFIC-DETECT ASST:SEP"                                       
   V1762 = "TRAFFIC-DETECT ASST:OCT"                                       
   V1763 = "TRAFFIC-DETECT ASST:NOV"                                       
   V1764 = "TRAFFIC-DETECT ASST:DEC"                                       
   V1765 = "TRAFFIC-OTHER ALONE:JAN"                                       
   V1766 = "TRAFFIC-OTHER ALONE:FEB"                                       
   V1767 = "TRAFFIC-OTHER ALONE:MAR"                                       
   V1768 = "TRAFFIC-OTHER ALONE:APR"                                       
   V1769 = "TRAFFIC-OTHER ALONE:MAY"                                       
   V1770 = "TRAFFIC-OTHER ALONE:JUN"                                       
   V1771 = "TRAFFIC-OTHER ALONE:JUL"                                       
   V1772 = "TRAFFIC-OTHER ALONE:AUG"                                       
   V1773 = "TRAFFIC-OTHER ALONE:SEP"                                       
   V1774 = "TRAFFIC-OTHER ALONE:OCT"                                       
   V1775 = "TRAFFIC-OTHER ALONE:NOV"                                       
   V1776 = "TRAFFIC-OTHER ALONE:DEC"                                       
   V1777 = "TRAFFIC-OTHER ASSIST:JAN"                                      
   V1778 = "TRAFFIC-OTHER ASSIST:FEB"                                      
   V1779 = "TRAFFIC-OTHER ASSIST:MAR"                                      
   V1780 = "TRAFFIC-OTHER ASSIST:APR"                                      
   V1781 = "TRAFFIC-OTHER ASSIST:MAY"                                      
   V1782 = "TRAFFIC-OTHER ASSIST:JUN"                                      
   V1783 = "TRAFFIC-OTHER ASSIST:JUL"                                      
   V1784 = "TRAFFIC-OTHER ASSIST:AUG"                                      
   V1785 = "TRAFFIC-OTHER ASSIST:SEP"                                      
   V1786 = "TRAFFIC-OTHER ASSIST:OCT"                                      
   V1787 = "TRAFFIC-OTHER ASSIST:NOV"                                      
   V1788 = "TRAFFIC-OTHER ASSIST:DEC"                                      
   V1789 = "TRAFFIC-ASSLT CLEAR:JAN"                                       
   V1790 = "TRAFFIC-ASSLT CLEAR:FEB"                                       
   V1791 = "TRAFFIC-ASSLT CLEAR:MAR"                                       
   V1792 = "TRAFFIC-ASSLT CLEAR:APR"                                       
   V1793 = "TRAFFIC-ASSLT CLEAR:MAY"                                       
   V1794 = "TRAFFIC-ASSLT CLEAR:JUN"                                       
   V1795 = "TRAFFIC-ASSLT CLEAR:JUL"                                       
   V1796 = "TRAFFIC-ASSLT CLEAR:AUG"                                       
   V1797 = "TRAFFIC-ASSLT CLEAR:SEP"                                       
   V1798 = "TRAFFIC-ASSLT CLEAR:OCT"                                       
   V1799 = "TRAFFIC-ASSLT CLEAR:NOV"                                       
   V1800 = "TRAFFIC-ASSLT CLEAR:DEC"                                       
   V1801 = "OTHER-TOTAL ASSAULT:JAN"                                       
   V1802 = "OTHER-TOTAL ASSAULT:FEB"                                       
   V1803 = "OTHER-TOTAL ASSAULT:MAR"                                       
   V1804 = "OTHER-TOTAL ASSAULT:APR"                                       
   V1805 = "OTHER-TOTAL ASSAULT:MAY"                                       
   V1806 = "OTHER-TOTAL ASSAULT:JUN"                                       
   V1807 = "OTHER-TOTAL ASSAULT:JUL"                                       
   V1808 = "OTHER-TOTAL ASSAULT:AUG"                                       
   V1809 = "OTHER-TOTAL ASSAULT:SEP"                                       
   V1810 = "OTHER-TOTAL ASSAULT:OCT"                                       
   V1811 = "OTHER-TOTAL ASSAULT:NOV"                                       
   V1812 = "OTHER-TOTAL ASSAULT:DEC"                                       
   V1813 = "OTHER-FIREARM:JAN"                                             
   V1814 = "OTHER-FIREARM:FEB"                                             
   V1815 = "OTHER-FIREARM:MAR"                                             
   V1816 = "OTHER-FIREARM:APR"                                             
   V1817 = "OTHER-FIREARM:MAY"                                             
   V1818 = "OTHER-FIREARM:JUN"                                             
   V1819 = "OTHER-FIREARM:JUL"                                             
   V1820 = "OTHER-FIREARM:AUG"                                             
   V1821 = "OTHER-FIREARM:SEP"                                             
   V1822 = "OTHER-FIREARM:OCT"                                             
   V1823 = "OTHER-FIREARM:NOV"                                             
   V1824 = "OTHER-FIREARM:DEC"                                             
   V1825 = "OTHER-KNIFE:JAN"                                               
   V1826 = "OTHER-KNIFE:FEB"                                               
   V1827 = "OTHER-KNIFE:MAR"                                               
   V1828 = "OTHER-KNIFE:APR"                                               
   V1829 = "OTHER-KNIFE:MAY"                                               
   V1830 = "OTHER-KNIFE:JUN"                                               
   V1831 = "OTHER-KNIFE:JUL"                                               
   V1832 = "OTHER-KNIFE:AUG"                                               
   V1833 = "OTHER-KNIFE:SEP"                                               
   V1834 = "OTHER-KNIFE:OCT"                                               
   V1835 = "OTHER-KNIFE:NOV"                                               
   V1836 = "OTHER-KNIFE:DEC"                                               
   V1837 = "OTHER-OTHER:JAN"                                               
   V1838 = "OTHER-OTHER:FEB"                                               
   V1839 = "OTHER-OTHER:MAR"                                               
   V1840 = "OTHER-OTHER:APR"                                               
   V1841 = "OTHER-OTHER:MAY"                                               
   V1842 = "OTHER-OTHER:JUN"                                               
   V1843 = "OTHER-OTHER:JUL"                                               
   V1844 = "OTHER-OTHER:AUG"                                               
   V1845 = "OTHER-OTHER:SEP"                                               
   V1846 = "OTHER-OTHER:OCT"                                               
   V1847 = "OTHER-OTHER:NOV"                                               
   V1848 = "OTHER-OTHER:DEC"                                               
   V1849 = "OTHER-HANDS FEET:JAN"                                          
   V1850 = "OTHER-HANDS FEET:FEB"                                          
   V1851 = "OTHER-HANDS FEET:MAR"                                          
   V1852 = "OTHER-HANDS FEET:APR"                                          
   V1853 = "OTHER-HANDS FEET:MAY"                                          
   V1854 = "OTHER-HANDS FEET:JUN"                                          
   V1855 = "OTHER-HANDS FEET:JUL"                                          
   V1856 = "OTHER-HANDS FEET:AUG"                                          
   V1857 = "OTHER-HANDS FEET:SEP"                                          
   V1858 = "OTHER-HANDS FEET:OCT"                                          
   V1859 = "OTHER-HANDS FEET:NOV"                                          
   V1860 = "OTHER-HANDS FEET:DEC"                                          
   V1861 = "OTHER-2-MAN VEHIC:JAN"                                         
   V1862 = "OTHER-2-MAN VEHIC:FEB"                                         
   V1863 = "OTHER-2-MAN VEHIC:MAR"                                         
   V1864 = "OTHER-2-MAN VEHIC:APR"                                         
   V1865 = "OTHER-2-MAN VEHIC:MAY"                                         
   V1866 = "OTHER-2-MAN VEHIC:JUN"                                         
   V1867 = "OTHER-2-MAN VEHIC:JUL"                                         
   V1868 = "OTHER-2-MAN VEHIC:AUG"                                         
   V1869 = "OTHER-2-MAN VEHIC:SEP"                                         
   V1870 = "OTHER-2-MAN VEHIC:OCT"                                         
   V1871 = "OTHER-2-MAN VEHIC:NOV"                                         
   V1872 = "OTHER-2-MAN VEHIC:DEC"                                         
   V1873 = "OTHER-1-MAN ALONE:JAN"                                         
   V1874 = "OTHER-1-MAN ALONE:FEB"                                         
   V1875 = "OTHER-1-MAN ALONE:MAR"                                         
   V1876 = "OTHER-1-MAN ALONE:APR"                                         
   V1877 = "OTHER-1-MAN ALONE:MAY"                                         
   V1878 = "OTHER-1-MAN ALONE:JUN"                                         
   V1879 = "OTHER-1-MAN ALONE:JUL"                                         
   V1880 = "OTHER-1-MAN ALONE:AUG"                                         
   V1881 = "OTHER-1-MAN ALONE:SEP"                                         
   V1882 = "OTHER-1-MAN ALONE:OCT"                                         
   V1883 = "OTHER-1-MAN ALONE:NOV"                                         
   V1884 = "OTHER-1-MAN ALONE:DEC"                                         
   V1885 = "OTHER-1-MAN ASSIST:JAN"                                        
   V1886 = "OTHER-1-MAN ASSIST:FEB"                                        
   V1887 = "OTHER-1-MAN ASSIST:MAR"                                        
   V1888 = "OTHER-1-MAN ASSIST:APR"                                        
   V1889 = "OTHER-1-MAN ASSIST:MAY"                                        
   V1890 = "OTHER-1-MAN ASSIST:JUN"                                        
   V1891 = "OTHER-1-MAN ASSIST:JUL"                                        
   V1892 = "OTHER-1-MAN ASSIST:AUG"                                        
   V1893 = "OTHER-1-MAN ASSIST:SEP"                                        
   V1894 = "OTHER-1-MAN ASSIST:OCT"                                        
   V1895 = "OTHER-1-MAN ASSIST:NOV"                                        
   V1896 = "OTHER-1-MAN ASSIST:DEC"                                        
   V1897 = "OTHER-DETECT ALONE:JAN"                                        
   V1898 = "OTHER-DETECT ALONE:FEB"                                        
   V1899 = "OTHER-DETECT ALONE:MAR"                                        
   V1900 = "OTHER-DETECT ALONE:APR"                                        
   V1901 = "OTHER-DETECT ALONE:MAY"                                        
   V1902 = "OTHER-DETECT ALONE:JUN"                                        
   V1903 = "OTHER-DETECT ALONE:JUL"                                        
   V1904 = "OTHER-DETECT ALONE:AUG"                                        
   V1905 = "OTHER-DETECT ALONE:SEP"                                        
   V1906 = "OTHER-DETECT ALONE:OCT"                                        
   V1907 = "OTHER-DETECT ALONE:NOV"                                        
   V1908 = "OTHER-DETECT ALONE:DEC"                                        
   V1909 = "OTHER-DETECT ASST:JAN"                                         
   V1910 = "OTHER-DETECT ASST:FEB"                                         
   V1911 = "OTHER-DETECT ASST:MAR"                                         
   V1912 = "OTHER-DETECT ASST:APR"                                         
   V1913 = "OTHER-DETECT ASST:MAY"                                         
   V1914 = "OTHER-DETECT ASST:JUN"                                         
   V1915 = "OTHER-DETECT ASST:JUL"                                         
   V1916 = "OTHER-DETECT ASST:AUG"                                         
   V1917 = "OTHER-DETECT ASST:SEP"                                         
   V1918 = "OTHER-DETECT ASST:OCT"                                         
   V1919 = "OTHER-DETECT ASST:NOV"                                         
   V1920 = "OTHER-DETECT ASST:DEC"                                         
   V1921 = "OTHER-OTHER ALONE:JAN"                                         
   V1922 = "OTHER-OTHER ALONE:FEB"                                         
   V1923 = "OTHER-OTHER ALONE:MAR"                                         
   V1924 = "OTHER-OTHER ALONE:APR"                                         
   V1925 = "OTHER-OTHER ALONE:MAY"                                         
   V1926 = "OTHER-OTHER ALONE:JUN"                                         
   V1927 = "OTHER-OTHER ALONE:JUL"                                         
   V1928 = "OTHER-OTHER ALONE:AUG"                                         
   V1929 = "OTHER-OTHER ALONE:SEP"                                         
   V1930 = "OTHER-OTHER ALONE:OCT"                                         
   V1931 = "OTHER-OTHER ALONE:NOV"                                         
   V1932 = "OTHER-OTHER ALONE:DEC"                                         
   V1933 = "OTHER-OTHER ASSIST:JAN"                                        
   V1934 = "OTHER-OTHER ASSIST:FEB"                                        
   V1935 = "OTHER-OTHER ASSIST:MAR"                                        
   V1936 = "OTHER-OTHER ASSIST:APR"                                        
   V1937 = "OTHER-OTHER ASSIST:MAY"                                        
   V1938 = "OTHER-OTHER ASSIST:JUN"                                        
   V1939 = "OTHER-OTHER ASSIST:JUL"                                        
   V1940 = "OTHER-OTHER ASSIST:AUG"                                        
   V1941 = "OTHER-OTHER ASSIST:SEP"                                        
   V1942 = "OTHER-OTHER ASSIST:OCT"                                        
   V1943 = "OTHER-OTHER ASSIST:NOV"                                        
   V1944 = "OTHER-OTHER ASSIST:DEC"                                        
   V1945 = "OTHER-ASSAULTS CLEAR:JAN"                                      
   V1946 = "OTHER-ASSAULTS CLEAR:FEB"                                      
   V1947 = "OTHER-ASSAULTS CLEAR:MAR"                                      
   V1948 = "OTHER-ASSAULTS CLEAR:APR"                                      
   V1949 = "OTHER-ASSAULTS CLEAR:MAY"                                      
   V1950 = "OTHER-ASSAULTS CLEAR:JUN"                                      
   V1951 = "OTHER-ASSAULTS CLEAR:JUL"                                      
   V1952 = "OTHER-ASSAULTS CLEAR:AUG"                                      
   V1953 = "OTHER-ASSAULTS CLEAR:SEP"                                      
   V1954 = "OTHER-ASSAULTS CLEAR:OCT"                                      
   V1955 = "OTHER-ASSAULTS CLEAR:NOV"                                      
   V1956 = "OTHER-ASSAULTS CLEAR:DEC"                                      
   V1957 = "TOTAL-TOTAL ASSAULT:JAN"                                       
   V1958 = "TOTAL-TOTAL ASSAULT:FEB"                                       
   V1959 = "TOTAL-TOTAL ASSAULT:MAR"                                       
   V1960 = "TOTAL-TOTAL ASSAULT:APR"                                       
   V1961 = "TOTAL-TOTAL ASSAULT:MAY"                                       
   V1962 = "TOTAL-TOTAL ASSAULT:JUN"                                       
   V1963 = "TOTAL-TOTAL ASSAULT:JUL"                                       
   V1964 = "TOTAL-TOTAL ASSAULT:AUG"                                       
   V1965 = "TOTAL-TOTAL ASSAULT:SEP"                                       
   V1966 = "TOTAL-TOTAL ASSAULT:OCT"                                       
   V1967 = "TOTAL-TOTAL ASSAULT:NOV"                                       
   V1968 = "TOTAL-TOTAL ASSAULT:DEC"                                       
   V1969 = "TOTAL-FIREARM:JAN"                                             
   V1970 = "TOTAL-FIREARM:FEB"                                             
   V1971 = "TOTAL-FIREARM:MAR"                                             
   V1972 = "TOTAL-FIREARM:APR"                                             
   V1973 = "TOTAL-FIREARM:MAY"                                             
   V1974 = "TOTAL-FIREARM:JUN"                                             
   V1975 = "TOTAL-FIREARM:JUL"                                             
   V1976 = "TOTAL-FIREARM:AUG"                                             
   V1977 = "TOTAL-FIREARM:SEP"                                             
   V1978 = "TOTAL-FIREARM:OCT"                                             
   V1979 = "TOTAL-FIREARM:NOV"                                             
   V1980 = "TOTAL-FIREARM:DEC"                                             
   V1981 = "TOTAL-KNIFE:JAN"                                               
   V1982 = "TOTAL-KNIFE:FEB"                                               
   V1983 = "TOTAL-KNIFE:MAR"                                               
   V1984 = "TOTAL-KNIFE:APR"                                               
   V1985 = "TOTAL-KNIFE:MAY"                                               
   V1986 = "TOTAL-KNIFE:JUN"                                               
   V1987 = "TOTAL-KNIFE:JUL"                                               
   V1988 = "TOTAL-KNIFE:AUG"                                               
   V1989 = "TOTAL-KNIFE:SEP"                                               
   V1990 = "TOTAL-KNIFE:OCT"                                               
   V1991 = "TOTAL-KNIFE:NOV"                                               
   V1992 = "TOTAL-KNIFE:DEC"                                               
   V1993 = "TOTAL-OTHER:JAN"                                               
   V1994 = "TOTAL-OTHER:FEB"                                               
   V1995 = "TOTAL-OTHER:MAR"                                               
   V1996 = "TOTAL-OTHER:APR"                                               
   V1997 = "TOTAL-OTHER:MAY"                                               
   V1998 = "TOTAL-OTHER:JUN"                                               
   V1999 = "TOTAL-OTHER:JUL"                                               
   V2000 = "TOTAL-OTHER:AUG"                                               
   V2001 = "TOTAL-OTHER:SEP"                                               
   V2002 = "TOTAL-OTHER:OCT"                                               
   V2003 = "TOTAL-OTHER:NOV"                                               
   V2004 = "TOTAL-OTHER:DEC"                                               
   V2005 = "TOTAL-HANDS FEET:JAN"                                          
   V2006 = "TOTAL-HANDS FEET:FEB"                                          
   V2007 = "TOTAL-HANDS FEET:MAR"                                          
   V2008 = "TOTAL-HANDS FEET:APR"                                          
   V2009 = "TOTAL-HANDS FEET:MAY"                                          
   V2010 = "TOTAL-HANDS FEET:JUN"                                          
   V2011 = "TOTAL-HANDS FEET:JUL"                                          
   V2012 = "TOTAL-HANDS FEET:AUG"                                          
   V2013 = "TOTAL-HANDS FEET:SEP"                                          
   V2014 = "TOTAL-HANDS FEET:OCT"                                          
   V2015 = "TOTAL-HANDS FEET:NOV"                                          
   V2016 = "TOTAL-HANDS FEET:DEC"                                          
   V2017 = "TOTAL-2-MAN VEHICLE:JAN"                                       
   V2018 = "TOTAL-2-MAN VEHICLE:FEB"                                       
   V2019 = "TOTAL-2-MAN VEHICLE:MAR"                                       
   V2020 = "TOTAL-2-MAN VEHICLE:APR"                                       
   V2021 = "TOTAL-2-MAN VEHICLE:MAY"                                       
   V2022 = "TOTAL-2-MAN VEHICLE:JUN"                                       
   V2023 = "TOTAL-2-MAN VEHICLE:JUL"                                       
   V2024 = "TOTAL-2-MAN VEHICLE:AUG"                                       
   V2025 = "TOTAL-2-MAN VEHICLE:SEP"                                       
   V2026 = "TOTAL-2-MAN VEHICLE:OCT"                                       
   V2027 = "TOTAL-2-MAN VEHICLE:NOV"                                       
   V2028 = "TOTAL-2-MAN VEHICLE:DEC"                                       
   V2029 = "TOTAL-1-MAN ALONE:JAN"                                         
   V2030 = "TOTAL-1-MAN ALONE:FEB"                                         
   V2031 = "TOTAL-1-MAN ALONE:MAR"                                         
   V2032 = "TOTAL-1-MAN ALONE:APR"                                         
   V2033 = "TOTAL-1-MAN ALONE:MAY"                                         
   V2034 = "TOTAL-1-MAN ALONE:JUN"                                         
   V2035 = "TOTAL-1-MAN ALONE:JUL"                                         
   V2036 = "TOTAL-1-MAN ALONE:AUG"                                         
   V2037 = "TOTAL-1-MAN ALONE:SEP"                                         
   V2038 = "TOTAL-1-MAN ALONE:OCT"                                         
   V2039 = "TOTAL-1-MAN ALONE:NOV"                                         
   V2040 = "TOTAL-1-MAN ALONE:DEC"                                         
   V2041 = "TOTAL-1-MAN ASSIST:JAN"                                        
   V2042 = "TOTAL-1-MAN ASSIST:FEB"                                        
   V2043 = "TOTAL-1-MAN ASSIST:MAR"                                        
   V2044 = "TOTAL-1-MAN ASSIST:APR"                                        
   V2045 = "TOTAL-1-MAN ASSIST:MAY"                                        
   V2046 = "TOTAL-1-MAN ASSIST:JUN"                                        
   V2047 = "TOTAL-1-MAN ASSIST:JUL"                                        
   V2048 = "TOTAL-1-MAN ASSIST:AUG"                                        
   V2049 = "TOTAL-1-MAN ASSIST:SEP"                                        
   V2050 = "TOTAL-1-MAN ASSIST:OCT"                                        
   V2051 = "TOTAL-1-MAN ASSIST:NOV"                                        
   V2052 = "TOTAL-1-MAN ASSIST:DEC"                                        
   V2053 = "TOTAL-DETECT ALONE:JAN"                                        
   V2054 = "TOTAL-DETECT ALONE:FEB"                                        
   V2055 = "TOTAL-DETECT ALONE:MAR"                                        
   V2056 = "TOTAL-DETECT ALONE:APR"                                        
   V2057 = "TOTAL-DETECT ALONE:MAY"                                        
   V2058 = "TOTAL-DETECT ALONE:JUN"                                        
   V2059 = "TOTAL-DETECT ALONE:JUL"                                        
   V2060 = "TOTAL-DETECT ALONE:AUG"                                        
   V2061 = "TOTAL-DETECT ALONE:SEP"                                        
   V2062 = "TOTAL-DETECT ALONE:OCT"                                        
   V2063 = "TOTAL-DETECT ALONE:NOV"                                        
   V2064 = "TOTAL-DETECT ALONE:DEC"                                        
   V2065 = "TOTAL-DETECT ASST:JAN"                                         
   V2066 = "TOTAL-DETECT ASST:FEB"                                         
   V2067 = "TOTAL-DETECT ASST:MAR"                                         
   V2068 = "TOTAL-DETECT ASST:APR"                                         
   V2069 = "TOTAL-DETECT ASST:MAY"                                         
   V2070 = "TOTAL-DETECT ASST:JUN"                                         
   V2071 = "TOTAL-DETECT ASST:JUL"                                         
   V2072 = "TOTAL-DETECT ASST:AUG"                                         
   V2073 = "TOTAL-DETECT ASST:SEP"                                         
   V2074 = "TOTAL-DETECT ASST:OCT"                                         
   V2075 = "TOTAL-DETECT ASST:NOV"                                         
   V2076 = "TOTAL-DETECT ASST:DEC"                                         
   V2077 = "TOTAL-OTHER ALONE:JAN"                                         
   V2078 = "TOTAL-OTHER ALONE:FEB"                                         
   V2079 = "TOTAL-OTHER ALONE:MAR"                                         
   V2080 = "TOTAL-OTHER ALONE:APR"                                         
   V2081 = "TOTAL-OTHER ALONE:MAY"                                         
   V2082 = "TOTAL-OTHER ALONE:JUN"                                         
   V2083 = "TOTAL-OTHER ALONE:JUL"                                         
   V2084 = "TOTAL-OTHER ALONE:AUG"                                         
   V2085 = "TOTAL-OTHER ALONE:SEP"                                         
   V2086 = "TOTAL-OTHER ALONE:OCT"                                         
   V2087 = "TOTAL-OTHER ALONE:NOV"                                         
   V2088 = "TOTAL-OTHER ALONE:DEC"                                         
   V2089 = "TOTAL-OTHER ASSIST:JAN"                                        
   V2090 = "TOTAL-OTHER ASSIST:FEB"                                        
   V2091 = "TOTAL-OTHER ASSIST:MAR"                                        
   V2092 = "TOTAL-OTHER ASSIST:APR"                                        
   V2093 = "TOTAL-OTHER ASSIST:MAY"                                        
   V2094 = "TOTAL-OTHER ASSIST:JUN"                                        
   V2095 = "TOTAL-OTHER ASSIST:JUL"                                        
   V2096 = "TOTAL-OTHER ASSIST:AUG"                                        
   V2097 = "TOTAL-OTHER ASSIST:SEP"                                        
   V2098 = "TOTAL-OTHER ASSIST:OCT"                                        
   V2099 = "TOTAL-OTHER ASSIST:NOV"                                        
   V2100 = "TOTAL-OTHER ASSIST:DEC"                                        
   V2101 = "TOTAL-ASSAULTS CLEAR:JAN"                                      
   V2102 = "TOTAL-ASSAULTS CLEAR:FEB"                                      
   V2103 = "TOTAL-ASSAULTS CLEAR:MAR"                                      
   V2104 = "TOTAL-ASSAULTS CLEAR:APR"                                      
   V2105 = "TOTAL-ASSAULTS CLEAR:MAY"                                      
   V2106 = "TOTAL-ASSAULTS CLEAR:JUN"                                      
   V2107 = "TOTAL-ASSAULTS CLEAR:JUL"                                      
   V2108 = "TOTAL-ASSAULTS CLEAR:AUG"                                      
   V2109 = "TOTAL-ASSAULTS CLEAR:SEP"                                      
   V2110 = "TOTAL-ASSAULTS CLEAR:OCT"                                      
   V2111 = "TOTAL-ASSAULTS CLEAR:NOV"                                      
   V2112 = "TOTAL-ASSAULTS CLEAR:DEC"                                      
   V2113 = "TIME OF ASSLT-01-02:JAN"                                       
   V2114 = "TIME OF ASSLT-01-02:FEB"                                       
   V2115 = "TIME OF ASSLT-01-02:MAR"                                       
   V2116 = "TIME OF ASSLT-01-02:APR"                                       
   V2117 = "TIME OF ASSLT-01-02:MAY"                                       
   V2118 = "TIME OF ASSLT-01-02:JUN"                                       
   V2119 = "TIME OF ASSLT-01-02:JUL"                                       
   V2120 = "TIME OF ASSLT-01-02:AUG"                                       
   V2121 = "TIME OF ASSLT-01-02:SEP"                                       
   V2122 = "TIME OF ASSLT-01-02:OCT"                                       
   V2123 = "TIME OF ASSLT-01-02:NOV"                                       
   V2124 = "TIME OF ASSLT-01-02:DEC"                                       
   V2125 = "TIME OF ASSLT-02-04:JAN"                                       
   V2126 = "TIME OF ASSLT-02-04:FEB"                                       
   V2127 = "TIME OF ASSLT-02-04:MAR"                                       
   V2128 = "TIME OF ASSLT-02-04:APR"                                       
   V2129 = "TIME OF ASSLT-02-04:MAY"                                       
   V2130 = "TIME OF ASSLT-02-04:JUN"                                       
   V2131 = "TIME OF ASSLT-02-04:JUL"                                       
   V2132 = "TIME OF ASSLT-02-04:AUG"                                       
   V2133 = "TIME OF ASSLT-02-04:SEP"                                       
   V2134 = "TIME OF ASSLT-02-04:OCT"                                       
   V2135 = "TIME OF ASSLT-02-04:NOV"                                       
   V2136 = "TIME OF ASSLT-02-04:DEC"                                       
   V2137 = "TIME OF ASSLT-04-06:JAN"                                       
   V2138 = "TIME OF ASSLT-04-06:FEB"                                       
   V2139 = "TIME OF ASSLT-04-06:MAR"                                       
   V2140 = "TIME OF ASSLT-04-06:APR"                                       
   V2141 = "TIME OF ASSLT-04-06:MAY"                                       
   V2142 = "TIME OF ASSLT-04-06:JUN"                                       
   V2143 = "TIME OF ASSLT-04-06:JUL"                                       
   V2144 = "TIME OF ASSLT-04-06:AUG"                                       
   V2145 = "TIME OF ASSLT-04-06:SEP"                                       
   V2146 = "TIME OF ASSLT-04-06:OCT"                                       
   V2147 = "TIME OF ASSLT-04-06:NOV"                                       
   V2148 = "TIME OF ASSLT-04-06:DEC"                                       
   V2149 = "TIME OF ASSLT-06-08:JAN"                                       
   V2150 = "TIME OF ASSLT-06-08:FEB"                                       
   V2151 = "TIME OF ASSLT-06-08:MAR"                                       
   V2152 = "TIME OF ASSLT-06-08:APR"                                       
   V2153 = "TIME OF ASSLT-06-08:MAY"                                       
   V2154 = "TIME OF ASSLT-06-08:JUN"                                       
   V2155 = "TIME OF ASSLT-06-08:JUL"                                       
   V2156 = "TIME OF ASSLT-06-08:AUG"                                       
   V2157 = "TIME OF ASSLT-06-08:SEP"                                       
   V2158 = "TIME OF ASSLT-06-08:OCT"                                       
   V2159 = "TIME OF ASSLT-06-08:NOV"                                       
   V2160 = "TIME OF ASSLT-06-08:DEC"                                       
   V2161 = "TIME OF ASSLT-08-10:JAN"                                       
   V2162 = "TIME OF ASSLT-08-10:FEB"                                       
   V2163 = "TIME OF ASSLT-08-10:MAR"                                       
   V2164 = "TIME OF ASSLT-08-10:APR"                                       
   V2165 = "TIME OF ASSLT-08-10:MAY"                                       
   V2166 = "TIME OF ASSLT-08-10:JUN"                                       
   V2167 = "TIME OF ASSLT-08-10:JUL"                                       
   V2168 = "TIME OF ASSLT-08-10:AUG"                                       
   V2169 = "TIME OF ASSLT-08-10:SEP"                                       
   V2170 = "TIME OF ASSLT-08-10:OCT"                                       
   V2171 = "TIME OF ASSLT-08-10:NOV"                                       
   V2172 = "TIME OF ASSLT-08-10:DEC"                                       
   V2173 = "TIME OF ASSLT-10-12:JAN"                                       
   V2174 = "TIME OF ASSLT-10-12:FEB"                                       
   V2175 = "TIME OF ASSLT-10-12:MAR"                                       
   V2176 = "TIME OF ASSLT-10-12:APR"                                       
   V2177 = "TIME OF ASSLT-10-12:MAY"                                       
   V2178 = "TIME OF ASSLT-10-12:JUN"                                       
   V2179 = "TIME OF ASSLT-10-12:JUL"                                       
   V2180 = "TIME OF ASSLT-10-12:AUG"                                       
   V2181 = "TIME OF ASSLT-10-12:SEP"                                       
   V2182 = "TIME OF ASSLT-10-12:OCT"                                       
   V2183 = "TIME OF ASSLT-10-12:NOV"                                       
   V2184 = "TIME OF ASSLT-10-12:DEC"                                       
   V2185 = "TIME OF ASSLT-12-14:JAN"                                       
   V2186 = "TIME OF ASSLT-12-14:FEB"                                       
   V2187 = "TIME OF ASSLT-12-14:MAR"                                       
   V2188 = "TIME OF ASSLT-12-14:APR"                                       
   V2189 = "TIME OF ASSLT-12-14:MAY"                                       
   V2190 = "TIME OF ASSLT-12-14:JUN"                                       
   V2191 = "TIME OF ASSLT-12-14:JUL"                                       
   V2192 = "TIME OF ASSLT-12-14:AUG"                                       
   V2193 = "TIME OF ASSLT-12-14:SEP"                                       
   V2194 = "TIME OF ASSLT-12-14:OCT"                                       
   V2195 = "TIME OF ASSLT-12-14:NOV"                                       
   V2196 = "TIME OF ASSLT-12-14:DEC"                                       
   V2197 = "TIME OF ASSLT-14-16:JAN"                                       
   V2198 = "TIME OF ASSLT-14-16:FEB"                                       
   V2199 = "TIME OF ASSLT-14-16:MAR"                                       
   V2200 = "TIME OF ASSLT-14-16:APR"                                       
   V2201 = "TIME OF ASSLT-14-16:MAY"                                       
   V2202 = "TIME OF ASSLT-14-16:JUN"                                       
   V2203 = "TIME OF ASSLT-14-16:JUL"                                       
   V2204 = "TIME OF ASSLT-14-16:AUG"                                       
   V2205 = "TIME OF ASSLT-14-16:SEP"                                       
   V2206 = "TIME OF ASSLT-14-16:OCT"                                       
   V2207 = "TIME OF ASSLT-14-16:NOV"                                       
   V2208 = "TIME OF ASSLT-14-16:DEC"                                       
   V2209 = "TIME OF ASSLT-16-18:JAN"                                       
   V2210 = "TIME OF ASSLT-16-18:FEB"                                       
   V2211 = "TIME OF ASSLT-16-18:MAR"                                       
   V2212 = "TIME OF ASSLT-16-18:APR"                                       
   V2213 = "TIME OF ASSLT-16-18:MAY"                                       
   V2214 = "TIME OF ASSLT-16-18:JUN"                                       
   V2215 = "TIME OF ASSLT-16-18:JUL"                                       
   V2216 = "TIME OF ASSLT-16-18:AUG"                                       
   V2217 = "TIME OF ASSLT-16-18:SEP"                                       
   V2218 = "TIME OF ASSLT-16-18:OCT"                                       
   V2219 = "TIME OF ASSLT-16-18:NOV"                                       
   V2220 = "TIME OF ASSLT-16-18:DEC"                                       
   V2221 = "TIME OF ASSLT-18-20:JAN"                                       
   V2222 = "TIME OF ASSLT-18-20:FEB"                                       
   V2223 = "TIME OF ASSLT-18-20:MAR"                                       
   V2224 = "TIME OF ASSLT-18-20:APR"                                       
   V2225 = "TIME OF ASSLT-18-20:MAY"                                       
   V2226 = "TIME OF ASSLT-18-20:JUN"                                       
   V2227 = "TIME OF ASSLT-18-20:JUL"                                       
   V2228 = "TIME OF ASSLT-18-20:AUG"                                       
   V2229 = "TIME OF ASSLT-18-20:SEP"                                       
   V2230 = "TIME OF ASSLT-18-20:OCT"                                       
   V2231 = "TIME OF ASSLT-18-20:NOV"                                       
   V2232 = "TIME OF ASSLT-18-20:DEC"                                       
   V2233 = "TIME OF ASSLT-20-22:JAN"                                       
   V2234 = "TIME OF ASSLT-20-22:FEB"                                       
   V2235 = "TIME OF ASSLT-20-22:MAR"                                       
   V2236 = "TIME OF ASSLT-20-22:APR"                                       
   V2237 = "TIME OF ASSLT-20-22:MAY"                                       
   V2238 = "TIME OF ASSLT-20-22:JUN"                                       
   V2239 = "TIME OF ASSLT-20-22:JUL"                                       
   V2240 = "TIME OF ASSLT-20-22:AUG"                                       
   V2241 = "TIME OF ASSLT-20-22:SEP"                                       
   V2242 = "TIME OF ASSLT-20-22:OCT"                                       
   V2243 = "TIME OF ASSLT-20-22:NOV"                                       
   V2244 = "TIME OF ASSLT-20-22:DEC"                                       
   V2245 = "TIME OF ASSLT-22-24:JAN"                                       
   V2246 = "TIME OF ASSLT-22-24:FEB"                                       
   V2247 = "TIME OF ASSLT-22-24:MAR"                                       
   V2248 = "TIME OF ASSLT-22-24:APR"                                       
   V2249 = "TIME OF ASSLT-22-24:MAY"                                       
   V2250 = "TIME OF ASSLT-22-24:JUN"                                       
   V2251 = "TIME OF ASSLT-22-24:JUL"                                       
   V2252 = "TIME OF ASSLT-22-24:AUG"                                       
   V2253 = "TIME OF ASSLT-22-24:SEP"                                       
   V2254 = "TIME OF ASSLT-22-24:OCT"                                       
   V2255 = "TIME OF ASSLT-22-24:NOV"                                       
   V2256 = "TIME OF ASSLT-22-24:DEC";                                      
                                                                           
* SAS FORMAT STATEMENT;                                                    
/*                                                                         
FORMAT                                                                     
   V5 V5FT.               V7 V7FT.               V8 V8FT.                  
   V11 V11FT.             V12 V12FT.             V55 V55FT.                
   V56 V56FT.             V57 V57FT.             V58 V58FT.                
   V59 V59FT.             V60 V60FT.             V61 V61FT.                
   V62 V62FT.             V63 V63FT.             V64 V64FT.                
   V65 V65FT.             V66 V66FT.             V67 V67FT.                
   V68 V68FT.             V70 V70FT.             V71 V71FT.                
   V72 V72FT.             V73 V73FT.             V74 V74FT.                
   V75 V75FT.             V76 V76FT.             V77 V77FT.                
   V78 V78FT.             V79 V79FT.             V80 V80FT.                
   V81 V81FT.             V82 V82FT.             V83 V83FT.                
   V84 V84FT.             V85 V85FT.             V86 V86FT.                
   V87 V87FT.             V88 V88FT.             V89 V89FT.                
   V90 V90FT.             V91 V91FT.             V92 V92FT.                
   V93 V93FT.             V94 V94FT.             V95 V95FT.                
   V96 V96FT.;                                                             
*/                                                                         
                                                                           
