% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/clean.R
\docType{methods}
\name{remove}
\alias{remove}
\alias{remove_NA}
\alias{remove_NA-method}
\alias{remove_Inf}
\alias{remove_Inf-method}
\alias{remove_empty}
\alias{remove_empty-method}
\alias{remove_zero}
\alias{remove_zero-method}
\alias{remove_NA,matrix-method}
\alias{remove_Inf,matrix-method}
\alias{remove_zero,matrix-method}
\alias{remove_empty,matrix-method}
\title{Data Cleaning}
\usage{
remove_NA(x, ...)

remove_Inf(x, ...)

remove_empty(x, ...)

remove_zero(x, ...)

\S4method{remove_NA}{matrix}(x, margin = 1)

\S4method{remove_Inf}{matrix}(x, margin = 1)

\S4method{remove_zero}{matrix}(x, margin = 1)

\S4method{remove_empty}{matrix}(x, margin = 1)
}
\arguments{
\item{x}{A \code{\link{matrix}}, a \code{\link{data.frame}} or a \verb{*Matrix} object.}

\item{...}{Currently not used.}

\item{margin}{An \code{\link{integer}} giving the subscript which the
cleaning will be applied over (\code{1} indicates rows, \code{2} indicates
columns).}
}
\description{
Removes empty row/column or row/column with \code{\link[=NA]{missing}}/
\code{\link[=is.finite]{infinite}} values or zeros.
}
\examples{
## Create a count data matrix
X <- CountMatrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)
k <- sample(1:25, 3, FALSE)

## Add zeros
X[k] <- 0L
## Remove row with zeros
remove_zero(X, margin = 1)
## Remove column with zeros
remove_zero(X, margin = 2)

## Add NA
X[k] <- NA
## Remove row with zeros
remove_NA(X, margin = 1)
## Remove column with zeros
remove_NA(X, margin = 2)
}
\seealso{
Other utilities: 
\code{\link{replace}()}
}
\author{
N. Frerebeau
}
\concept{utilities}
