% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argonCard.R
\name{argonCard}
\alias{argonCard}
\title{Create a Boostrap 4 card}
\usage{
argonCard(..., title = NULL, src = NULL, hover_lift = FALSE,
  shadow = FALSE, shadow_size = NULL, hover_shadow = FALSE,
  border_level = 0, icon = NULL, status = "primary",
  background_color = NULL, gradient = FALSE, floating = FALSE,
  width = 6)
}
\arguments{
\item{...}{Body content.}

\item{title}{Card title.}

\item{src}{Card external link.}

\item{hover_lift}{Whether to apply a lift effect on hover. FALSE by default.
Not compatible with floating.}

\item{shadow}{Whether to apply a shadow effect. FALSE by default.}

\item{shadow_size}{Card shadow size. Only if shadow is TRUE. NULL by default.}

\item{hover_shadow}{Only if shadow is TRUE. Whether to enlarge the shadow on hover. FALSE by default.}

\item{border_level}{Border level. O by default.}

\item{icon}{Card icon}

\item{status}{Card status. See \url{https://demos.creative-tim.com/argon-design-system/docs/foundation/colors.html}.}

\item{background_color}{Card background color. NULL by default. See \url{https://demos.creative-tim.com/argon-design-system/docs/foundation/colors.html}.}

\item{gradient}{Whether to apply a gradient effect on the card background. FALSE by default.}

\item{floating}{Whether to animate the card by a vertical floating movement. FALSE by default.
Not compatible with hover_lift.}

\item{width}{Card width. Between 1 and 12.}
}
\description{
Build an argon card
}
\examples{
if (interactive()) {
 library(argonR)
 argonCard(
  status = "primary",
  width = 12,
  title = "Card 1",
  hover_lift = TRUE,
  shadow = TRUE,
  icon = "check-bold",
  src = "#",
  "Argon is a great free UI package based on Bootstrap 4 
  that includes the most important components and features."
 )
}


}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
