% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapApp.R
\name{mapApp}
\alias{mapApp}
\title{Interactive App For Viewing Argo Float Positions}
\usage{
mapApp(
  age = argoDefaultIndexAge(),
  server = argoDefaultServer(),
  destdir = argoDefaultDestdir(),
  colLand = "lightgray",
  debug = 0
)
}
\arguments{
\item{age}{numeric value indicating how old a downloaded file
must be (in days), for it to be considered out-of-date.  The
default, \code{\link[=argoDefaultIndexAge]{argoDefaultIndexAge()}}, limits downloads to once per day, as a way
to avoid slowing down a workflow with a download that might take
a minute or so. Note that setting \code{age=0} will force a new
download, regardless of the age of the local file.}

\item{server}{character value, or vector of character values, indicating the name of
servers that supply argo data to be acquired with \code{\link[=getIndex]{getIndex()}}.  If not supplied,
the default will be determined with \code{\link[=argoDefaultServer]{argoDefaultServer()}}, which uses
a value set by \code{options("argoFloats.server"=URL)}
where \code{URL} is an appropriate URL, or \code{"ifremer-https"} if no such option was
set.}

\item{destdir}{character value indicating the directory in which to store
downloaded files. The default value is to compute this using
\code{\link[=argoDefaultDestdir]{argoDefaultDestdir()}}, which returns \verb{~/data/argo} by default,
although it also provides ways to set other values using
\code{\link[=options]{options()}}.
Set \code{destdir=NULL}
if \code{destfile} is a filename with full path information.
File clutter is reduced by creating a top-level directory called
\code{data}, with subdirectories for various file types; see
\dQuote{Examples}.}

\item{colLand}{a colour specification for the land.}

\item{debug}{integer value that controls how much information \code{mapApp()} prints
to the console as it works.  The default value of 0 leads to a fairly limited
amount of printing, while higher values lead to more information. This information
can be helpful in diagnosing problems or bottlenecks.}
}
\value{
\code{mapApp} has no return value, since it creates a shiny app by passing
control to \code{\link[shiny:runApp]{shiny::runApp()}}, which never returns.
}
\description{
The GUI permits specifying a spatial-temporal region of interest, a set
of float types to show, etc.  The interface ought to be reasonably
straightforward, especially for those who take a moment to click on the
Help button and to read the popup window that it creates.
}
\details{
This app will use \code{\link[=getIndex]{getIndex()}} to download index files from the Argo server
the first time it runs, and this make take up to a minute or so.  Then it will combine
information from the core-Argo and BGC-Argo index tables, cross-indexing so
it can determine the Argo type for each profile (or cycle).

The \code{hi-res} button will only affect the coastline, not the topography,
unless there is a local file named \code{topoWorldFine.rda} that contains
an alternative topographic information. Here is how to create such a file:\if{html}{\out{<div class="sourceCode R">}}\preformatted{library(oce)
topoFile <- download.topo(west=-180, east=180,
                          south=-90, north=90,
                          resolution=10,
                          format="netcdf", destdir=".")
topoWorldFine <- read.topo(topoFile)
save(topoWorldFine, file="topoWorldFine.rda")
unlink(topoFile) # clean up
}\if{html}{\out{</div>}}

For more on this app, see section 4 of Kelley et al. (2021).
}
\examples{
if (interactive()) {
    library(argoFloats)
    mapApp()
}

}
\references{
Kelley, D. E., Harbin, J., & Richards, C. (2021). argoFloats: An R package for analyzing
Argo data. Frontiers in Marine Science, (8), 636922.
\doi{10.3389/fmars.2021.635922}
}
\author{
Dan Kelley and Jaimie Harbin
}
