% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locations.R
\name{reporter_addresses}
\alias{reporter_addresses}
\title{Get DEA designated addresses for each Reporter based on REPORTER_DEA_NO (Includes Manufacturers and Distributors)}
\usage{
reporter_addresses(county = "Mingo", state = "WV", key = "WaPo")
}
\arguments{
\item{county}{Filter the data to only this county (e.g. 'Mingo')}

\item{state}{Filter the data to county within this state (e.g. 'WV')}

\item{key}{Key needed to make query successful}
}
\description{
Get DEA designated addresses for each Reporter based on REPORTER_DEA_NO (Includes Manufacturers and Distributors)
}
\examples{
\donttest{
library(arcos)

mingo_wv <- reporter_addresses(county = "Harris", state="TX", key="WaPo")

head(mingo_wv)
}
}
\seealso{
\url{https://www.washingtonpost.com/graphics/2019/investigations/dea-pain-pill-database/#download-resources}

Other geocoded data: \code{\link{buyer_addresses}},
  \code{\link{county_population}},
  \code{\link{not_pharmacies}}, \code{\link{pharm_cbsa}},
  \code{\link{pharm_counties}}, \code{\link{pharm_latlon}},
  \code{\link{pharm_tracts}},
  \code{\link{state_population}}
}
\concept{geocoded data}
