% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTags.R
\name{getTagsLocal}
\alias{getTagsLocal}
\alias{getTagsRemote}
\title{Return Tags Corresponding to md5hash}
\usage{
getTagsLocal(md5hash, repoDir = aoptions("repoDir"), tag = "name")

getTagsRemote(md5hash, repo = aoptions("repo"), user = aoptions("user"),
  branch = aoptions("branch"), subdir = aoptions("subdir"),
  repoType = aoptions("repoType"), tag = "name")
}
\arguments{
\item{md5hash}{A character containing \code{md5hash} 
of artifacts which \code{Tags} are desired to be returned.}

\item{repoDir}{A character denoting an existing directory in 
which artifacts are stored.}

\item{tag}{A regular expression denoting type of a \code{Tag} that we search for
(see \code{Examples}). Default \code{tag = "name"}.}

\item{repo}{While working with the Remote repository. A character containing
a name of the Remote repository on which the Repository is stored.
By default set to \code{NULL} - see \code{Note}.}

\item{user}{While working with the Remote repository. A character containing
a name of the Remote user on whose account the \code{repo} is created.
By default set to \code{NULL} - see \code{Note}.}

\item{branch}{While working with the Remote repository. A character containing
a name of the Remote repository's branch on which the Repository is stored.
Default \code{branch} is \code{master}.}

\item{subdir}{While working with the Remote repository. A character containing
a name of a directory on the Remote repository on which the Repository is stored.
If the Repository is stored in main folder on the Remote repository, this should be set 
to \code{subdir = "/"} as default.}

\item{repoType}{A character containing a type of the remote repository. Currently it can be 'github' or 'bitbucket'.}
}
\value{
The character vector of \code{Tags} (see \link{Tags}) related to \link{md5hash} 
of an artifact.
}
\description{
\code{getTagsLocal} and \code{getTagsRemote} return \code{Tags} (see \link{Tags})
related to \link{md5hash} of an artifact. To learn more about artifacts visit
\link[archivist]{archivist-package}.
}
\details{
\code{getTagsLocal} and \code{getTagsRemote} return \code{Tags}, of a specific type described
by \code{tag} parameter, related to \link{md5hash} of an artifact. To learn more about 
artifacts visit \link[archivist]{archivist-package}.
}
\note{
If \code{repo} and \code{user} are set to \code{NULL} (as default) in Remote mode then global parameters
set in \link{setRemoteRepo} function are used.
}
\examples{

### Local version

## EXAMPLE with pipe operator \%a\%

# Creating empty repository
exampleRepoDir <- tempfile()
createLocalRepo( exampleRepoDir )

library(dplyr)
data(mtcars)
setLocalRepo(repoDir = exampleRepoDir)
hash <- mtcars \%a\% 
 group_by(cyl, am) \%a\%
   select(mpg, cyl, wt, am) \%a\%
     summarise(avgmpg = mean(mpg), avgwt = mean(wt)) \%a\%
       filter(avgmpg > 20) \%a\%
       saveToRepo( exampleRepoDir )
       
showLocalRepo(exampleRepoDir)
showLocalRepo(exampleRepoDir, method = "tags")

# We search for a Tag with default "name" regular expression corresponding to 
# hash md5hash.
getTagsLocal( md5hash = hash, exampleRepoDir )

# Deleting example respository
deleteLocalRepo( exampleRepoDir, TRUE) 
rm( exampleRepoDir ) 

## EXAMPLE with data iris
exampleRepoDir <- tempfile()
createLocalRepo( exampleRepoDir )

data(iris)
saveToRepo(iris, repoDir = exampleRepoDir )
showLocalRepo(exampleRepoDir)
showLocalRepo(exampleRepoDir, method = "tags")

# We can notice that there is only one md5hash 
# (and second for archiveSessionInfo) in repo so we will use it
hash <- showLocalRepo(exampleRepoDir)[1,1]

# We search for a Tag with "varname" regular expression corresponding to 
# hash md5hash.
getTagsLocal( md5hash = hash, exampleRepoDir, tag = "varname" ) 
# There are 5 different Tags with "varname" regular expression

# We needn't use the whole expression "varname". We may use its abbreviation
# and get the same result.
getTagsLocal( md5hash = hash, exampleRepoDir, tag = "varna" ) 

deleteLocalRepo( exampleRepoDir, TRUE) 
rm( exampleRepoDir ) 

### Remote version
## EXAMPLE: pbiecek archivist repository on GitHub

showRemoteRepo(user="pbiecek", repo="archivist")
# We search for a Tag with default "name" regular expression corresponding to 
# "cd6557c6163a6f9800f308f343e75e72" md5hash.
getTagsRemote( "cd6557c6163a6f9800f308f343e75e72",
                user="pbiecek", repo="archivist")
                
## EXAMPLE: many archivist-like Repositories on one Github repository
# We search for a Tag with default "name" regular expression corresponding to 
# "ff575c261c949d073b2895b05d1097c3" md5hash.
getTagsRemote("ff575c261c949d073b2895b05d1097c3", user="MarcinKosinski",
               repo="Museum", branch="master", subdir="ex1")
               

}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}}, \code{\link{aread}},
  \code{\link{asearch}}, \code{\link{asession}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{restoreLibs}}, \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}

Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}}, \code{\link{aread}},
  \code{\link{asearch}}, \code{\link{asession}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{restoreLibs}}, \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}

