% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/setRepo.R
\name{setLocalRepo}
\alias{setGithubRepo}
\alias{setLocalRepo}
\title{Set Repository's Global Path}
\usage{
setLocalRepo(repoDir)

setGithubRepo(user, repo, branch = "master", repoDirGit = FALSE)
}
\arguments{
\item{repoDir}{A character denoting a directory of a Repository that we want to
make dafault. In this way, in the following function calls: \link{saveToRepo},
\link{loadFromLocalRepo},\link{searchInLocalRepo}, \link{rmFromRepo}, \link{zipLocalRepo},
\link{multiSearchInLocalRepo}, \link{addTagsRepo}, \link{shinySearchInLocalRepo},
\link{getTagsLocal}, \link{showLocalRepo}, \link{summaryLocalRepo}
\code{repoDir} parameter may be omitted.}

\item{user}{While working with the Github repository. A character containing
a name of the Github user that we want to make default. In this way,
in the following function calls:
\link{zipGithubRepo}, \link{loadFromGithubRepo}, \link{searchInGithubRepo},
\link{getTagsGithub}, \link{showGithubRepo}, \link{summaryGithubRepo},
\link{multiSearchInGithubRepo}, \link{copyGithubRepo}
\code{user} parameter may be omitted.}

\item{repo}{While working with the Github repository. A character containing
a name of the Github repository that we want to make default. In this way,
in the following function calls:
\link{zipGithubRepo}, \link{loadFromGithubRepo}, \link{searchInGithubRepo},
\link{getTagsGithub}, \link{showGithubRepo}, \link{summaryGithubRepo},
\link{multiSearchInGithubRepo}, \link{copyGithubRepo}
\code{repo} parameter may be omitted.}

\item{branch}{While working with the Github repository. A character containing a name of
the Github Repository's branch that we want to make default. In this way,
in the following function calls:
\link{zipGithubRepo}, \link{loadFromGithubRepo},
\link{searchInGithubRepo}, \link{getTagsGithub}, \link{showGithubRepo},
\link{summaryGithubRepo}, \link{multiSearchInGithubRepo},
\link{copyGithubRepo}
\code{branch} parameter may be omitted. Default \code{branch} is \code{master}.}

\item{repoDirGit}{While working with the Github repository. A character containing a name
of the Repository's directory on Github that we want to make default.
In this way, in the following function calls:
\link{zipGithubRepo}, \link{loadFromGithubRepo}, \link{searchInGithubRepo},
\link{getTagsGithub}, \link{showGithubRepo}, \link{summaryGithubRepo},
\link{multiSearchInGithubRepo}, \link{copyGithubRepo}
\code{repoDirGit} parameter may be omitted.
If the Repository is stored in the main folder on the Github repository,
this should be set to \code{repoDirGit = FALSE} as default.}
}
\description{
\code{setLocalRepo} sets local \link{Repository}'s global path.
\code{setGithubRepo} similarly sets Github Repository's path.
See examples.
}
\details{
If you are working on a local Repository and you are tired of specifying \code{repoDir}
parameter in every function call that uses this parameter, you can set Repository's path
globally using \code{setLocalRepo} function and omit \code{repoDir} parameter
in future function calls.

If you are working on the Github Repository and you are tired of specifying \code{user},
\code{repo}, \code{branch} and \code{repoDirGit} parameters in every function call
that uses these parameters, you can set Github Repository's path globally using
\code{setGithubRepo} function and omit \code{user}, \code{repo}, \code{branch}
and \code{repoDirGit} parameters in future function calls. See examples.
}
\examples{
\dontrun{
## Local version
exampleRepoDir <- tempfile()
createEmptyRepo(repoDir = exampleRepoDir)
setLocalRepo(exampleRepoDir)

data(iris)
data(swiss)

# From this moment repoDir parameter may be ommitted in the following functions
saveToRepo(iris)
saveToRepo(swiss)
showLocalRepo()
showLocalRepo(method = "tags")
iris2 <- loadFromLocalRepo( "ff575c2" , value = TRUE)
searchInLocalRepo("name:i", fixed = F)
getTagsLocal("ff575c261c949d073b2895b05d1097c3")
rmFromRepo("4c43f")
showLocalRepo()
summaryLocalRepo()

# REMEMBER that in deleteRepo you MUST specify repoDir parameter!
# deleteRepo doesn't take setLocalRepo's settings into consideration
deleteRepo( exampleRepoDir, deleteRoot=TRUE)
rm( exampleRepoDir )

## Github version
setGithubRepo( user="MarcinKosinski", repo="Museum", branch="master",
               repoDirGit="ex1" )

# From this moment user, repo, branch, repoDirGit parameters may be ommitted
# in the following functions:
showGithubRepo()
loadFromGithubRepo( "ff575c261c949d073b2895b05d1097c3")
this <- loadFromGithubRepo( "ff", value = T)
zipGithubRepo()
file.remove(file.path(getwd(), "repository.zip")) # We can remove this zip file
searchInGithubRepo( "name:", fixed= FALSE)
getTagsGithub("ff575c261c949d073b2895b05d1097c3")
summaryGithubRepo( )

# To use multisearchInGithubRepo we should use repository with more than one artifact.
setGithubRepo( user="pbiecek", repo="archivist"  )

# From this moment user and repo parameters may be ommitted in the following functions
showGithubRepo()
multiSearchInGithubRepo( patterns=c("varname:Sepal.Width", "class:lm", "name:myplot123"),
                         intersect = FALSE )
}
}
\author{
Marcin Kosinski , \email{m.p.kosinski@gmail.com}
}
\seealso{
\href{https://github.com/pbiecek/archivist/wiki}{https://github.com/pbiecek/archivist/wiki}

Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{agithub}},
  \code{\link{archivist-github-integration}};
  \code{\link{ahistory}}; \code{\link{aoptions}};
  \code{\link{archive}}; \code{\link{archivist-package}};
  \code{\link{aread}}; \code{\link{asearch}};
  \code{\link{cache}}; \code{\link{cloneGithubRepo}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyGithubRepo}},
  \code{\link{createEmptyLocalRepo}},
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{splitTagsGithub}},
  \code{\link{splitTagsLocal}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}

Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{agithub}},
  \code{\link{archivist-github-integration}};
  \code{\link{ahistory}}; \code{\link{aoptions}};
  \code{\link{archive}}; \code{\link{archivist-package}};
  \code{\link{aread}}; \code{\link{asearch}};
  \code{\link{cache}}; \code{\link{cloneGithubRepo}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyGithubRepo}},
  \code{\link{createEmptyLocalRepo}},
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{splitTagsGithub}},
  \code{\link{splitTagsLocal}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

