% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ahistory.R
\name{ahistory}
\alias{ahistory}
\alias{print.ahistory}
\title{Show Artifact's History}
\usage{
ahistory(artifact = NULL, md5hash = NULL, repoDir = NULL)

\method{print}{ahistory}(x, ...)
}
\arguments{
\item{artifact}{An artifact for which history should be derived. Will be converted  into md5hash.}

\item{md5hash}{If \code{artifact} is not specified then \code{md5hash} is used.}

\item{repoDir}{A character denoting an existing directory in which an artifact will be saved.
If set to \code{NULL} (by default), uses the \code{repoDir} specified in \link{setLocalRepo}.}

\item{x}{A character vector of tags.}

\item{...}{A character vector of tags.}
}
\value{
This function returns data frame with two columns - names of calls and md5hashes of partial results.
}
\description{
\code{ahistory} extracts artifact's history and creates a data frame with
history of calls and md5hashes of partial results. The overloaded
\code{print.ahistory} function prints this history in a concise way.
}
\details{
All artifacts created with operator %a% are archivised with
detailed information  about it's source (both call and md5hash of the input).
The function \code{ahistory} reads all artifacts that
precede \code{artifact} and create a description of the input flow.
The generic \code{print.ahistory} function plots the history in a human readable  way.
}
\examples{
\dontrun{
library(dplyr)
iris \%a\%
  filter(Sepal.Length < 6) \%a\%
  lm(Petal.Length~Species, data=.) \%a\%
  summary() -> artifact
# read the artifact history
 asearch(artifact)
}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{aoptions}};
  \code{\link{archivist-package}}; \code{\link{aread}};
  \code{\link{asearch}}; \code{\link{cache}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{setGithubRepo}}, \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}

Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{aoptions}};
  \code{\link{archivist-package}}; \code{\link{aread}};
  \code{\link{asearch}}; \code{\link{cache}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{setGithubRepo}}, \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

