\name{frag.observer.failure}
\alias{frag.observer.failure}

\title{Simulate the failure of an observer to determine the relationships between fragments.}
\description{Simulate the failure of an observer to determine the relationships between fragments.}
\usage{frag.observer.failure(graph, likelihood, remove.vertices=FALSE)}

\arguments{
  \item{graph}{An undirected \code{igraph} object.} 
  \item{likelihood}{Numerical vector of values in [0,1] giving the likelihood of not observing a relationship between two fragments.}
  \item{remove.vertices}{Logical. If TRUE, unconnected vertices are removed.}
}
\details{
In determining connection relationships between archaeological fragments, archaeologists often consider the likelihood that they fail in identifying some of these relationships.
Given an initial fragmentation graph, this function aims to simulate the effects of such different likelihood values.

For each value in the \code{likelihood} parameter, a new graph is generated by randomly removing the given proportion of edges from the input graph.
To generate a series of comparable graphs with different likelihoods, the function internally resets the seed for random number generation, so ensuring that the edges will be removed in the same order when the function is run for multiple likelihood values.

An error message is displayed if at least one of the \code{likelihood} values is < 0 or > 1.
}
\value{
A list of fragmentation graphs (igraph objects).
}
\author{Sebastien Plutniak <sebastien.plutniak at posteo.net>}

\seealso{
\code{\link[base]{set.seed}}
}
\examples{
g <- frag.simul.process(n.components=20, vertices=50, disturbance=.15)
frag.observer.failure(graph=g, likelihood=c(0.05, 0.1), remove.vertices=FALSE)
}
 
\keyword{simulation}
