% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-requests.R
\name{requests}
\alias{requests}
\alias{fetch_layer_metadata}
\alias{count_features}
\title{Retrieve metadata}
\usage{
fetch_layer_metadata(request, token)

count_features(request, token)
}
\arguments{
\item{request}{an \code{\link[httr2:request]{httr2::request}} object. Should be the \code{base_req}
object that is created from a provided feature / server url}

\item{token}{scalar string the \code{access_token} e.g. from \code{auth_code()}
or \code{auth_client()}.}
}
\value{
\itemize{
\item \code{fetch_layer_metadata()} returns a list object
\item \code{count_features()} returns a scalar integer
}
}
\description{
Utility functions for feature service metadata.
}
\details{
\itemize{
\item \code{fetch_layer_metadata()} given a request, fetches the metadata by setting
the query parameter \code{f=json}
\item \code{count_features()} is a simple helper that returns the total number of
features in a feature service ignoring any saved query parameters.
}
}
\examples{
# url is broken into parts to fit within 100 characters to avoid CRAN notes
url_parts <- c(
  "https://services.arcgis.com/P3ePLMYs2RVChkJx/ArcGIS/rest/services",
  "/USA_Counties_Generalized_Boundaries/FeatureServer/0"
)

furl <- paste0(url_parts, collapse = "")
req <- httr2::request(furl)
meta <- fetch_layer_metadata(req, "")
head(names(meta))
count_features(req, "")
}
