% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ssurgo_soil_profile.R
\name{get_ssurgo_soil_profile}
\alias{get_ssurgo_soil_profile}
\title{Retrieve soil profile data and convert it to an object of class \sQuote{soil_profile}}
\usage{
get_ssurgo_soil_profile(
  lonlat,
  shift = -1,
  nmapunit = 1,
  nsoil = 1,
  xout = NULL,
  soil.bottom = 200,
  method = c("constant", "linear"),
  nlayers = 10,
  verbose = FALSE
)
}
\arguments{
\item{lonlat}{Longitude and latitude vector (e.g. c(-93, 42))}

\item{shift}{simple mechanism for creating an area of interest by displacing the point indicated in 
lonlat by some amount of distance (e.g. 300 - in meters)}

\item{nmapunit}{number of mapunits to select (see \code{\link{ssurgo2sp}})}

\item{nsoil}{number of soils to select (see \code{\link{ssurgo2sp}})}

\item{xout}{see \code{\link{ssurgo2sp}}}

\item{soil.bottom}{see \code{\link{ssurgo2sp}}}

\item{method}{interpolation method see \code{\link{ssurgo2sp}}}

\item{nlayers}{number for layer for the new soil profile}

\item{verbose}{default FALSE. Whether to print messages.}
}
\value{
this function will always return a list. Each element of the list will
be an object of class \sQuote{soil_profile}
}
\description{
Generate a synthetic soil profile based on the information in SSURGO database
}
\details{
Data source is USDA-NRCS Soil Data Access. See package soilDB for more details
}
\examples{
\dontrun{
require(soilDB)
require(sp)
require(sf)
require(spData)
## Soil inforation for a single point
sp <- get_ssurgo_soil_profile(lonlat = c(-93, 42))
plot(sp[[1]])
plot(sp[[1]], property = "water")
}


}
