% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca-score.R
\name{score.apd_pca}
\alias{score.apd_pca}
\title{Predict from a \code{apd_pca}}
\usage{
\method{score}{apd_pca}(object, new_data, type = "numeric", ...)
}
\arguments{
\item{object}{A \code{apd_pca} object.}

\item{new_data}{A data frame or matrix of new samples.}

\item{type}{A single character. The type of predictions to generate.
Valid options are:
\itemize{
\item \code{"numeric"} for numeric predictions.
}}

\item{...}{Not used, but required for extensibility.}
}
\value{
A tibble of predictions. The number of rows in the tibble is guaranteed
to be the same as the number of rows in \code{new_data}.
}
\description{
Predict from a \code{apd_pca}
}
\details{
The function computes the principal components of the new data and
their percentiles as compared to the training data. The number of principal
components computed depends on the \code{threshold} given at fit time. It also
computes the multivariate distance between each principal component and its
mean.
}
\examples{
train <- mtcars[1:20,]
test <- mtcars[21:32, -1]

# Fit
mod <- apd_pca(mpg ~ cyl + log(drat), train)

# Predict, with preprocessing
score(mod, test)

}
