% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_nl.R
\name{apollo_nl}
\alias{apollo_nl}
\title{Calculates probabilities of a Nested Logit}
\usage{
apollo_nl(nl_settings, functionality)
}
\arguments{
\item{nl_settings}{List of inputs of the NL model. It shoud contain the following.
\itemize{
   \item \code{alternatives}: Named numeric vector. Names of alternatives and their corresponding value in \code{choiceVar}.
   \item \code{avail}: Named list of numeric vectors or scalars. Availabilities of alternatives, one element per alternative. Names of elements must match those in \code{alternatives}. Values can be 0 or 1.
   \item \code{choiceVar}: Numeric vector. Contains choices for all observations. It will usually be a column from the database. Values are defined in \code{alternatives}.
   \item \code{V}: Named list of deterministic utilities . Utilities of the alternatives. Names of elements must match those in \code{alternatives.}
   \item \code{nlNests}: List of numeric scalars or vectors. Lambda parameters for each nest. Elements must be named with the nest name. The lambda at the root is automatically fixed to 1 if not provided by the user.
   \item \code{nlStructure}: Named list of character vectors. As many elements as nests, it must include the "root". Each element contains the names of the nests or alternatives that belong to it. Element names must match those in \code{nlNests}.
   \item \code{rows}: Boolean vector. Consideration of rows in the likelihood calculation, FALSE to exclude. Length equal to the number of observations (nObs). Default is \code{"all"}, equivalent to \code{rep(TRUE, nObs)}.
   \item \code{componentName}: Character. Name given to model component.
}}

\item{functionality}{Character. Can take different values depending on desired output.
\itemize{
  \item \code{"estimate"}: Used for model estimation.
  \item \code{"prediction"}: Used for model predictions.
  \item \code{"validate"}: Used for validating input.
  \item \code{"zero_LL"}: Used for calculating null likelihood.
  \item \code{"shares_LL"}: Used for calculating likelihood with constants only.
  \item \code{"conditionals"}: Used for calculating conditionals.
  \item \code{"output"}: Used for preparing output after model estimation.
  \item \code{"raw"}: Used for debugging.
}}
}
\value{
The returned object depends on the value of argument \code{functionality} as follows.
        \itemize{
          \item \strong{\code{"estimate"}}: vector/matrix/array. Returns the probabilities for the chosen alternative for each observation.
          \item \strong{\code{"prediction"}}: List of vectors/matrices/arrays. Returns a list with the probabilities for all alternatives, with an extra element for the probability of the chosen alternative.
          \item \strong{\code{"validate"}}: Same as \code{"estimate"}, but it also runs a set of tests to validate the function inputs.
          \item \strong{\code{"zero_LL"}}: vector/matrix/array. Returns the probability of the chosen alternative when all parameters are zero.
          \item \strong{\code{"shares_LL"}}: vector/matrix/array. Returns the probability of the chosen alternative when only constants are estimated.
          \item \strong{\code{"conditionals"}}: Same as \code{"estimate"}
          \item \strong{\code{"output"}}: Same as \code{"estimate"} but also writes summary of input data to internal Apollo log.
          \item \strong{\code{"raw"}}: Same as \code{"prediction"}
        }
}
\description{
Calculates probabilities of a Nested Logit model.
}
\details{
In this implementation of the Nested Logit model, each nest must have a lambda parameter associated to it.
For the model to be consistent with utility maximisation, the estimated value of the Lambda parameter of all nests
should be between 0 and 1. Lambda parameters are inversely proportional to the correlation between the error terms of 
alternatives in a nest. If lambda=1, then there is no relevant correlation between the unobserved
utility of alternatives in that nest.
The tree must contain an upper nest called \code{"root"}. The lambda parameter of the root is automatically
set to 1 if not specified in \code{nlNests}. And while setting it to another value is possible, it is not
recommended.
}
