% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_modelOutput.R
\name{apollo_modelOutput}
\alias{apollo_modelOutput}
\title{Prints estimation results to console}
\usage{
apollo_modelOutput(model, modelOutput_settings = NA)
}
\arguments{
\item{model}{Model object. Estimated model object as returned by function \link{apollo_estimate}.}

\item{modelOutput_settings}{List of options. It can include the following.
\itemize{
  \item \code{printClassical}: Boolean. TRUE for printing classical standard errors. TRUE by default.
  \item \code{printPVal}: Boolean or Scalar. TRUE or 1 for printing p-values for one-sided test, 2 for printing p-values for two-sided test, FALSE for not printing p-values. FALSE by default.
  \item \code{printT1}: Boolean. If TRUE, t-test for H0: apollo_beta=1 are printed. FALSE by default.
  \item \code{printDataReport}: Boolean. TRUE for printing summary of choices in database and other diagnostics. FALSE by default.
  \item \code{printModelStructure}: Boolean. TRUE for printing model structure. TRUE by default.
  \item \code{printCovar}: Boolean. TRUE for printing parameters covariance matrix. If \code{printClassical=TRUE}, both classical and robust matrices are printed. FALSE by default.
  \item \code{printCorr}: Boolean. TRUE for printing parameters correlation matrix. If \code{printClassical=TRUE}, both classical and robust matrices are printed. FALSE by default.
  \item \code{printOutliers}: Boolean or Scalar. TRUE for printing 20 individuals with worst average fit across observations. FALSE by default. If Scalar is given, this replaces the default of 20.
  \item \code{printChange}: Boolean. TRUE for printing difference between starting values and estimates. FALSE by default.
  \item \code{printFunctions}: Boolean. TRUE for printing apollo_control, apollo_randCoeff (when available), apollo_lcPars (when available) and apollo_probabilities. FALSE by default.
}}
}
\value{
A matrix of coefficients, s.d. and t-tests (invisible)
}
\description{
Prints estimation results to console. Amount of information presented can be adjusted through arguments.
}
\details{
Prints to screen the output of a model previously estimated by apollo_estimate()
}
