% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_cnl.R
\name{apollo_cnl}
\alias{apollo_cnl}
\title{Calculates probabilities of a Cross-nested Logit}
\usage{
apollo_cnl(cnl_settings, functionality)
}
\arguments{
\item{cnl_settings}{List of inputs of the CNL model. It should contain the following.
\itemize{
  \item \strong{alternatives}: Named numeric vector. Names of alternatives and their corresponding value in \code{choiceVar}.
  \item \strong{avail}: Named list of numeric vectors or scalars. Availabilities of alternatives, one element per alternative. Names of elements must match those in \code{alternatives}. Values can be 0 or 1.
  \item \strong{choiceVar}: Numeric vector. Contains choices for all observations. It will usually be a column from the database. Values are defined in \code{alternatives}.
  \item \strong{V}: Named list of deterministic utilities . Utilities of the alternatives. Names of elements must match those in \code{alternatives.}
  \item \strong{cnlNests}: List of numeric scalars or vectors. Lambda parameters for each nest. Elements must be named according to nests. The lambda at the root is fixed to 1, and therefore does not need to be defined.
  \item \strong{cnlStructure}: Numeric matrix. One row per nest and one column per alternative. Each element of the matrix is the alpha parameter of that (nest, alternative) pair.
  \item \strong{rows}: Boolean vector. Consideration of rows in the likelihood calculation, FALSE to exclude. Length equal to the number of observations (nObs). Default is \code{"all"}, equivalent to \code{rep(TRUE, nObs)}.
  \item \strong{componentName}: Character. Name given to model component.
}}

\item{functionality}{Character. Can take different values depending on desired output.
\itemize{
  \item "estimate": Used for model estimation.
  \item "prediction": Used for model predictions.
  \item "validate": Used for validating input.
  \item "zero_LL": Used for calculating null likelihood.
  \item "conditionals": Used for calculating conditionals.
  \item "output": Used for preparing output after model estimation.
  \item "raw": Used for debugging.
}}
}
\value{
The returned object depends on the value of argument \code{functionality} as follows.
        \itemize{
          \item \strong{\code{"estimate"}}: vector/matrix/array. Returns the probabilities for the chosen alternative for each observation.
          \item \strong{\code{"prediction"}}: List of vectors/matrices/arrays. Returns a list with the probabilities for all alternatives, with an extra element for the chosen alternative probability.
          \item \strong{\code{"validate"}}: Same as \code{"estimate"}
          \item \strong{\code{"zero_LL"}}: vector/matrix/array. Returns the probability of the chosen alternative when all parameters are zero.
          \item \strong{\code{"conditionals"}}: Same as \code{"estimate"}
          \item \strong{\code{"output"}}: Same as \code{"estimate"} but also writes summary of input data to internal Apollo log.
          \item \strong{\code{"raw"}}: Same as \code{"prediction"}
        }
}
\description{
Calculates probabilities of a Cross-nested Logit model.
}
\details{
For the model to be consistent with utility maximisation, the estimated value of the lambda parameter of all nests
should be between 0 and 1. Lambda parameters are inversely proportional to the correlation between the error terms of 
alternatives in a nest. If lambda=1,  there is no relevant correlation between the unobserved
utility of alternatives in that nest.
The tree must contain an upper nest called \code{"root"}. The lambda parameter of the root is automatically
set to 1 if not specified in \code{nlNests}. And while setting it to another value is possible, it is not
recommended.
Alpha parameters inside \code{cnlStructure} should be between 0 and 1. Using a transformation to ensure
this constraint is satisfied is recommended (e.g. logistic transformation).
}
