% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{aphylo_cv}
\alias{aphylo_cv}
\alias{aphylo_cv.formula}
\title{Leave-one-out Cross Validation}
\usage{
aphylo_cv(...)

\method{aphylo_cv}{formula}(model, ...)
}
\arguments{
\item{...}{Further arguments passed to the method.}

\item{model}{As passed to \link{aphylo_mcmc}.}
}
\value{
An object of class \code{aphylo_cv} with the following components:
\itemize{
\item \code{pred_out} Out of sample prediction.
\item \code{expected} Expected annotations
\item \code{call} The call
\item \code{ids} Integer vector with the ids of the leafs used in the loo process.
}
}
\description{
This implements Leave-one-out cross-validation (LOO-CV) for trees of class
\link{aphylo} and \link{multiAphylo}.
}
\details{
For each observation in the dataset (either a single gene if of
class \link{aphylo}, or an entire tree if of class \link{multiAphylo}), we restimate
the model removing the observation and use the parameter estimates to make
a prediction on it. The prediction is done using the function \link{predict.aphylo_estimates}
with argument \code{loo = TRUE}.
}
\examples{
# It takes about two minutes to run this example
\dontrun{

  set.seed(123)
  atrees <- rmultiAphylo(10, 10, P = 1)

  cv_multi  <- aphylo_cv(atrees ~ mu_d + mu_s + Pi)
  cv_single <- aphylo_cv(atrees[[1]] ~ mu_d + mu_s + Pi)
  
}
}
