% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_join_op.R
\name{sedona_spatial_join}
\alias{sedona_spatial_join}
\title{Perform a spatial join operation on two Sedona spatial RDDs.}
\usage{
sedona_spatial_join(
  spatial_rdd,
  query_window_rdd,
  join_type = c("contain", "intersect"),
  partitioner = c("quadtree", "kdbtree"),
  index_type = c("quadtree", "rtree")
)
}
\arguments{
\item{spatial_rdd}{Spatial RDD containing geometries to be queried.}

\item{query_window_rdd}{Spatial RDD containing the query window(s).}

\item{join_type}{Type of the join query (must be either "contain" or
"intersect").
If \code{join_type} is "contain", then a geometry from \code{spatial_rdd} will match
a geometry from the \code{query_window_rdd} if and only if the former is fully
contained in the latter.
If \code{join_type} is "intersect", then a geometry from \code{spatial_rdd} will
match a geometry from the \code{query_window_rdd} if and only if the former
intersects the latter.}

\item{partitioner}{Spatial partitioning to apply to both \code{spatial_rdd} and
\code{query_window_rdd} to facilitate the join query. Can be either a grid type
(currently "quadtree" and "kdbtree" are supported) or a custom spatial
partitioner object. If \code{partitioner} is NULL, then assume the same spatial
partitioner has been applied to both \code{spatial_rdd} and \code{query_window_rdd}
already and skip the partitioning step.}

\item{index_type}{Controls how \code{spatial_rdd} and \code{query_window_rdd} will be
indexed (unless they are indexed already). If "NONE", then no index will be
constructed and matching geometries will be identified in a doubly nested-
loop iterating through all possible pairs of elements from \code{spatial_rdd}
and \code{query_window_rdd}, which will be inefficient for large data sets.}
}
\value{
A spatial RDD containing the join result.
}
\description{
Given \code{spatial_rdd} and \code{query_window_rdd}, return a pair RDD containing all
pairs of geometrical elements (p, q) such that p is an element of
\code{spatial_rdd}, q is an element of \code{query_window_rdd}, and (p, q) satisfies
the spatial relation specified by \code{join_type}.
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  input_location <- "/dev/null" # replace it with the path to your input file
  rdd <- sedona_read_dsv_to_typed_rdd(
    sc,
    location = input_location,
    delimiter = ",",
    type = "point",
    first_spatial_col_index = 1L
  )
  query_rdd_input_location <- "/dev/null" # replace it with the path to your input file
  query_rdd <- sedona_read_shapefile_to_typed_rdd(
    sc,
    location = query_rdd_input_location,
    type = "polygon"
  )
  join_result_rdd <- sedona_spatial_join(
    rdd,
    query_rdd,
    join_type = "intersect",
    partitioner = "quadtree"
  )
}
}
\seealso{
Other Sedona spatial join operator: 
\code{\link{sedona_spatial_join_count_by_key}()}
}
\concept{Sedona spatial join operator}
