% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_interface.R
\name{as.spark.dataframe}
\alias{as.spark.dataframe}
\title{Import data from a spatial RDD into a Spark Dataframe.}
\usage{
as.spark.dataframe(x, non_spatial_cols = NULL, name = NULL)
}
\arguments{
\item{x}{A spatial RDD.}

\item{non_spatial_cols}{Column names for non-spatial attributes in the
resulting Spark Dataframe.}

\item{name}{Name to assign to the resulting Spark temporary view. If
unspecified, then a random name will be assigned.}
}
\value{
A Spark Dataframe containing the imported spatial data.
}
\description{
Import data from a spatial RDD (possibly with non-spatial attributes) into a
Spark Dataframe.
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  input_location <- "/dev/null" # replace it with the path to your input file
  rdd <- sedona_read_dsv_to_typed_rdd(
    sc,
    location = input_location,
    delimiter = ",",
    type = "point",
    first_spatial_col_index = 1L,
    repartition = 5
  )
  sdf <- as.spark.dataframe(rdd, non_spatial_cols = c("attr1", "attr2"))
}

}
