% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aof.R
\name{aof}
\alias{aof}
\title{aof}
\usage{
aof(name, Age, x)
}
\arguments{
\item{name}{The identity of the insect (e.g. a bee) as factor
(e.g. "A00103C00020C301", "bee1").}

\item{Age}{The age of the insect in day as numeric (e.g. 1, 4, 32).}

\item{x}{The daily activity of the insect at a given age as a numeric value,
for instance (i) the number of the trips per day, (ii) the duration of
the trips per day, or (iii) the time of the trips per day.}
}
\value{
A data.frame containing the aof results (one row per insect).
}
\description{
Ontogenetic shifts in central-place foraging insects
}
\details{
A breakpoint-based method to detect ontogenetic shifts in
univariate time-activity budget series of central-place foraging insects.
The method finds a single change point according to the likelihood function.
The method was developed with honey bees in order to detect the
Age at Onset of Foraging (AOF), but can be used for the detection of other
ontogenetic shifts in other central-place foraging insects. For more
details, see Requier et al. (2020) Measuring ontogenetic shifts in
central-place foraging insects: a case study with honey bees. Journal of
Animal Ecology.
}
\examples{
require("bcpa")

# Exemple with simulated data:
# A study case with with change simulated (i.e. mu1 and mu2 are different)
# --------------------------------------------------
mu1 <- 25  # behavioural value at stage 1
mu2 <- 50
rho1 <- 0.5 # interval frequency at stage 1
rho2 <- rho1
# Low number of individuals (N, n.obs) and low variance (V, sigma)
# create time series from 0 to 50 with a behavioural change at 25
t.full <- 0:50
t.break <- 25
n.obs <- 35 # no. observations randomly selected in the time series: 5 to 45
sigma1 <- 0.1 # variance: 0.1 to 3
sigma2 <- sigma1
SimTS <- function(n, mu, rho, sigma){
  X.standard <- arima.sim(n, model = list(ar = rho))
  X.standard/sd(X.standard)*sigma + mu
}
x.full <- c(SimTS(t.break, mu1, rho1, sigma1),
  SimTS(max(t.full)-t.break+1, mu2, rho2, sigma2))
# subsample of observations (n defined above) and estimate
keep <- sort(sample(1:length(x.full), n.obs))
TimeBudget <- data.frame(
  name = "A",
  Age = t.full[keep],
  x = x.full[keep])
# Running the algorithm
AOF <- aof(
  name = TimeBudget$name,
  Age = TimeBudget$Age,
  x = TimeBudget$x)
print(AOF)

# Exemple with real data extracted from Requier et al.
# (2020, J. Animal Ecology):
# --------------------------------------------------
TimeBudget <- dataExample
# working on Number of trips
varX <- "Number"
AOF_number <- aof(
  name = TimeBudget[,1],
  Age = TimeBudget[,2],
  x = TimeBudget[varX])
print(AOF_number)
# working on Duration of trips
varX <- "Duration"
AOF_duration <- aof(
  name = TimeBudget[,1],
  Age = TimeBudget[,2],
  x = TimeBudget[varX])
print(AOF_duration)
# working on Time of trips
varX <- "Time"
AOF_time <- aof(
  name = TimeBudget[,1],
  Age = TimeBudget[,2],
  x = TimeBudget[varX])
print(AOF_time)

# see vignette for more examples
}
