% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamsMethods.R
\docType{methods}
\name{Params-Methods}
\alias{Params-Methods}
\alias{calcSlopes}
\alias{calcSlopes,ANY-method}
\alias{calcSlopes,AIDS-method}
\alias{calcSlopes,CES-method}
\alias{calcSlopes,CESNests-method}
\alias{calcSlopes,Linear-method}
\alias{calcSlopes,LogLin-method}
\alias{calcSlopes,Logit-method}
\alias{calcSlopes,LogitALM-method}
\alias{calcSlopes,CESALM-method}
\alias{calcSlopes,LogitCap-method}
\alias{calcSlopes,LogitCapALM-method}
\alias{calcSlopes,LogitNests-method}
\alias{calcSlopes,LogitNestsALM-method}
\alias{calcSlopes,PCAIDS-method}
\alias{calcSlopes,PCAIDSNests-method}
\alias{calcSlopes,Auction2ndLogit-method}
\alias{calcSlopes,Auction2ndLogitNests-method}
\alias{calcSlopes,Auction2ndLogitALM-method}
\alias{calcSlopes,Cournot-method}
\alias{calcSlopes,Stackelberg-method}
\alias{calcSlopes,VertBargBertLogit-method}
\alias{calcSlopes,BargainingLogit-method}
\alias{calcSlopes,Bargaining2ndLogit-method}
\alias{getParms}
\alias{getParms,ANY-method}
\alias{getParms,Bertrand-method}
\alias{getParms,VertBargBertLogit-method}
\alias{getNestsParms}
\alias{getNestsParms,PCAIDSNests-method}
\title{Methods for Calculating Demand Parameters}
\usage{
\S4method{calcSlopes}{Cournot}(object)

\S4method{calcSlopes}{Stackelberg}(object)

\S4method{calcSlopes}{Linear}(object)

\S4method{calcSlopes}{Logit}(object)

\S4method{calcSlopes}{LogLin}(object)

\S4method{calcSlopes}{AIDS}(object)

\S4method{calcSlopes}{PCAIDS}(object)

\S4method{calcSlopes}{PCAIDSNests}(object)

\S4method{calcSlopes}{LogitCap}(object)

\S4method{calcSlopes}{LogitNests}(object)

\S4method{calcSlopes}{Auction2ndLogitNests}(object)

\S4method{calcSlopes}{LogitCapALM}(object)

\S4method{calcSlopes}{LogitNestsALM}(object)

\S4method{calcSlopes}{Auction2ndLogit}(object)

\S4method{calcSlopes}{Auction2ndLogitALM}(object)

\S4method{calcSlopes}{LogitALM}(object)

\S4method{calcSlopes}{CES}(object)

\S4method{calcSlopes}{CESALM}(object)

\S4method{calcSlopes}{CESNests}(object)

\S4method{calcSlopes}{BargainingLogit}(object)

\S4method{calcSlopes}{Bargaining2ndLogit}(object)

\S4method{calcSlopes}{VertBargBertLogit}(object)

\S4method{getParms}{Bertrand}(object, digits = 10)

\S4method{getParms}{VertBargBertLogit}(object, digits = 10)

\S4method{getNestsParms}{PCAIDSNests}(object)
}
\arguments{
\item{object}{An instance of the respective class (see description for the classes)}

\item{digits}{Number of significant digits to report. Default is 2.}
}
\description{
The calcSlopes methods calculate demand parameters assuming that firms are playing
a differentitated product Nash-Bertrand pricing game or
(as in the case of the Cournot and Stackelberg classes), a Cournot game.

getNestsParms returns a matrix containing the calibrated nesting parameters.

getParms returns a list of model-specific demand parameters.
\sQuote{digits} specifies the number of significant digit to return (default 10).
}
\keyword{methods}
