% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMCRMethods.R
\docType{methods}
\name{CMCR-Methods}
\alias{CMCR-Methods}
\alias{cmcr-methods}
\alias{cmcr,ANY-method}
\alias{cmcr,Bertrand-method}
\alias{cmcr,Auction2ndLogit-method}
\alias{cmcr,Cournot-method}
\alias{cmcr,AIDS-method}
\title{Methods For Calculating Compensating Marginal Cost Reductions}
\usage{
\S4method{cmcr}{Bertrand}(object, market = FALSE)

\S4method{cmcr}{Cournot}(object, ...)

\S4method{cmcr}{AIDS}(object, market = FALSE)

\S4method{cmcr}{Auction2ndLogit}(object, ...)
}
\arguments{
\item{object}{An instance of one of the classes listed above.}

\item{market}{If TRUE, calculates (post-merger) share-weighted average of metric. Default is FALSE.}

\item{...}{Additional arguments to pass to \code{cmcr}.}
}
\value{
\code{cmcr} returns a vector of length k equal to CMCR for the
merging parties' products and 0 for all other products.
}
\description{
Calculate the marginal cost reductions necessary to restore
premerger prices in a merger, or the Upwards Pricing Pressure Index
for the products of merging firms playing a differentiated
products Bertrand pricing game.
}
\details{
\code{cmcr} uses the results from the merger simulation and calibration
methods associates with a particular class to compute the compensating
marginal cost reduction (CMCR) for each of the merging parties' products.
}
\seealso{
\code{\link{cmcr.bertrand}} is a function that calculates CMCR
without the need to first calibrate a demand system and simulate a
merger.
}
\keyword{methods}
