% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objective-mean-sd.R
\name{mean_sd_obj}
\alias{mean_sd_obj}
\title{An objective function measuring similarity of sets}
\usage{
mean_sd_obj(features, clusters)
}
\arguments{
\item{features}{A matrix or data.frame of data points. Rows
correspond to elements and columns correspond to features.}

\item{clusters}{A clustering vector}
}
\value{
A value quantifying similarity in means and standard deviations. 
    Higher values indicate that means and standard deviations are more
    similar.
}
\description{
Compute the discrepancy in means and standard deviations between clusters.
}
\details{
This function can be passed as the argument \code{objective} to the 
function \code{\link{anticlustering}} to minimize differences in means 
and standard deviations between anticlusters.
}
\examples{
data(schaper2019)
features <- schaper2019[1:48, 3:6]
ac <- anticlustering(
  features,
  K = 3,
  categories = schaper2019$room[1:48],
  objective = mean_sd_obj
)
by(features, ac, function(x) round(colMeans(x), 2))
by(features, ac, function(x) round(apply(x, 2, sd), 2))

}
\author{
Martin Papenberg \email{martin.papenberg@hhu.de}
}
